/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.databinding;

import com.ibm.icu.text.NumberFormat;
import java.text.ParsePosition;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class DecimalValidator
implements IValidator {
    private final NumberFormat formatter;
    private final double min;
    private final double max;
    private final boolean allowEmpty;
    private final String message;

    public DecimalValidator(double min, double max, String message) {
        this(min, max, false, message);
    }

    public DecimalValidator(double min, double max, boolean allowEmpty, String message) {
        this.min = min;
        this.max = max;
        this.allowEmpty = allowEmpty;
        this.message = message;
        this.formatter = NumberFormat.getNumberInstance();
        this.formatter.setParseIntegerOnly(false);
    }

    public IStatus validate(Object value) {
        if (value instanceof String) {
            double n;
            String s = ((String)value).trim();
            if (this.allowEmpty && s.length() == 0) {
                return Status.OK_STATUS;
            }
            ParsePosition result = new ParsePosition(0);
            Number number = this.formatter.parse(s, result);
            if (result.getIndex() == s.length() && result.getErrorIndex() < 0 && (n = number.doubleValue()) >= this.min && n <= this.max) {
                return Status.OK_STATUS;
            }
        }
        return ValidationStatus.error((String)this.message);
    }
}

