/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ltk.ui.sourceediting.assist;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextOperationTarget;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension4;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.statet.ltk.ui.sourceediting.assist.AssistInvocationContext;
import org.eclipse.statet.ltk.ui.sourceediting.assist.IAssistCompletionProposal;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.statushandlers.StatusManager;

public abstract class CompletionProposalWithOverwrite
implements IAssistCompletionProposal,
ICompletionProposalExtension4 {
    private final AssistInvocationContext context;
    private final int replacementOffset;
    private Annotation rememberedOverwriteAnnotation;

    protected CompletionProposalWithOverwrite(AssistInvocationContext context, int startOffset) {
        this.context = context;
        this.replacementOffset = startOffset;
    }

    public AssistInvocationContext getInvocationContext() {
        return this.context;
    }

    public final int getReplacementOffset() {
        return this.replacementOffset;
    }

    protected int computeReplacementLength(int replacementOffset, Point selection, int caretOffset, boolean overwrite) throws BadLocationException {
        int end = Math.max(caretOffset, selection.x + selection.y);
        return end - replacementOffset;
    }

    private boolean isInOverwriteMode(boolean toggle) {
        return toggle;
    }

    protected abstract String getPluginId();

    public final void selected(ITextViewer viewer, boolean smartToggle) {
        if (this.isInOverwriteMode(smartToggle)) {
            this.addOverwriteStyle();
        } else {
            this.repairPresentation();
        }
    }

    public final void unselected(ITextViewer viewer) {
        this.repairPresentation();
    }

    public void apply(IDocument document) {
    }

    public final void apply(ITextViewer viewer, char trigger, int stateMask, int offset) {
        assert (this.context.getSourceViewer() == viewer);
        boolean smartToggle = (stateMask & 0x40000) != 0;
        try {
            int replacementOffset = this.getReplacementOffset();
            int replacementLength = this.computeReplacementLength(replacementOffset, viewer.getSelectedRange(), offset, this.isInOverwriteMode(smartToggle));
            if (this.validate(viewer.getDocument(), offset, null)) {
                this.doApply(trigger, stateMask, offset, replacementOffset, replacementLength);
                return;
            }
        }
        catch (BadLocationException e) {
            StatusManager.getManager().handle((IStatus)new Status(4, this.getPluginId(), "Failed to apply completion proposal.", (Throwable)e));
        }
        Display.getCurrent().beep();
    }

    protected abstract void doApply(char var1, int var2, int var3, int var4, int var5) throws BadLocationException;

    protected void reinvokeAssist(ITextViewer viewer) {
        if (viewer instanceof ITextOperationTarget) {
            final ITextOperationTarget target = (ITextOperationTarget)viewer;
            Display.getCurrent().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (target.canDoOperation(13)) {
                        target.doOperation(13);
                    }
                }
            });
        }
    }

    private void addOverwriteStyle() {
        int replacementLength;
        SourceViewer viewer = this.context.getSourceViewer();
        StyledText text = viewer.getTextWidget();
        if (text == null || text.isDisposed()) {
            return;
        }
        int widgetCaret = viewer.getTextWidget().getCaretOffset();
        int modelCaret = viewer.widgetOffset2ModelOffset(widgetCaret);
        int replacementOffset = this.getReplacementOffset();
        try {
            replacementLength = this.computeReplacementLength(replacementOffset, viewer.getSelectedRange(), modelCaret, true);
        }
        catch (BadLocationException e) {
            replacementLength = -1;
        }
        if (replacementLength < 0 || modelCaret >= replacementOffset + replacementLength) {
            this.repairPresentation();
            return;
        }
        int offset = widgetCaret;
        int length = replacementOffset + replacementLength - modelCaret;
        this.repairPresentation();
        this.rememberedOverwriteAnnotation = new Annotation("org.eclipse.statet.ecommons.text.editorAnnotations.ContentAssistOverwrite", false, "");
        viewer.getAnnotationModel().addAnnotation(this.rememberedOverwriteAnnotation, new Position(offset, length));
    }

    private void repairPresentation() {
        SourceViewer viewer = this.context.getSourceViewer();
        if (this.rememberedOverwriteAnnotation != null) {
            viewer.getAnnotationModel().removeAnnotation(this.rememberedOverwriteAnnotation);
            this.rememberedOverwriteAnnotation = null;
        }
    }
}

