/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.docmlet.tex.ui.editors;

import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.statet.docmlet.tex.core.model.ITexSourceUnit;
import org.eclipse.statet.docmlet.tex.core.model.TexModel;
import org.eclipse.statet.docmlet.tex.core.source.LtxDocumentSetupParticipant;
import org.eclipse.statet.docmlet.tex.ui.editors.TexEditorBuild;
import org.eclipse.statet.ecommons.preferences.PreferencesUtil;
import org.eclipse.statet.ecommons.preferences.SettingsChangeNotifier;
import org.eclipse.statet.ecommons.preferences.core.Preference;
import org.eclipse.statet.ecommons.preferences.core.PreferenceAccess;
import org.eclipse.statet.ecommons.preferences.core.util.PreferenceUtils;
import org.eclipse.statet.ecommons.text.PartitionerDocumentSetupParticipant;
import org.eclipse.statet.jcommons.lang.Disposable;
import org.eclipse.statet.ltk.core.LTK;
import org.eclipse.statet.ltk.issues.core.Problem;
import org.eclipse.statet.ltk.model.core.elements.ISourceUnit;
import org.eclipse.statet.ltk.ui.sourceediting.SourceAnnotationModel;
import org.eclipse.statet.ltk.ui.sourceediting.SourceDocumentProvider;
import org.eclipse.statet.ltk.ui.sourceediting.SourceProblemAnnotation;

public class LtxDocumentProvider
extends SourceDocumentProvider<ITexSourceUnit>
implements Disposable {
    private SettingsChangeNotifier.ChangeListener editorPrefListener = new SettingsChangeNotifier.ChangeListener(){

        public void settingsChanged(Set<String> groupIds) {
            if (groupIds.contains("Tex/editor/build")) {
                LtxDocumentProvider.this.updateEditorPrefs();
            }
        }
    };
    private boolean handleTemporaryProblems;

    public LtxDocumentProvider() {
        super("Ltx", (PartitionerDocumentSetupParticipant)new LtxDocumentSetupParticipant());
        PreferencesUtil.getSettingsChangeNotifier().addChangeListener(this.editorPrefListener);
        PreferenceAccess access = PreferenceUtils.getInstancePrefs();
        this.handleTemporaryProblems = (Boolean)access.getPreferenceValue((Preference)TexEditorBuild.PROBLEMCHECKING_ENABLED_PREF);
    }

    public void dispose() {
        if (this.editorPrefListener != null) {
            PreferencesUtil.getSettingsChangeNotifier().removeChangeListener(this.editorPrefListener);
            this.editorPrefListener = null;
        }
    }

    private void updateEditorPrefs() {
        PreferenceAccess access = PreferenceUtils.getInstancePrefs();
        boolean newHandleTemporaryProblems = (Boolean)access.getPreferenceValue((Preference)TexEditorBuild.PROBLEMCHECKING_ENABLED_PREF);
        if (this.handleTemporaryProblems != newHandleTemporaryProblems) {
            this.handleTemporaryProblems = newHandleTemporaryProblems;
            if (this.handleTemporaryProblems) {
                TexModel.getLtxModelManager().refresh(LTK.EDITOR_CONTEXT);
            } else {
                List sus = LTK.getSourceUnitManager().getOpenSourceUnits("Ltx", LTK.EDITOR_CONTEXT);
                for (ISourceUnit su : sus) {
                    IAnnotationModel model = this.getAnnotationModel(su);
                    if (!(model instanceof ThisAnnotationModel)) continue;
                    ((ThisAnnotationModel)model).clearProblems(null);
                }
            }
        }
    }

    protected IAnnotationModel createAnnotationModel(IFile file) {
        return new ThisAnnotationModel((IResource)file);
    }

    private class ThisAnnotationModel
    extends SourceAnnotationModel {
        public ThisAnnotationModel(IResource resource) {
            super(resource);
        }

        protected boolean isHandlingTemporaryProblems() {
            return LtxDocumentProvider.this.handleTemporaryProblems;
        }

        protected SourceProblemAnnotation createAnnotation(Problem problem) {
            if (problem.getCategoryId() == "Ltx") {
                switch (problem.getSeverity()) {
                    case 2: {
                        return new SourceProblemAnnotation("org.eclipse.statet.docmlet.tex.ui.error", problem, SourceProblemAnnotation.ERROR_CONFIG);
                    }
                    case 1: {
                        return new SourceProblemAnnotation("org.eclipse.statet.docmlet.tex.ui.warning", problem, SourceProblemAnnotation.WARNING_CONFIG);
                    }
                }
                return new SourceProblemAnnotation("org.eclipse.statet.docmlet.tex.ui.info", problem, SourceProblemAnnotation.INFO_CONFIG);
            }
            return null;
        }
    }
}

