/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.r.console.ui.tools;

import java.net.URI;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.databinding.wizard.WizardPageSupport;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.statet.ecommons.ui.dialogs.DialogUtils;
import org.eclipse.statet.ecommons.ui.util.LayoutUtils;
import org.eclipse.statet.ecommons.ui.util.UIAccess;
import org.eclipse.statet.ecommons.ui.workbench.ResourceInputComposite;
import org.eclipse.statet.internal.r.console.ui.Messages;
import org.eclipse.statet.internal.r.console.ui.RConsoleUIPlugin;
import org.eclipse.statet.jcommons.ts.core.ToolProvider;
import org.eclipse.statet.jcommons.ts.core.ToolRunnable;
import org.eclipse.statet.nico.core.runtime.ToolProcess;
import org.eclipse.statet.nico.ui.actions.ToolAction;
import org.eclipse.statet.nico.ui.util.NicoWizardDialog;
import org.eclipse.statet.nico.ui.util.ToolInfoGroup;
import org.eclipse.statet.r.console.ui.tools.ChangeWDRunnable;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class ChangeWorkingDirectoryWizard
extends Wizard {
    ToolProcess fTool;
    SelectWDDialog fPage;

    public ChangeWorkingDirectoryWizard(ToolProcess tool) {
        this.fTool = tool;
        this.setDialogSettings(DialogUtils.getDialogSettings((AbstractUIPlugin)RConsoleUIPlugin.getInstance(), (String)"r/tools/changeWorkingDir-Wizard"));
        this.setWindowTitle(Messages.ChangeWorkingDir_Task_label);
        this.setNeedsProgressMonitor(false);
    }

    public void addPages() {
        this.fPage = new SelectWDDialog();
        this.addPage((IWizardPage)this.fPage);
    }

    public boolean performFinish() {
        this.fPage.saveSettings();
        ChangeWDRunnable runnable = new ChangeWDRunnable(this.fPage.getResource());
        this.fTool.getQueue().add((ToolRunnable)runnable);
        return true;
    }

    public static class ChangeAction
    extends ToolAction {
        public ChangeAction(ToolProvider support) {
            super(support, true);
            this.setId("org.eclipse.statet.r.tools.ChangeWorkingDirectory");
            this.setText(Messages.ChangeWorkingDir_Action_label);
        }

        public void run() {
            ToolProcess tool = this.getTool();
            if (tool == null) {
                return;
            }
            ChangeWorkingDirectoryWizard wizard = new ChangeWorkingDirectoryWizard(tool);
            NicoWizardDialog dialog = new NicoWizardDialog(UIAccess.getActiveWorkbenchShell((boolean)true), (IWizard)wizard);
            dialog.setBlockOnOpen(false);
            dialog.open();
        }
    }

    private class SelectWDDialog
    extends WizardPage {
        private static final String SETTINGS_HISTORY = "statet:location.workingdir";
        private final WritableValue fNewLocationString;
        private ResourceInputComposite fLocationGroup;
        private DataBindingContext fDbc;

        public SelectWDDialog() {
            super("ChangeWorkingDirectory");
            this.setTitle(Messages.ChangeWorkingDir_SelectDialog_title);
            this.setDescription(Messages.ChangeWorkingDir_SelectDialog_message);
            Realm realm = Realm.getDefault();
            this.fNewLocationString = new WritableValue(realm, (Object)"", String.class);
        }

        public void createControl(Composite parent) {
            this.initializeDialogUnits((Control)parent);
            Composite container = new Composite(parent, 0);
            container.setLayoutData((Object)new GridData(4, 4, true, true));
            container.setLayout((Layout)new GridLayout());
            this.setControl((Control)container);
            this.createContents(container);
            LayoutUtils.addSmallFiller((Composite)container, (boolean)true);
            ToolInfoGroup info = new ToolInfoGroup(container, ChangeWorkingDirectoryWizard.this.fTool);
            info.getControl().setLayoutData((Object)new GridData(4, 4, true, false));
            Dialog.applyDialogFont((Control)container);
            this.setErrorMessage(null);
            this.setMessage(null);
        }

        protected void createContents(Composite container) {
            IPath path;
            this.fLocationGroup = new ResourceInputComposite(container, 1, 10, Messages.ChangeWorkingDir_Resource_label);
            this.fLocationGroup.setLayoutData((Object)new GridData(4, 4, true, false));
            this.fLocationGroup.setHistory(this.getDialogSettings().getArray(SETTINGS_HISTORY));
            IFileStore current = ChangeWorkingDirectoryWizard.this.fTool.getWorkspaceData().getWorkspaceDir();
            String dir = "";
            if (current != null && (path = URIUtil.toPath((URI)current.toURI())) != null) {
                dir = path.toOSString();
            }
            Realm realm = Realm.getDefault();
            this.fDbc = new DataBindingContext(realm);
            this.fDbc.bindValue(this.fLocationGroup.getObservable(), (IObservableValue)this.fNewLocationString, new UpdateValueStrategy().setAfterGetValidator((IValidator)this.fLocationGroup.getValidator()), null);
            WizardPageSupport.create((WizardPage)this, (DataBindingContext)this.fDbc);
        }

        public void saveSettings() {
            IDialogSettings settings = this.getDialogSettings();
            DialogUtils.saveHistorySettings((IDialogSettings)settings, (String)SETTINGS_HISTORY, (String)((String)this.fNewLocationString.getValue()));
        }

        public IFileStore getResource() {
            return this.fLocationGroup.getResourceAsFileStore();
        }

        public void dispose() {
            if (this.fDbc != null) {
                this.fDbc.dispose();
                this.fDbc = null;
            }
            super.dispose();
        }
    }
}

