/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.apps.ui.launching;

import java.util.IdentityHashMap;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.osgi.util.NLS;
import org.eclipse.statet.ecommons.debug.ui.config.LaunchConfigManager;
import org.eclipse.statet.ecommons.debug.ui.config.LaunchConfigPresets;
import org.eclipse.statet.internal.r.apps.ui.Messages;
import org.eclipse.statet.internal.r.apps.ui.launching.AppControlConfigTabGroup;
import org.eclipse.statet.internal.r.apps.ui.launching.AppType;
import org.eclipse.statet.jcommons.collections.IdentitySet;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;

@NonNullByDefault
public class AppControlManager
extends LaunchConfigManager<IContainer> {
    private final AppType appType;

    public AppControlManager(AppType appType) {
        super(appType.getId(), "org.eclipse.statet.r.apps.launchConfigurations.RAppControl");
        this.appType = appType;
    }

    protected Map<String, Object> createRunAttributes(IContainer element, IdentitySet<String> flags) {
        IdentityHashMap<String, Object> map = new IdentityHashMap<String, Object>(4);
        if (element != null) {
            map.put("org.eclipse.statet.r.apps/AppSource.path", element.getFullPath().toPortableString());
        }
        return map;
    }

    protected String getActionLabel(byte bits) {
        switch (bits) {
            case 0: {
                return Messages.RunAction_RunApp_label;
            }
        }
        throw new IllegalArgumentException();
    }

    protected String getAutogenConfigName() {
        String name = this.appType.getName();
        if (name.startsWith("R ")) {
            name = name.substring(2);
        }
        return NLS.bind((String)"Run {0} and Show in Eclipse", (Object)name);
    }

    protected void initAutogenConfig(ILaunchConfigurationWorkingCopy config) {
        AppControlConfigTabGroup.initDefaults(config);
        ILaunchConfiguration preset = AppControlConfigTabGroup.getPresets().get(this.appType.getName());
        if (preset != null) {
            LaunchConfigPresets.apply((ILaunchConfiguration)preset, (ILaunchConfigurationWorkingCopy)config);
        }
    }
}

