/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.ui.menu;

import org.eclipse.statet.ecommons.waltable.NatTable;
import org.eclipse.statet.ecommons.waltable.ui.menu.IMenuItemProvider;
import org.eclipse.statet.ecommons.waltable.ui.menu.MenuItemProviders;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;

public class PopupMenuBuilder {
    protected NatTable natTable;
    protected Menu popupMenu;

    public PopupMenuBuilder(NatTable parent) {
        this.natTable = parent;
        this.popupMenu = new Menu((Control)parent.getShell());
    }

    public PopupMenuBuilder(NatTable natTable, Menu menu) {
        this.natTable = natTable;
        this.popupMenu = menu;
    }

    public PopupMenuBuilder withMenuItemProvider(IMenuItemProvider menuItemProvider) {
        menuItemProvider.addMenuItem(this.natTable, this.popupMenu);
        return this;
    }

    public PopupMenuBuilder withAutoResizeSelectedColumnsMenuItem() {
        return this.withMenuItemProvider(MenuItemProviders.autoResizeColumnMenuItemProvider());
    }

    public PopupMenuBuilder withAutoResizeSelectedColumnsMenuItem(String menuLabel) {
        return this.withMenuItemProvider(MenuItemProviders.autoResizeColumnMenuItemProvider(menuLabel));
    }

    public PopupMenuBuilder withAutoResizeSelectedRowsMenuItem() {
        return this.withMenuItemProvider(MenuItemProviders.autoResizeRowMenuItemProvider());
    }

    public PopupMenuBuilder withAutoResizeSelectedRowsMenuItem(String menuLabel) {
        return this.withMenuItemProvider(MenuItemProviders.autoResizeRowMenuItemProvider(menuLabel));
    }

    public PopupMenuBuilder withColumnStyleEditor() {
        return this.withMenuItemProvider(MenuItemProviders.columnStyleEditorMenuItemProvider());
    }

    public PopupMenuBuilder withColumnStyleEditor(String menuLabel) {
        return this.withMenuItemProvider(MenuItemProviders.columnStyleEditorMenuItemProvider(menuLabel));
    }

    public PopupMenuBuilder withInspectLabelsMenuItem() {
        return this.withMenuItemProvider(MenuItemProviders.inspectLabelsMenuItemProvider());
    }

    public PopupMenuBuilder withStateManagerMenuItemProvider() {
        return this.withMenuItemProvider(MenuItemProviders.stateManagerMenuItemProvider());
    }

    public PopupMenuBuilder withStateManagerMenuItemProvider(String menuLabel) {
        return this.withMenuItemProvider(MenuItemProviders.stateManagerMenuItemProvider(menuLabel));
    }

    public PopupMenuBuilder withSeparator() {
        return this.withMenuItemProvider(MenuItemProviders.separatorMenuItemProvider());
    }

    public Menu build() {
        return this.popupMenu;
    }
}

