/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.selection;

import java.util.Collection;
import org.eclipse.statet.ecommons.waltable.coordinate.LRange;
import org.eclipse.statet.ecommons.waltable.coordinate.LRangeList;
import org.eclipse.statet.ecommons.waltable.coordinate.Orientation;
import org.eclipse.statet.ecommons.waltable.layer.ILayer;
import org.eclipse.statet.ecommons.waltable.layer.event.ColumnVisualChangeEvent;
import org.eclipse.statet.ecommons.waltable.selection.ISelectionEvent;
import org.eclipse.statet.ecommons.waltable.selection.SelectionLayer;

public class ColumnSelectionEvent
extends ColumnVisualChangeEvent
implements ISelectionEvent {
    private final SelectionLayer selectionLayer;
    private long columnPositionToReveal;

    public ColumnSelectionEvent(SelectionLayer selectionLayer, long columnPosition, boolean revealColumn) {
        this(selectionLayer, new LRangeList(columnPosition), revealColumn ? columnPosition : Long.MIN_VALUE);
    }

    public ColumnSelectionEvent(SelectionLayer selectionLayer, Collection<LRange> columnPositions, long columnPositionToReveal) {
        super((ILayer)selectionLayer, columnPositions);
        this.selectionLayer = selectionLayer;
        this.columnPositionToReveal = columnPositionToReveal;
    }

    protected ColumnSelectionEvent(ColumnSelectionEvent event) {
        super(event);
        this.selectionLayer = event.selectionLayer;
        this.columnPositionToReveal = event.columnPositionToReveal;
    }

    @Override
    public ColumnSelectionEvent cloneEvent() {
        return new ColumnSelectionEvent(this);
    }

    @Override
    public SelectionLayer getSelectionLayer() {
        return this.selectionLayer;
    }

    public long getColumnPositionToReveal() {
        return this.columnPositionToReveal;
    }

    @Override
    public boolean convertToLocal(ILayer localLayer) {
        if (this.columnPositionToReveal != Long.MIN_VALUE) {
            this.columnPositionToReveal = localLayer.getDim(Orientation.HORIZONTAL).underlyingToLocalPosition(this.getLayer().getDim(Orientation.HORIZONTAL), this.columnPositionToReveal);
        }
        return super.convertToLocal(localLayer);
    }
}

