/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.painter.cell;

import org.eclipse.statet.ecommons.waltable.config.IConfigRegistry;
import org.eclipse.statet.ecommons.waltable.coordinate.LRectangle;
import org.eclipse.statet.ecommons.waltable.layer.cell.ILayerCell;
import org.eclipse.statet.ecommons.waltable.painter.cell.CellPainterWrapper;
import org.eclipse.statet.ecommons.waltable.painter.cell.GraphicsUtils;
import org.eclipse.statet.ecommons.waltable.painter.cell.ICellPainter;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Pattern;
import org.eclipse.swt.widgets.Display;

public class BackgroundImagePainter
extends CellPainterWrapper {
    public final Color separatorColor;
    private final Image bgImage;

    public BackgroundImagePainter(ICellPainter interiorPainter, Image bgImage, Color separatorColor) {
        super(interiorPainter);
        this.bgImage = bgImage;
        this.separatorColor = separatorColor;
    }

    @Override
    public long getPreferredWidth(ILayerCell cell, GC gc, IConfigRegistry configRegistry) {
        return super.getPreferredWidth(cell, gc, configRegistry) + 4L;
    }

    @Override
    public long getPreferredHeight(ILayerCell cell, GC gc, IConfigRegistry configRegistry) {
        return super.getPreferredHeight(cell, gc, configRegistry) + 4L;
    }

    @Override
    public void paintCell(ILayerCell cell, GC gc, LRectangle lRectangle, IConfigRegistry configRegistry) {
        Color originalBackground = gc.getBackground();
        Color originalForeground = gc.getForeground();
        Pattern pattern = new Pattern((Device)Display.getCurrent(), this.bgImage);
        gc.setBackgroundPattern(pattern);
        gc.fillRectangle(GraphicsUtils.safe(lRectangle));
        gc.setBackgroundPattern(null);
        pattern.dispose();
        if (this.separatorColor != null) {
            gc.setForeground(this.separatorColor);
            gc.drawLine(GraphicsUtils.safe(lRectangle.x - 1L), GraphicsUtils.safe(lRectangle.y), GraphicsUtils.safe(lRectangle.x - 1L), GraphicsUtils.safe(lRectangle.y + lRectangle.height));
            gc.drawLine(GraphicsUtils.safe(lRectangle.x - 1L + lRectangle.width), GraphicsUtils.safe(lRectangle.y), GraphicsUtils.safe(lRectangle.x - 1L + lRectangle.width), GraphicsUtils.safe(lRectangle.y + lRectangle.height));
        }
        gc.setBackground(originalBackground);
        gc.setForeground(originalForeground);
        LRectangle interiorBounds = new LRectangle(GraphicsUtils.safe(lRectangle.x + 2L), GraphicsUtils.safe(lRectangle.y + 2L), GraphicsUtils.safe(lRectangle.width - 4L), GraphicsUtils.safe(lRectangle.height - 4L));
        super.paintCell(cell, gc, interiorBounds, configRegistry);
    }
}

