/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.statet.ecommons.waltable.NatTableDim;
import org.eclipse.statet.ecommons.waltable.command.DisposeResourcesCommand;
import org.eclipse.statet.ecommons.waltable.command.ILayerCommand;
import org.eclipse.statet.ecommons.waltable.command.ILayerCommandHandler;
import org.eclipse.statet.ecommons.waltable.command.StructuralRefreshCommand;
import org.eclipse.statet.ecommons.waltable.config.ConfigRegistry;
import org.eclipse.statet.ecommons.waltable.config.DefaultNatTableStyleConfiguration;
import org.eclipse.statet.ecommons.waltable.config.IConfigRegistry;
import org.eclipse.statet.ecommons.waltable.config.IConfiguration;
import org.eclipse.statet.ecommons.waltable.conflation.EventConflaterChain;
import org.eclipse.statet.ecommons.waltable.conflation.IEventConflater;
import org.eclipse.statet.ecommons.waltable.conflation.VisualChangeEventConflater;
import org.eclipse.statet.ecommons.waltable.coordinate.LRectangle;
import org.eclipse.statet.ecommons.waltable.coordinate.Orientation;
import org.eclipse.statet.ecommons.waltable.coordinate.PixelOutOfBoundsException;
import org.eclipse.statet.ecommons.waltable.edit.ActiveCellEditorRegistry;
import org.eclipse.statet.ecommons.waltable.grid.ClientAreaResizeCommand;
import org.eclipse.statet.ecommons.waltable.grid.InitializeGridCommand;
import org.eclipse.statet.ecommons.waltable.layer.ILayer;
import org.eclipse.statet.ecommons.waltable.layer.ILayerListener;
import org.eclipse.statet.ecommons.waltable.layer.LabelStack;
import org.eclipse.statet.ecommons.waltable.layer.cell.ILayerCell;
import org.eclipse.statet.ecommons.waltable.layer.event.ILayerEvent;
import org.eclipse.statet.ecommons.waltable.layer.event.IVisualChangeEvent;
import org.eclipse.statet.ecommons.waltable.painter.IOverlayPainter;
import org.eclipse.statet.ecommons.waltable.painter.cell.GraphicsUtils;
import org.eclipse.statet.ecommons.waltable.painter.layer.ILayerPainter;
import org.eclipse.statet.ecommons.waltable.painter.layer.NatLayerPainter;
import org.eclipse.statet.ecommons.waltable.persistence.IPersistable;
import org.eclipse.statet.ecommons.waltable.selection.CellSelectionEvent;
import org.eclipse.statet.ecommons.waltable.swt.SWTUtil;
import org.eclipse.statet.ecommons.waltable.ui.IClientAreaProvider;
import org.eclipse.statet.ecommons.waltable.ui.binding.UiBindingRegistry;
import org.eclipse.statet.ecommons.waltable.ui.mode.ConfigurableModeEventHandler;
import org.eclipse.statet.ecommons.waltable.ui.mode.ModeSupport;
import org.eclipse.statet.ecommons.waltable.util.GUIHelper;
import org.eclipse.statet.ecommons.waltable.viewport.RecalculateScrollBarsCommand;
import org.eclipse.statet.internal.ecommons.waltable.LayerListenerList;
import org.eclipse.statet.internal.ecommons.waltable.WaLTablePlugin;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Scrollable;

public class NatTable
extends Canvas
implements ILayer,
PaintListener,
ILayerListener,
IPersistable {
    public static final int DEFAULT_STYLE_OPTIONS = 538182400;
    private final NatTableDim hDim;
    private final NatTableDim vDim;
    private IClientAreaProvider clientAreaProvider = new IClientAreaProvider(){

        @Override
        public LRectangle getClientArea() {
            if (!NatTable.this.isDisposed()) {
                return SWTUtil.toNatTable(NatTable.this.getClientArea());
            }
            return new LRectangle(0L, 0L, 0L, 0L);
        }
    };
    private UiBindingRegistry uiBindingRegistry;
    private ModeSupport modeSupport;
    private final EventConflaterChain conflaterChain = new EventConflaterChain();
    private final List<IOverlayPainter> overlayPainters = new ArrayList<IOverlayPainter>();
    private final List<IPersistable> persistables = new LinkedList<IPersistable>();
    private ILayer underlyingLayer;
    private IConfigRegistry configRegistry;
    protected final Collection<IConfiguration> configurations = new LinkedList<IConfiguration>();
    protected String id = GUIHelper.getSequenceNumber();
    private ILayerPainter layerPainter = new NatLayerPainter(this);
    private final boolean autoconfigure;
    private final LayerListenerList listeners = new LayerListenerList();

    public NatTable(Composite parent, ILayer layer) {
        this(parent, 538182400, layer);
    }

    public NatTable(Composite parent, ILayer layer, boolean autoconfigure) {
        this(parent, 538182400, layer, autoconfigure);
    }

    public NatTable(Composite parent, int style, ILayer layer) {
        this(parent, style, layer, true);
    }

    public NatTable(Composite parent, int style, final ILayer layer, boolean autoconfigure) {
        super(parent, style);
        this.hDim = new NatTableDim(this, layer.getDim(Orientation.HORIZONTAL));
        this.vDim = new NatTableDim(this, layer.getDim(Orientation.VERTICAL));
        this.disableScrollBar(this.getHorizontalBar());
        this.disableScrollBar(this.getVerticalBar());
        this.initInternalListener();
        this.internalSetLayer(layer);
        this.autoconfigure = autoconfigure;
        if (autoconfigure) {
            this.configurations.add(new DefaultNatTableStyleConfiguration());
            this.configure();
        }
        this.conflaterChain.add(this.getVisualChangeEventConflater());
        this.conflaterChain.start();
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                NatTable.this.doCommand(new DisposeResourcesCommand());
                NatTable.this.conflaterChain.stop();
                ActiveCellEditorRegistry.unregisterActiveCellEditor();
                layer.dispose();
            }
        });
    }

    @Override
    public NatTableDim getDim(Orientation orientation) {
        if (orientation == null) {
            throw new NullPointerException("orientation");
        }
        return orientation == Orientation.HORIZONTAL ? this.hDim : this.vDim;
    }

    protected IEventConflater getVisualChangeEventConflater() {
        return new VisualChangeEventConflater(this);
    }

    private void disableScrollBar(ScrollBar scrollBar) {
        if (scrollBar != null) {
            scrollBar.setMinimum(0);
            scrollBar.setMaximum(1);
            scrollBar.setThumb(1);
            scrollBar.setEnabled(false);
        }
    }

    public ILayer getLayer() {
        return this.underlyingLayer;
    }

    private void internalSetLayer(ILayer layer) {
        if (layer != null) {
            this.underlyingLayer = layer;
            this.underlyingLayer.setClientAreaProvider(this.getClientAreaProvider());
            this.underlyingLayer.addLayerListener(this);
        }
    }

    public void addConfiguration(IConfiguration configuration) {
        if (this.autoconfigure) {
            throw new IllegalStateException("May only add configurations post construction if autoconfigure is turned off");
        }
        this.configurations.add(configuration);
    }

    public IConfigRegistry getConfigRegistry() {
        if (this.configRegistry == null) {
            this.configRegistry = new ConfigRegistry();
        }
        return this.configRegistry;
    }

    public void setConfigRegistry(IConfigRegistry configRegistry) {
        if (this.autoconfigure) {
            throw new IllegalStateException("May only set config registry post construction if autoconfigure is turned off");
        }
        this.configRegistry = configRegistry;
    }

    public UiBindingRegistry getUiBindingRegistry() {
        if (this.uiBindingRegistry == null) {
            this.uiBindingRegistry = new UiBindingRegistry(this);
        }
        return this.uiBindingRegistry;
    }

    public void setUiBindingRegistry(UiBindingRegistry uiBindingRegistry) {
        if (this.autoconfigure) {
            throw new IllegalStateException("May only set UI binding registry post construction if autoconfigure is turned off");
        }
        this.uiBindingRegistry = uiBindingRegistry;
    }

    public String getID() {
        return this.id;
    }

    protected void checkSubclass() {
    }

    protected void initInternalListener() {
        this.modeSupport = new ModeSupport(this);
        this.modeSupport.registerModeEventHandler("NORMAL_MODE", new ConfigurableModeEventHandler(this.modeSupport, this));
        this.modeSupport.switchMode("NORMAL_MODE");
        this.addPaintListener(this);
        this.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent arg0) {
                NatTable.this.redraw();
            }

            public void focusGained(FocusEvent arg0) {
                NatTable.this.redraw();
            }
        });
        this.addListener(11, new Listener(){

            public void handleEvent(Event e) {
                NatTable.this.doCommand(new ClientAreaResizeCommand((Scrollable)NatTable.this));
            }
        });
    }

    public boolean forceFocus() {
        return super.forceFocus();
    }

    public List<IOverlayPainter> getOverlayPainters() {
        return this.overlayPainters;
    }

    public void addOverlayPainter(IOverlayPainter overlayPainter) {
        this.overlayPainters.add(overlayPainter);
    }

    public void removeOverlayPainter(IOverlayPainter overlayPainter) {
        this.overlayPainters.remove(overlayPainter);
    }

    public void paintControl(PaintEvent event) {
        this.paintNatTable(event);
    }

    private void paintNatTable(PaintEvent event) {
        Rectangle eventRectangle = new Rectangle(event.x, event.y, event.width, event.height);
        if (!eventRectangle.isEmpty()) {
            this.getLayerPainter().paintLayer(this, event.gc, 0, 0, eventRectangle, this.getConfigRegistry());
        }
    }

    @Override
    public ILayerPainter getLayerPainter() {
        return this.layerPainter;
    }

    public void setLayerPainter(ILayerPainter layerPainter) {
        this.layerPainter = layerPainter;
    }

    public void repaintColumn(long columnPosition) {
        this.hDim.repaintPosition(columnPosition);
    }

    public void repaintRow(long rowPosition) {
        this.vDim.repaintPosition(rowPosition);
    }

    protected void repaint(Orientation orientation, int start, int size) {
        if (orientation == Orientation.HORIZONTAL) {
            this.redraw(start, 0, size, GraphicsUtils.safe(this.getHeight()), true);
        } else {
            this.redraw(0, start, GraphicsUtils.safe(this.getWidth()), size, true);
        }
    }

    public void updateResize() {
        this.updateResize(true);
    }

    private void updateResize(boolean redraw) {
        if (this.isDisposed()) {
            return;
        }
        this.doCommand(new RecalculateScrollBarsCommand());
        if (redraw) {
            this.redraw();
        }
    }

    public void refresh() {
        this.doCommand(new StructuralRefreshCommand());
    }

    @Override
    public void configure(ConfigRegistry configRegistry, UiBindingRegistry uiBindingRegistry) {
        throw new UnsupportedOperationException("Cannot use this method to configure NatTable. Use no-argument configure() instead.");
    }

    public void configure() {
        if (this.underlyingLayer == null) {
            throw new IllegalStateException("Layer must be set before configure is called");
        }
        if (this.underlyingLayer != null) {
            this.underlyingLayer.configure((ConfigRegistry)this.getConfigRegistry(), this.getUiBindingRegistry());
        }
        for (IConfiguration configuration : this.configurations) {
            configuration.configureLayer(this);
            configuration.configureRegistry(this.getConfigRegistry());
            configuration.configureUiBindings(this.getUiBindingRegistry());
        }
        this.doCommand(new InitializeGridCommand((Composite)this));
    }

    @Override
    public void handleLayerEvent(ILayerEvent event) {
        ILayerListener[] iLayerListenerArray = this.listeners.getListeners();
        int n = iLayerListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            ILayerListener layerListener = iLayerListenerArray[n2];
            layerListener.handleLayerEvent(event);
            ++n2;
        }
        if (event instanceof IVisualChangeEvent) {
            this.conflaterChain.addEvent(event);
        }
        if (event instanceof CellSelectionEvent) {
            Event e = new Event();
            e.widget = this;
            try {
                this.notifyListeners(13, e);
            }
            catch (RuntimeException re) {
                WaLTablePlugin.log((IStatus)new Status(4, "org.eclipse.statet.ecommons.waltable.core", "An error occurred when fireing SWT selection event.", (Throwable)re));
            }
        }
    }

    @Override
    public void saveState(final String prefix, final Properties properties) {
        BusyIndicator.showWhile(null, (Runnable)new Runnable(){

            @Override
            public void run() {
                NatTable.this.underlyingLayer.saveState(prefix, properties);
            }
        });
    }

    @Override
    public void loadState(final String prefix, final Properties properties) {
        BusyIndicator.showWhile(null, (Runnable)new Runnable(){

            @Override
            public void run() {
                NatTable.this.underlyingLayer.loadState(prefix, properties);
            }
        });
    }

    @Override
    public void registerPersistable(IPersistable persistable) {
        this.persistables.add(persistable);
    }

    @Override
    public void unregisterPersistable(IPersistable persistable) {
        this.persistables.remove(persistable);
    }

    @Override
    public boolean doCommand(ILayerCommand command) {
        return this.underlyingLayer.doCommand(command);
    }

    @Override
    public void registerCommandHandler(ILayerCommandHandler<?> commandHandler) {
        this.underlyingLayer.registerCommandHandler(commandHandler);
    }

    @Override
    public void unregisterCommandHandler(Class<? extends ILayerCommand> commandClass) {
        this.underlyingLayer.unregisterCommandHandler(commandClass);
    }

    @Override
    public void fireLayerEvent(ILayerEvent event) {
        this.underlyingLayer.fireLayerEvent(event);
    }

    @Override
    public void addLayerListener(ILayerListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeLayerListener(ILayerListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public long getColumnCount() {
        return this.hDim.getPositionCount();
    }

    @Override
    public long getWidth() {
        return this.hDim.getSize();
    }

    @Override
    public long getColumnPositionByX(long x) {
        try {
            return this.hDim.getPositionByPixel(x);
        }
        catch (PixelOutOfBoundsException e) {
            return Long.MIN_VALUE;
        }
    }

    @Override
    public long getRowCount() {
        return this.vDim.getPositionCount();
    }

    @Override
    public long getHeight() {
        return this.vDim.getSize();
    }

    @Override
    public long getRowPositionByY(long y) {
        try {
            return this.vDim.getPositionByPixel(y);
        }
        catch (PixelOutOfBoundsException e) {
            return Long.MIN_VALUE;
        }
    }

    @Override
    public ILayerCell getCellByPosition(long columnPosition, long rowPosition) {
        return this.underlyingLayer.getCellByPosition(columnPosition, rowPosition);
    }

    @Override
    public LabelStack getRegionLabelsByXY(long x, long y) {
        return this.underlyingLayer.getRegionLabelsByXY(x, y);
    }

    @Override
    public ILayer getUnderlyingLayerByPosition(long columnPosition, long rowPosition) {
        return this.underlyingLayer;
    }

    @Override
    public IClientAreaProvider getClientAreaProvider() {
        return this.clientAreaProvider;
    }

    @Override
    public void setClientAreaProvider(IClientAreaProvider clientAreaProvider) {
        this.clientAreaProvider = clientAreaProvider;
        this.underlyingLayer.setClientAreaProvider(clientAreaProvider);
    }

    public void addDragSupport(int operations, Transfer[] transferTypes, DragSourceListener listener) {
        DragSource dragSource = new DragSource((Control)this, operations);
        dragSource.setTransfer(transferTypes);
        dragSource.addDragListener(listener);
    }

    public void addDropSupport(int operations, Transfer[] transferTypes, DropTargetListener listener) {
        DropTarget dropTarget = new DropTarget((Control)this, operations);
        dropTarget.setTransfer(transferTypes);
        dropTarget.addDropListener(listener);
    }
}

