/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.ui.viewers;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.layout.TreeColumnLayout;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.CellNavigationStrategy;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationEvent;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationStrategy;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.FocusCellHighlighter;
import org.eclipse.jface.viewers.FocusCellOwnerDrawHighlighter;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ICheckable;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SWTFocusCellManager;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TableViewerEditor;
import org.eclipse.jface.viewers.TableViewerFocusCellManager;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.TreeViewerEditor;
import org.eclipse.jface.viewers.TreeViewerFocusCellManager;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerColumn;
import org.eclipse.statet.ecommons.ui.components.SearchText;
import org.eclipse.statet.ecommons.ui.util.PixelConverter;
import org.eclipse.statet.ecommons.ui.util.UIAccess;
import org.eclipse.statet.jcommons.collections.CopyOnWriteIdentityListSet;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

@NonNullByDefault
public class ViewerUtils {
    public static Point calculateTreeSizeHint(Control treeControl, Node[] rootNodes, int rows) {
        Point pixels = new Point(0, 0);
        PixelConverter tool = new PixelConverter(treeControl);
        float factor = tool.convertWidthInCharsToPixels(2);
        ScrollBar vBar = ((Scrollable)treeControl).getVerticalBar();
        if (vBar != null) {
            factor = (float)vBar.getSize().x * 1.1f;
        }
        pixels.x = ViewerUtils.measureNodes(tool, factor, rootNodes, 1) + (int)factor;
        pixels.y = tool.convertHeightInCharsToPixels(rows);
        return pixels;
    }

    private static int measureNodes(PixelConverter tool, float factor, Node[] nodes, int deepth) {
        int maxWidth = 0;
        Node[] nodeArray = nodes;
        int n = nodes.length;
        int n2 = 0;
        while (n2 < n) {
            Node node = nodeArray[n2];
            maxWidth = Math.max(maxWidth, tool.convertWidthInCharsToPixels(node.name.length()) + (int)((float)deepth * factor));
            Node[] children = node.getChildren();
            if (children != null) {
                maxWidth = Math.max(maxWidth, ViewerUtils.measureNodes(tool, factor * 0.95f, children, deepth + 1));
            }
            ++n2;
        }
        return maxWidth;
    }

    public static void addDoubleClickExpansion(final TreeViewer viewer) {
        viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                if (selection != null && selection.size() == 1) {
                    Object item = selection.getFirstElement();
                    if (viewer.getExpandedState(item)) {
                        viewer.collapseToLevel(item, 1);
                    } else {
                        viewer.expandToLevel(item, 1);
                    }
                }
            }
        });
    }

    public static void setDefaultVisibleItemCount(ComboViewer viewer) {
        Control control = viewer.getControl();
        if (control instanceof Combo) {
            ((Combo)control).setVisibleItemCount(25);
        } else if (control instanceof CCombo) {
            ((CCombo)control).setVisibleItemCount(25);
        }
    }

    public static void installDefaultEditBehaviour(final TableViewer tableViewer) {
        CellNavigationStrategy naviStrat = new CellNavigationStrategy(){

            public @Nullable ViewerCell findSelectedCell(ColumnViewer viewer, @Nullable ViewerCell currentSelectedCell, Event event) {
                ViewerCell cell = super.findSelectedCell(viewer, currentSelectedCell, event);
                if (cell != null) {
                    tableViewer.getTable().showColumn(tableViewer.getTable().getColumn(cell.getColumnIndex()));
                }
                return cell;
            }
        };
        TableViewerFocusCellManager focusCellManager = new TableViewerFocusCellManager(tableViewer, (FocusCellHighlighter)new FocusCellOwnerDrawHighlighter((ColumnViewer)tableViewer), naviStrat);
        TableViewerEditor.create((TableViewer)tableViewer, (SWTFocusCellManager)focusCellManager, (ColumnViewerEditorActivationStrategy)ViewerUtils.createActivationStrategy((ColumnViewer)tableViewer), (int)58);
    }

    public static void installDefaultEditBehaviour2(final TableViewer tableViewer) {
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 1: {
                        IStructuredSelection selection;
                        if (event.keyCode != 13 && event.keyCode != 0x1000050 && event.keyCode != 0x100000B || (selection = (IStructuredSelection)tableViewer.getSelection()).size() < 1) break;
                        tableViewer.editElement(selection.getFirstElement(), 0);
                    }
                }
            }
        };
        tableViewer.getControl().addListener(1, listener);
    }

    public static void installDefaultEditBehaviour(final TreeViewer treeViewer) {
        CellNavigationStrategy naviStrat = new CellNavigationStrategy(){

            public @Nullable ViewerCell findSelectedCell(ColumnViewer viewer, @Nullable ViewerCell currentSelectedCell, Event event) {
                ViewerCell cell = super.findSelectedCell(viewer, currentSelectedCell, event);
                if (cell != null) {
                    treeViewer.getTree().showColumn(treeViewer.getTree().getColumn(cell.getColumnIndex()));
                }
                return cell;
            }
        };
        TreeViewerFocusCellManager focusCellManager = new TreeViewerFocusCellManager(treeViewer, (FocusCellHighlighter)new FocusCellOwnerDrawHighlighter((ColumnViewer)treeViewer), naviStrat);
        TreeViewerEditor.create((TreeViewer)treeViewer, (SWTFocusCellManager)focusCellManager, (ColumnViewerEditorActivationStrategy)ViewerUtils.createActivationStrategy((ColumnViewer)treeViewer), (int)58);
    }

    private static ColumnViewerEditorActivationStrategy createActivationStrategy(ColumnViewer viewer) {
        viewer.getControl().addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 4 && e.stateMask == 0) {
                    e.doit = false;
                }
            }
        });
        return new ColumnViewerEditorActivationStrategy(viewer){

            protected boolean isEditorActivationEvent(ColumnViewerEditorActivationEvent event) {
                return event.eventType == 5 || event.eventType == 2 || event.eventType == 3 || event.eventType == 1 && (event.keyCode == 13 || event.keyCode == 0x1000050 || event.keyCode == 0x100000B) || event.eventType == 4;
            }
        };
    }

    public static void installSearchTextNavigation(TableViewer viewer, final SearchText searchText, boolean back) {
        final Table table = viewer.getTable();
        searchText.addListener(new SearchText.Listener(){

            @Override
            public void textChanged(boolean user) {
            }

            @Override
            public void okPressed() {
            }

            @Override
            public void downPressed() {
                table.setFocus();
                if (table.getItemCount() > 0) {
                    if (table.getSelectionIndex() < 0) {
                        table.select(0);
                    } else {
                        table.showSelection();
                    }
                }
            }
        });
        if (back) {
            table.addKeyListener((KeyListener)new KeyAdapter(){

                public void keyPressed(KeyEvent e) {
                    if (e.stateMask == 0 && e.keyCode == 0x1000001 && table.getSelectionCount() == 1 && table.getSelectionIndex() == 0) {
                        table.deselectAll();
                        searchText.setFocus();
                    }
                }
            });
        }
    }

    public static void setSelectionProvider(Control control, ISelectionProvider selectionProvider) {
        control.setData("org.eclipse.jface.selectionProvider", (Object)selectionProvider);
    }

    public static @Nullable ISelectionProvider getSelectionProvider(Control control) {
        Object data;
        if (control != null && (data = control.getData("org.eclipse.jface.selectionProvider")) instanceof ISelectionProvider) {
            return (ISelectionProvider)data;
        }
        return null;
    }

    public static void scheduleStandardSelection(final TableViewer viewer) {
        viewer.getControl().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (!UIAccess.isOkToUse((Viewer)viewer)) {
                    return;
                }
                ISelection selection = viewer.getSelection();
                if (selection.isEmpty()) {
                    if (viewer.getTable().getItemCount() > 0) {
                        TableItem item = viewer.getTable().getItem(0);
                        viewer.setSelection((ISelection)new StructuredSelection(item.getData()));
                    } else {
                        viewer.setSelection((ISelection)new StructuredSelection());
                    }
                }
            }
        });
    }

    public static void scheduleStandardSelection(final TreeViewer viewer) {
        viewer.getControl().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (!UIAccess.isOkToUse((Viewer)viewer)) {
                    return;
                }
                ISelection selection = viewer.getSelection();
                if (selection.isEmpty()) {
                    if (viewer.getTree().getItemCount() > 0) {
                        TreeItem item = viewer.getTree().getItem(0);
                        viewer.setSelection((ISelection)new TreeSelection(new TreePath(new Object[]{item.getData()})));
                        viewer.setExpandedState(item.getData(), true);
                    } else {
                        viewer.setSelection((ISelection)new StructuredSelection());
                    }
                }
            }
        });
    }

    public static ImList<Object> toList(TreePath path) {
        int n = path.getSegmentCount();
        switch (n) {
            case 0: {
                return ImCollections.emptyList();
            }
            case 1: {
                return ImCollections.newList((Object)path.getSegment(0));
            }
        }
        Object[] array = new Object[n];
        int i = 0;
        while (i < n) {
            array[i] = path.getSegment(i);
            ++i;
        }
        return ImCollections.newList((Object[])array);
    }

    public static void expandToLevel(AbstractTreeViewer viewer, Object element, int level) {
        viewer.expandToLevel(element, level);
        TreeItem item = (TreeItem)viewer.testFindItem(element);
        while (item != null) {
            item.setExpanded(true);
            item = item.getParentItem();
        }
    }

    private ViewerUtils() {
    }

    public static class CheckboxColumnControl<TElement>
    extends ColumnLabelProvider
    implements Listener,
    ICheckable {
        private final TableViewer viewer;
        private final Collection<TElement> checkedElements;
        private final Collection<TElement> editableElements;
        private final CopyOnWriteIdentityListSet<ICheckStateListener> listeners = new CopyOnWriteIdentityListSet();

        public CheckboxColumnControl(TableViewer viewer, Set<TElement> checkedElements, Collection<TElement> editableElements) {
            this.viewer = viewer;
            this.checkedElements = checkedElements;
            this.editableElements = editableElements;
        }

        private int indexOf(TElement element) {
            Object input = this.viewer.getInput();
            if (input instanceof List) {
                return ((List)input).indexOf(element);
            }
            Object[] array = (Object[])input;
            int i = 0;
            while (i < array.length) {
                if (array[i] == element) {
                    return i;
                }
                ++i;
            }
            return -1;
        }

        protected Collection<TElement> getCheckedElements() {
            return this.checkedElements;
        }

        public boolean getChecked(Object element) {
            return this.getCheckedElements().contains(element);
        }

        public boolean setChecked(Object element, boolean state) {
            if (state) {
                this.getCheckedElements().add(element);
            } else {
                this.getCheckedElements().remove(element);
            }
            return true;
        }

        public void addCheckStateListener(ICheckStateListener listener) {
            this.listeners.add((Object)listener);
        }

        public void removeCheckStateListener(ICheckStateListener listener) {
            this.listeners.remove((Object)listener);
        }

        public void update(ViewerCell cell) {
            Button button;
            Object element = cell.getElement();
            TableItem item = (TableItem)cell.getItem();
            TableEditor editor = (TableEditor)item.getData("editor");
            if (editor == null || editor.getEditor() == null || editor.getEditor().isDisposed()) {
                button = new Button((Composite)this.viewer.getTable(), 524320);
                editor = new TableEditor(this.viewer.getTable());
                button.pack();
                Point buttonSize = button.getSize();
                editor.horizontalAlignment = 0x1000000;
                editor.minimumWidth = buttonSize.x;
                editor.minimumHeight = buttonSize.y;
                editor.setEditor((Control)button, item, 0);
                item.setData("editor", (Object)editor);
                button.addListener(13, (Listener)this);
                button.addListener(3, (Listener)this);
                button.addListener(15, (Listener)this);
                button.addListener(26, (Listener)this);
            } else {
                button = (Button)editor.getEditor();
            }
            button.setData(element);
            button.setEnabled(this.editableElements.contains(element));
            button.setSelection(this.getChecked(element));
            editor.setEditor((Control)button, item, cell.getColumnIndex());
        }

        public int hintColumnWidth() {
            Button button = new Button((Composite)this.viewer.getTable(), 32);
            try {
                int n = button.computeSize((int)-1, (int)-1).x;
                return n;
            }
            finally {
                button.dispose();
            }
        }

        public void handleEvent(Event event) {
            Button button = (Button)event.widget;
            Object element = button.getData();
            switch (event.type) {
                case 13: {
                    if (!this.editableElements.contains(element)) {
                        event.doit = false;
                        return;
                    }
                    this.doCheck(element, button.getSelection());
                    return;
                }
                case 3: {
                    event.doit = false;
                    if (!this.editableElements.contains(element)) {
                        return;
                    }
                    this.viewer.setSelection((ISelection)new StructuredSelection(element));
                    button.setSelection(!button.getSelection());
                    this.doCheck(element, button.getSelection());
                    this.recheckSelection();
                    return;
                }
                case 15: {
                    event.doit = false;
                    this.viewer.getTable().forceFocus();
                    return;
                }
            }
        }

        protected void toggle(TElement element) {
            TableItem item = this.getItem(element);
            if (item != null) {
                Button button;
                TableEditor editor = (TableEditor)item.getData("editor");
                button.setSelection(!(button = (Button)editor.getEditor()).getSelection());
                this.doCheck(element, button.getSelection());
            } else {
                this.doCheck(element, !this.checkedElements.contains(element));
            }
        }

        protected TElement getSelectedElement() {
            return (TElement)((StructuredSelection)this.viewer.getSelection()).getFirstElement();
        }

        private void doCheck(Object element, boolean state) {
            this.setChecked(element, state);
            CheckStateChangedEvent event = new CheckStateChangedEvent((ICheckable)this, element, state);
            for (ICheckStateListener listener : this.listeners) {
                listener.checkStateChanged(event);
            }
        }

        private @Nullable TableItem getItem(TElement element) {
            Table table = this.viewer.getTable();
            int idx = this.indexOf(element);
            if (idx >= 0 && idx < table.getItemCount()) {
                return table.getItem(idx);
            }
            return null;
        }

        private void recheckSelection() {
            this.viewer.getTable().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    Object element;
                    int idx;
                    if (UIAccess.isOkToUse((Viewer)viewer) && (idx = this.indexOf(element = this.getSelectedElement())) >= 0) {
                        viewer.getTable().setSelection(idx);
                    }
                }
            });
        }

        public void configureAsMainColumn() {
            this.viewer.getTable().setTabList(new Control[0]);
            Listener tableListener = new Listener(){

                public void handleEvent(Event event) {
                    switch (event.type) {
                        case 1: {
                            if (event.keyCode == 32) {
                                Object element = this.getSelectedElement();
                                if (element == null || !editableElements.contains(element)) {
                                    return;
                                }
                                this.toggle(element);
                            }
                            return;
                        }
                        case 3: {
                            TableItem item = viewer.getTable().getItem(new Point(event.x, event.y));
                            if (item != null) {
                                Button button;
                                Object element = item.getData();
                                if (element == null || !editableElements.contains(element)) {
                                    return;
                                }
                                TableEditor editor = (TableEditor)item.getData("editor");
                                button.setSelection(!(button = (Button)editor.getEditor()).getSelection());
                                this.doCheck(element, button.getSelection());
                            }
                            return;
                        }
                    }
                }
            };
            this.viewer.getTable().addListener(1, tableListener);
            this.viewer.getTable().addListener(3, tableListener);
        }
    }

    public static class CheckboxTableComposite
    extends Composite {
        public CheckboxTableViewer viewer;
        public Table table;
        public TableColumnLayout layout = new TableColumnLayout();

        public CheckboxTableComposite(Composite parent, int tableStyle) {
            super(parent, 0);
            this.setLayout((Layout)this.layout);
            this.viewer = CheckboxTableViewer.newCheckList((Composite)this, (int)tableStyle);
            this.table = this.viewer.getTable();
        }

        public TableViewerColumn addColumn(String title, int style, ColumnLayoutData layoutData) {
            TableViewerColumn column = new TableViewerColumn((TableViewer)this.viewer, style);
            column.getColumn().setText(title);
            this.layout.setColumnData((Widget)column.getColumn(), layoutData);
            return column;
        }

        public @Nullable ViewerColumn getViewerColumn(int index) {
            TableColumn column = this.table.getColumn(index);
            if (column == null) {
                return null;
            }
            return (TableViewerColumn)column.getData("org.eclipse.jface.columnViewer");
        }
    }

    public static class Node {
        private static final Node[] NO_CHILDREN = new Node[0];
        private final String name;
        private @Nullable Node parent;
        private final Node[] children;

        public Node(String name, Node @Nullable [] children) {
            this.name = name;
            if (children != null) {
                Node[] nodeArray = children;
                int n = children.length;
                int n2 = 0;
                while (n2 < n) {
                    Node node = nodeArray[n2];
                    node.parent = this;
                    ++n2;
                }
                this.children = children;
            } else {
                this.children = NO_CHILDREN;
            }
        }

        public String getName() {
            return this.name;
        }

        public Node[] getChildren() {
            return this.children;
        }
    }

    public static class NodeContentProvider
    implements ITreeContentProvider {
        public Object[] getElements(Object inputElement) {
            return (Node[])inputElement;
        }

        public @Nullable Object getParent(Object element) {
            return ((Node)element).parent;
        }

        public boolean hasChildren(Object element) {
            return ((Node)element).children.length != 0;
        }

        public Object[] getChildren(Object parentElement) {
            return ((Node)parentElement).children;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }
    }

    public static class TableComposite
    extends Composite {
        public TableViewer viewer;
        public Table table;
        public TableColumnLayout layout = new TableColumnLayout();

        public TableComposite(Composite parent, int tableStyle) {
            super(parent, 0);
            this.setLayout((Layout)this.layout);
            this.table = new Table((Composite)this, tableStyle);
            this.viewer = new TableViewer(this.table);
        }

        public TableViewerColumn addColumn(String title, int style, ColumnLayoutData layoutData) {
            TableViewerColumn column = new TableViewerColumn(this.viewer, style);
            if (title != null) {
                column.getColumn().setText(title);
            }
            this.layout.setColumnData((Widget)column.getColumn(), layoutData);
            return column;
        }

        public @Nullable ViewerColumn getViewerColumn(int index) {
            TableColumn column = this.table.getColumn(index);
            if (column == null) {
                return null;
            }
            return (TableViewerColumn)column.getData("org.eclipse.jface.columnViewer");
        }
    }

    public static class TreeComposite
    extends Composite {
        public TreeViewer viewer;
        public Tree tree;
        public TreeColumnLayout layout = new TreeColumnLayout();

        public TreeComposite(Composite parent, int treeStyle) {
            super(parent, 0);
            this.setLayout((Layout)this.layout);
            this.tree = new Tree((Composite)this, treeStyle);
            this.viewer = new TreeViewer(this.tree);
        }

        public TreeViewerColumn addColumn(String title, int style, ColumnLayoutData layoutData) {
            TreeViewerColumn column = new TreeViewerColumn(this.viewer, style);
            column.getColumn().setText(title);
            this.layout.setColumnData((Widget)column.getColumn(), layoutData);
            return column;
        }

        public TreeViewerColumn addColumn(int style, ColumnLayoutData layoutData) {
            TreeViewerColumn column = new TreeViewerColumn(this.viewer, style);
            this.layout.setColumnData((Widget)column.getColumn(), layoutData);
            return column;
        }

        public @Nullable TreeViewerColumn getViewerColumn(int index) {
            TreeColumn column = this.tree.getColumn(index);
            if (column == null) {
                return null;
            }
            return (TreeViewerColumn)column.getData("org.eclipse.jface.columnViewer");
        }
    }
}

