/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.ui.util;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class ImageRegistryUtil {
    public static final String T_VIEW = "view_16";
    public static final String T_TOOL = "tool_16";
    public static final String T_TOOLD = "tool_16_d";
    public static final String T_OBJ = "obj_16";
    public static final String T_OVR = "ovr_16";
    public static final String T_WIZBAN = "wizban";
    public static final String T_LOCTOOL = "loctool_16";
    public static final String T_LOCTOOL_D = "loctool_16_d";
    private final AbstractUIPlugin fPlugin;
    private final URL fIconBaseURL;

    public ImageRegistryUtil(AbstractUIPlugin plugin) {
        this.fIconBaseURL = plugin.getBundle().getEntry("/icons/");
        this.fPlugin = plugin;
    }

    public void register(String key, String prefix, String name) {
        ImageDescriptor descriptor = this.createDescriptor(prefix, name);
        this.fPlugin.getImageRegistry().put(key, descriptor);
    }

    protected ImageDescriptor createDescriptor(String prefix, String name) {
        try {
            return ImageDescriptor.createFromURL((URL)this.makeIconFileURL(prefix, name));
        }
        catch (MalformedURLException e) {
            this.fPlugin.getLog().log((IStatus)new Status(4, this.fPlugin.getBundle().getSymbolicName(), 0, "Error occured while loading an image descriptor. (internal, unexpected)", (Throwable)e));
            return ImageDescriptor.getMissingImageDescriptor();
        }
    }

    protected URL makeIconFileURL(String prefix, String name) throws MalformedURLException {
        if (this.fIconBaseURL == null) {
            throw new MalformedURLException();
        }
        return new URL(this.fIconBaseURL, String.valueOf(prefix) + '/' + name);
    }
}

