/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.docmlet.tex.core.commands;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.statet.docmlet.tex.core.commands.TexCommand;
import org.eclipse.statet.internal.docmlet.tex.core.Messages;
import org.eclipse.statet.jcommons.collections.ImCollections;

public class LtxCommandCategories {
    private final List<Category> categories;

    public LtxCommandCategories(List<TexCommand> list) {
        Cat[] cats = Cat.values();
        List[] lists = new List[cats.length];
        for (TexCommand command : list) {
            Cat cat;
            if (!this.include(command) || (cat = this.getCat(command)) == null) continue;
            if (lists[cat.ordinal()] == null) {
                lists[cat.ordinal()] = new ArrayList();
            }
            lists[cat.ordinal()].add(command);
        }
        ArrayList<Category> categories = new ArrayList<Category>(lists.length);
        int i = 0;
        while (i < lists.length) {
            if (lists[i] != null) {
                categories.add(new Category(cats[i], (List)ImCollections.toList((Collection)lists[i])));
            }
            ++i;
        }
        this.categories = ImCollections.toList(categories);
    }

    private Cat getCat(TexCommand command) {
        switch (command.getType() & 0xF) {
            case 6: {
                return Cat.SECTIONING;
            }
            case 7: {
                return Cat.LABEL;
            }
            case 8: {
                switch (command.getType() & 0xFF) {
                    case 56: {
                        return Cat.TEXT_STYLING;
                    }
                    case 88: {
                        return Cat.MATH_STYLING;
                    }
                }
                return null;
            }
            case 10: {
                switch (command.getType() & 0xFF) {
                    case 26: {
                        return Cat.COMMON_SYMBOLS;
                    }
                    case 58: {
                        return Cat.TEXT_SYMBOLS;
                    }
                }
                return null;
            }
            case 11: {
                switch (command.getType() & 0xFFF) {
                    case 283: {
                        return Cat.MATHSYMBOLS_GREEK_UPPER;
                    }
                    case 539: {
                        return Cat.MATHSYMBOLS_GREEK_LOWER;
                    }
                    case 347: {
                        return Cat.MATHSYMBOLS_BIN_OP;
                    }
                    case 603: {
                        return Cat.MATHSYMBOLS_ROOTFRAC_OP;
                    }
                    case 859: {
                        return Cat.MATHSYMBOLS_REL_STD;
                    }
                    case 1115: {
                        return Cat.MATHSYMBOLS_REL_ARROW;
                    }
                    case 1627: {
                        return Cat.MATHSYMBOLS_REL_MISC;
                    }
                    case 1883: {
                        return Cat.MATHSYMBOLS_LARGE_OP;
                    }
                    case 2907: {
                        return Cat.MATHSYMBOLS_NAMED_OP;
                    }
                    case 363: {
                        return Cat.MATHSYMBOLS_MISC_ALPHA;
                    }
                    case 619: {
                        return Cat.MATHSYMBOLS_MISC_ORD;
                    }
                    case 1643: {
                        return Cat.MATHSYMBOLS_DOTS;
                    }
                    case 1899: {
                        return Cat.MATHSYMBOLS_ACCENTS;
                    }
                    case 91: {
                        return Cat.MATHSYMBOLS_BRACKETS;
                    }
                }
                return null;
            }
        }
        return null;
    }

    protected boolean include(TexCommand command) {
        return true;
    }

    public List<Category> getCategories() {
        return this.categories;
    }

    public Category getCategory(TexCommand command) {
        Cat cat = this.getCat(command);
        if (cat != null) {
            for (Category category : this.categories) {
                if (category.cat != cat) continue;
                return category;
            }
        }
        return null;
    }

    private static enum Cat {
        SECTIONING(Messages.CommandCategory_Sectioning_label),
        LABEL(Messages.CommandCategory_Label_label),
        TEXT_STYLING(Messages.CommandCategory_TextStyling_label),
        MATH_STYLING(Messages.CommandCategory_MathStyling_label),
        COMMON_SYMBOLS(Messages.CommandCategory_CommonSymbols_label),
        TEXT_SYMBOLS(Messages.CommandCategory_TextSymbols_label),
        MATHSYMBOLS_GREEK_UPPER(Messages.CommandCategory_MathSymbols_GreekUpper_label),
        MATHSYMBOLS_GREEK_LOWER(Messages.CommandCategory_MathSymbols_GreekLower_label),
        MATHSYMBOLS_BIN_OP(Messages.CommandCategory_MathSymbols_BinOp_label),
        MATHSYMBOLS_ROOTFRAC_OP(Messages.CommandCategory_MathSymbols_RootFracOp_label),
        MATHSYMBOLS_REL_STD(Messages.CommandCategory_MathSymbols_RelStd_label),
        MATHSYMBOLS_REL_ARROW(Messages.CommandCategory_MathSymbols_RelArrow_label),
        MATHSYMBOLS_REL_MISC(Messages.CommandCategory_MathSymbols_RelMisc_label),
        MATHSYMBOLS_LARGE_OP(Messages.CommandCategory_MathSymbols_LargeOp_label),
        MATHSYMBOLS_NAMED_OP(Messages.CommandCategory_MathSymbols_NamedOp_label),
        MATHSYMBOLS_MISC_ALPHA(Messages.CommandCategory_MathSymbols_MiscAlpha_label),
        MATHSYMBOLS_MISC_ORD(Messages.CommandCategory_MathSymbols_MiscOrd_label),
        MATHSYMBOLS_DOTS(Messages.CommandCategory_MathSymbols_Dots_label),
        MATHSYMBOLS_ACCENTS(Messages.CommandCategory_MathSymbols_Accents_label),
        MATHSYMBOLS_BRACKETS(Messages.CommandCategory_MathSymbols_Brackets_label);

        private final String label;

        private Cat(String label) {
            this.label = label;
        }

        public String getLabel() {
            return this.label;
        }
    }

    public static class Category {
        private final Cat cat;
        private final List<TexCommand> commands;

        private Category(Cat cat, List<TexCommand> commands) {
            this.cat = cat;
            this.commands = commands;
        }

        public String getLabel() {
            return this.cat.label;
        }

        public List<TexCommand> getCommands() {
            return this.commands;
        }

        public String toString() {
            return String.valueOf(this.cat.label) + " [" + this.commands.size() + "]";
        }
    }
}

