/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.tools.planexporter;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.derby.iapi.tools.ToolUtils;
import org.apache.derby.impl.tools.planexporter.TreeNode;

public class AccessDatabase {
    private final Connection conn;
    private final String schema;
    private final String query;
    private final boolean schemaExists;
    private TreeNode[] data;
    private int depth = 0;
    private String xmlDetails = "";
    private static final int ID = 0;
    private static final int P_ID = 1;
    private static final int NODE_TYPE = 2;
    private static final int NO_OF_OPENS = 3;
    private static final int INPUT_ROWS = 4;
    private static final int RETURNED_ROWS = 5;
    private static final int VISITED_PAGES = 6;
    private static final int SCAN_QUALIFIERS = 7;
    private static final int NEXT_QUALIFIERS = 8;
    private static final int SCANNED_OBJECT = 9;
    private static final int SCAN_TYPE = 10;
    private static final int SORT_TYPE = 11;
    private static final int NO_OF_OUTPUT_ROWS_BY_SORTER = 12;

    public String getQuery() {
        return this.query;
    }

    public int getDepth() {
        return this.depth;
    }

    public AccessDatabase(String string, String string2, String string3) throws InstantiationException, IllegalAccessException, ClassNotFoundException, SQLException {
        this(AccessDatabase.createConnection(string), string2, string3);
    }

    public AccessDatabase(Connection connection, String string, String string2) throws SQLException {
        this.conn = connection;
        this.schema = string;
        this.query = string2;
        this.schemaExists = this.schemaExists();
        if (this.schemaExists) {
            this.setSchema();
        }
    }

    private static Connection createConnection(String string) throws InstantiationException, IllegalAccessException, ClassNotFoundException, SQLException {
        if (string.indexOf("://") != -1) {
            Class.forName("org.apache.derby.jdbc.ClientDriver").newInstance();
        } else {
            Class.forName("org.apache.derby.jdbc.EmbeddedDriver").newInstance();
        }
        return DriverManager.getConnection(string);
    }

    private void setSchema() throws SQLException {
        PreparedStatement preparedStatement = this.conn.prepareStatement("SET SCHEMA ?");
        preparedStatement.setString(1, this.schema);
        preparedStatement.execute();
        preparedStatement.close();
    }

    private boolean schemaExists() throws SQLException {
        ResultSet resultSet = this.conn.getMetaData().getSchemas();
        try {
            while (resultSet.next()) {
                if (!resultSet.getString(1).equals(this.schema)) continue;
                boolean bl = true;
                return bl;
            }
        }
        finally {
            resultSet.close();
        }
        return false;
    }

    public boolean verifySchemaExistance() {
        return this.schemaExists;
    }

    public void createXMLFragment() throws SQLException {
        this.createXMLData("select 'id=\"' ||RS_ID|| '\"' from SYSXPLAIN_RESULTSETS where STMT_ID = ?", 0);
        this.createXMLData("select PARENT_RS_ID from SYSXPLAIN_RESULTSETS where STMT_ID = ?", 1);
        this.createXMLData("select 'name=\"' ||OP_IDENTIFIER|| '\"' from SYSXPLAIN_RESULTSETS where STMT_ID = ?", 2);
        this.createXMLData("select 'no_opens=\"' || TRIM(CHAR(NO_OPENS))|| '\"' from SYSXPLAIN_RESULTSETS where STMT_ID = ?", 3);
        this.createXMLData("select 'input_rows=\"' || TRIM(CHAR(INPUT_ROWS))|| '\"' from SYSXPLAIN_RESULTSETS where STMT_ID = ?", 4);
        this.createXMLData("select 'returned_rows=\"' || TRIM(CHAR(RETURNED_ROWS))|| '\"' from SYSXPLAIN_RESULTSETS where STMT_ID = ?", 5);
        this.createXMLData("select 'visited_pages=\"'|| TRIM(CHAR(NO_VISITED_PAGES))|| '\"' from (SYSXPLAIN_SCAN_PROPS NATURAL RIGHT OUTER JOIN SYSXPLAIN_RESULTSETS) where STMT_ID = ?", 6);
        this.createXMLData("select 'scan_qualifiers=\"'||SCAN_QUALIFIERS|| '\"' from (SYSXPLAIN_SCAN_PROPS NATURAL RIGHT OUTER JOIN SYSXPLAIN_RESULTSETS) where STMT_ID = ?", 7);
        this.createXMLData("select 'next_qualifiers=\"'||NEXT_QUALIFIERS|| '\"' from (SYSXPLAIN_SCAN_PROPS NATURAL RIGHT OUTER JOIN SYSXPLAIN_RESULTSETS) where STMT_ID = ?", 8);
        this.createXMLData("select 'scanned_object=\"'||SCAN_OBJECT_NAME|| '\"' from (SYSXPLAIN_SCAN_PROPS NATURAL RIGHT OUTER JOIN SYSXPLAIN_RESULTSETS) where STMT_ID = ?", 9);
        this.createXMLData("select 'scan_type=\"'||TRIM(SCAN_TYPE)|| '\"' from (SYSXPLAIN_SCAN_PROPS NATURAL RIGHT OUTER JOIN SYSXPLAIN_RESULTSETS) where STMT_ID = ?", 10);
        this.createXMLData("select 'sort_type=\"'||TRIM(SORT_TYPE)|| '\"' from (SYSXPLAIN_SORT_PROPS NATURAL RIGHT OUTER JOIN SYSXPLAIN_RESULTSETS) where STMT_ID = ?", 11);
        this.createXMLData("select 'sorter_output=\"'||TRIM(CHAR(NO_OUTPUT_ROWS))|| '\"' from (SYSXPLAIN_SORT_PROPS NATURAL RIGHT OUTER JOIN SYSXPLAIN_RESULTSETS) where STMT_ID = ?", 12);
    }

    public String getXmlString() {
        for (int i = 0; i < this.data.length; ++i) {
            if (this.data[i].getDepth() != 0) continue;
            this.xmlDetails = this.xmlDetails + this.indent(1);
            this.xmlDetails = this.xmlDetails + this.data[i].toString();
            this.getChildren(1, this.data[i].getId());
            this.xmlDetails = this.xmlDetails + this.indent(1) + "</node>\n";
            break;
        }
        return this.xmlDetails;
    }

    private void getChildren(int n, String string) {
        if (n <= this.depth) {
            for (int i = 0; i < this.data.length; ++i) {
                if (this.data[i].getDepth() != n || string.indexOf(this.data[i].getParent()) == -1) continue;
                this.xmlDetails = this.xmlDetails + this.indent(n + 1);
                this.xmlDetails = this.xmlDetails + this.data[i].toString();
                this.getChildren(n + 1, this.data[i].getId());
                this.xmlDetails = this.xmlDetails + this.indent(n + 1) + "</node>\n";
            }
        }
    }

    public String indent(int n) {
        String string = "";
        for (int i = 0; i <= n + 1; ++i) {
            string = string + "    ";
        }
        return string;
    }

    public void markTheDepth() {
        int n = 0;
        while (this.data[n].getParent().indexOf("null") == -1) {
            ++n;
        }
        this.data[n].setDepth(this.depth);
        this.findChildren(n, this.depth);
    }

    private void findChildren(int n, int n2) {
        if (n2 > this.depth) {
            this.depth = n2;
        }
        for (int i = 0; i < this.data.length; ++i) {
            if (this.data[i].getParent().indexOf("null") != -1 || this.data[n].getId().indexOf(this.data[i].getParent()) == -1 || i == n) continue;
            this.data[i].setDepth(n2 + 1);
            this.findChildren(i, n2 + 1);
        }
    }

    public boolean initializeDataArray() throws SQLException {
        if (this.noOfNodes() == 0) {
            return false;
        }
        this.data = new TreeNode[this.noOfNodes()];
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i] = new TreeNode();
        }
        return true;
    }

    private void createXMLData(String string, int n) throws SQLException {
        PreparedStatement preparedStatement = this.conn.prepareStatement(string);
        preparedStatement.setString(1, this.getQuery());
        ResultSet resultSet = preparedStatement.executeQuery();
        int n2 = 0;
        while (resultSet.next()) {
            String string2 = resultSet.getString(1);
            if (string2 != null) {
                string2 = this.escapeInAttribute(string2);
                switch (n) {
                    case 0: {
                        this.data[n2].setId(string2 + " ");
                        break;
                    }
                    case 1: {
                        this.data[n2].setParent(string2);
                        break;
                    }
                    case 2: {
                        this.data[n2].setNodeType(string2 + " ");
                        break;
                    }
                    case 3: {
                        this.data[n2].setNoOfOpens(string2 + " ");
                        break;
                    }
                    case 4: {
                        this.data[n2].setInputRows(string2 + " ");
                        break;
                    }
                    case 5: {
                        this.data[n2].setReturnedRows(string2 + " ");
                        break;
                    }
                    case 6: {
                        this.data[n2].setVisitedPages(string2 + " ");
                        break;
                    }
                    case 7: {
                        this.data[n2].setScanQualifiers(string2 + " ");
                        break;
                    }
                    case 8: {
                        this.data[n2].setNextQualifiers(string2 + " ");
                        break;
                    }
                    case 9: {
                        this.data[n2].setScannedObject(string2 + " ");
                        break;
                    }
                    case 10: {
                        this.data[n2].setScanType(string2 + " ");
                        break;
                    }
                    case 11: {
                        this.data[n2].setSortType(string2 + " ");
                        break;
                    }
                    case 12: {
                        this.data[n2].setSorterOutput(string2 + " ");
                    }
                }
            } else {
                switch (n) {
                    case 1: {
                        this.data[n2].setParent(string2 + "");
                    }
                }
            }
            ++n2;
        }
        resultSet.close();
        preparedStatement.close();
    }

    private int noOfNodes() throws SQLException {
        PreparedStatement preparedStatement = this.conn.prepareStatement("select count(*) from SYSXPLAIN_RESULTSETS where STMT_ID = ?");
        preparedStatement.setString(1, this.getQuery());
        ResultSet resultSet = preparedStatement.executeQuery();
        resultSet.next();
        int n = resultSet.getInt(1);
        resultSet.close();
        preparedStatement.close();
        return n;
    }

    public String statement() throws SQLException {
        PreparedStatement preparedStatement = this.conn.prepareStatement("select STMT_TEXT from SYSXPLAIN_STATEMENTS where STMT_ID = ?");
        preparedStatement.setString(1, this.getQuery());
        ResultSet resultSet = preparedStatement.executeQuery();
        resultSet.next();
        String string = resultSet.getString(1);
        resultSet.close();
        preparedStatement.close();
        string = AccessDatabase.escapeForXML(string);
        return "<statement>" + string + "</statement>\n";
    }

    private static String escapeForXML(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        block7: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '&': {
                    stringBuffer.append("&amp;");
                    continue block7;
                }
                case '<': {
                    stringBuffer.append("&lt;");
                    continue block7;
                }
                case '>': {
                    stringBuffer.append("&gt;");
                    continue block7;
                }
                case '\'': {
                    stringBuffer.append("&apos;");
                    continue block7;
                }
                case '\"': {
                    stringBuffer.append("&quot;");
                    continue block7;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
        }
        return stringBuffer.toString();
    }

    private String escapeInAttribute(String string) {
        if (string.indexOf(34) == -1) {
            return string;
        }
        String string2 = AccessDatabase.escapeForXML(string.substring(string.indexOf(34) + 1, string.length() - 1));
        return string.substring(0, string.indexOf(34) + 1) + string2 + "\"";
    }

    public String time() throws SQLException {
        PreparedStatement preparedStatement = this.conn.prepareStatement("select '<time>'||TRIM(CHAR(XPLAIN_TIME))||'</time>' from SYSXPLAIN_STATEMENTS where STMT_ID = ?");
        preparedStatement.setString(1, this.getQuery());
        ResultSet resultSet = preparedStatement.executeQuery();
        resultSet.next();
        String string = resultSet.getString(1);
        resultSet.close();
        preparedStatement.close();
        return string + "\n";
    }

    public String stmtID() {
        return "<stmt_id>" + this.getQuery() + "</stmt_id>\n";
    }

    public void closeConnection() {
        try {
            if (this.conn != null) {
                this.conn.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public TreeNode[] getData() {
        return (TreeNode[])ToolUtils.copy(this.data);
    }
}

