/**
 * <copyright>
 * 
 * Copyright (c) 2015 itemis and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     itemis - Initial API and implementation
 * 
 * </copyright>
 */
package org.eclipse.sphinx.examples.views.documentation;

import java.util.Arrays;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.sphinx.platform.ui.views.documentation.AbstractDocumentationViewFormatter;
import org.eclipse.xtend2.lib.StringConcatenation;

@SuppressWarnings("all")
public class EObjectDocumentationViewFormatter extends AbstractDocumentationViewFormatter {
  @Override
  public String formatHeader(final Object object) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("Documentation");
    return _builder.toString();
  }
  
  @Override
  public String format(final Object object) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _formatSpecific = this.formatSpecific(object);
    _builder.append(_formatSpecific);
    _builder.newLineIfNotEmpty();
    return _builder.toString();
  }
  
  protected CharSequence _formatSpecific(final EObject eObject) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.newLine();
    _builder.append("<p>");
    _builder.newLine();
    _builder.append("  \t\t");
    String _documentation = EcoreUtil.getDocumentation(eObject.eClass());
    _builder.append(_documentation, "  \t\t");
    _builder.newLineIfNotEmpty();
    _builder.append("</p>");
    _builder.newLine();
    _builder.newLine();
    _builder.append("<table class=\"table\">");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("<tr>");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("<th>Feature</th>");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("<th>Documentation</th>");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("</tr>");
    _builder.newLine();
    {
      EList<EStructuralFeature> _eAllStructuralFeatures = eObject.eClass().getEAllStructuralFeatures();
      for(final EStructuralFeature eStructuralFeature : _eAllStructuralFeatures) {
        _builder.append("  \t");
        _builder.append("<tr>");
        _builder.newLine();
        _builder.append("  \t");
        _builder.append("\t");
        _builder.append("<td>");
        String _name = eStructuralFeature.getName();
        _builder.append(_name, "  \t\t");
        _builder.append("</td>");
        _builder.newLineIfNotEmpty();
        _builder.append("  \t");
        _builder.append("\t");
        _builder.append("<td>");
        String _documentation_1 = EcoreUtil.getDocumentation(eStructuralFeature);
        _builder.append(_documentation_1, "  \t\t");
        _builder.append("</td>");
        _builder.newLineIfNotEmpty();
        _builder.append("  \t");
        _builder.append("</tr>\t");
        _builder.newLine();
      }
    }
    _builder.append("</table>    \t");
    _builder.newLine();
    return _builder;
  }
  
  protected CharSequence _formatSpecific(final Object object) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append(object);
    return _builder;
  }
  
  public CharSequence formatSpecific(final Object eObject) {
    if (eObject instanceof EObject) {
      return _formatSpecific((EObject)eObject);
    } else if (eObject != null) {
      return _formatSpecific(eObject);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(eObject).toString());
    }
  }
}
