/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.workspace.loading.operations;

import java.util.Collection;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.sphinx.emf.metamodel.IMetaModelDescriptor;
import org.eclipse.sphinx.emf.util.EcorePlatformUtil;
import org.eclipse.sphinx.emf.workspace.internal.messages.Messages;
import org.eclipse.sphinx.emf.workspace.loading.SchedulingRuleFactory;
import org.eclipse.sphinx.emf.workspace.loading.operations.AbstractLoadOperation;
import org.eclipse.sphinx.emf.workspace.loading.operations.IModelUnloadOperation;
import org.eclipse.sphinx.platform.util.ExtendedPlatform;

public class DefaultModelUnloadOperation
extends AbstractLoadOperation
implements IModelUnloadOperation {
    private Map<TransactionalEditingDomain, Collection<Resource>> resourcesToUnload;
    private boolean memoryOptimized;

    public DefaultModelUnloadOperation(Map<TransactionalEditingDomain, Collection<Resource>> resourcesToUnload, boolean memoryOptimized) {
        super(Messages.job_unloadingModelResources, null);
        this.resourcesToUnload = resourcesToUnload;
        this.memoryOptimized = memoryOptimized;
    }

    public ISchedulingRule getRule() {
        return new SchedulingRuleFactory().createLoadSchedulingRule(this.getResourcesToUnload());
    }

    @Override
    public Map<TransactionalEditingDomain, Collection<Resource>> getResourcesToUnload() {
        return this.resourcesToUnload;
    }

    @Override
    public boolean isMemoryOptimized() {
        return this.memoryOptimized;
    }

    public void run(IProgressMonitor monitor) throws CoreException {
        this.runUnloadModelResources(this.resourcesToUnload, this.memoryOptimized, monitor);
    }

    protected void runUnloadModelResources(Map<TransactionalEditingDomain, Collection<Resource>> resourcesToUnload, boolean memoryOptimized, IProgressMonitor monitor) throws OperationCanceledException {
        Assert.isNotNull(resourcesToUnload);
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)this.getResourcesToUnloadCount(resourcesToUnload));
        if (progress.isCanceled()) {
            throw new OperationCanceledException();
        }
        for (TransactionalEditingDomain editingDomain : resourcesToUnload.keySet()) {
            Collection<Resource> resourcesToUnloadInEditingDomain = resourcesToUnload.get(editingDomain);
            EcorePlatformUtil.unloadResources((TransactionalEditingDomain)editingDomain, resourcesToUnloadInEditingDomain, (boolean)memoryOptimized, (IProgressMonitor)progress.newChild(resourcesToUnloadInEditingDomain.size()));
            if (!progress.isCanceled()) continue;
            throw new OperationCanceledException();
        }
        ExtendedPlatform.performGarbageCollection();
    }

    @Override
    public boolean covers(Collection<IProject> projects, boolean includeReferencedProjects, IMetaModelDescriptor mmDescriptor) {
        return false;
    }

    @Override
    public boolean covers(Collection<IFile> files, IMetaModelDescriptor mmDescriptor) {
        return false;
    }

    protected int getResourcesToUnloadCount(Map<TransactionalEditingDomain, Collection<Resource>> resourcesToUnload) {
        Assert.isNotNull(resourcesToUnload);
        int count = 0;
        for (TransactionalEditingDomain editingDomain : resourcesToUnload.keySet()) {
            count += resourcesToUnload.get(editingDomain).size();
        }
        return count;
    }
}

