/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.ui.properties;

import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.sphinx.emf.resource.ExtendedResource;
import org.eclipse.sphinx.emf.resource.ExtendedResourceAdapterFactory;
import org.eclipse.swt.widgets.Composite;

public class ProxyURICellEditor
extends TextCellEditor {
    protected ProxyURIHandler valueHandler;

    public ProxyURICellEditor(Composite parent, EObject owner, EStructuralFeature feature, EObject value) {
        super(parent);
        Assert.isNotNull((Object)owner);
        Assert.isNotNull((Object)feature);
        Assert.isNotNull((Object)value);
        this.valueHandler = new ProxyURIHandler(owner, value);
        this.setValidator(this.valueHandler);
    }

    public Object doGetValue() {
        String valueAsString = (String)super.doGetValue();
        return this.valueHandler.toObject(valueAsString);
    }

    public void doSetValue(Object value) {
        String valueAsString = this.valueHandler.toString(value);
        super.doSetValue((Object)valueAsString);
    }

    protected static class ProxyURIHandler
    implements ICellEditorValidator {
        protected EObject owner;
        protected EObject value;

        public ProxyURIHandler(EObject owner, EObject value) {
            Assert.isNotNull((Object)owner);
            Assert.isNotNull((Object)value);
            this.owner = owner;
            this.value = value;
        }

        public String isValid(Object value) {
            ExtendedResource extendedResource = ExtendedResourceAdapterFactory.INSTANCE.adapt(this.owner.eResource());
            if (extendedResource != null && value instanceof String) {
                Diagnostic diagnostic = extendedResource.validateURI((String)value);
                return Diagnostic.OK_INSTANCE == diagnostic ? null : diagnostic.getMessage();
            }
            return null;
        }

        public Object toObject(String valueAsString) {
            if (valueAsString.length() > 0) {
                URI proxyURI = URI.createURI((String)valueAsString);
                if (this.value == null || !proxyURI.equals(((InternalEObject)this.value).eProxyURI())) {
                    EFactory factory = this.value.eClass().getEPackage().getEFactoryInstance();
                    this.value = factory.create(this.value.eClass());
                    ((InternalEObject)this.value).eSetProxyURI(proxyURI);
                }
            } else if (this.value != null) {
                this.value = null;
            }
            return this.value;
        }

        public String toString(Object valueAsObject) {
            InternalEObject internalValue;
            if (valueAsObject instanceof String) {
                return (String)valueAsObject;
            }
            if (valueAsObject instanceof EObject && (internalValue = (InternalEObject)valueAsObject).eIsProxy()) {
                return internalValue.eProxyURI().toString();
            }
            return "";
        }
    }
}

