/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.compare.match;

import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.compare.match.IMatchEngine;
import org.eclipse.emf.compare.match.impl.MatchEngineFactoryImpl;
import org.eclipse.emf.compare.scope.IComparisonScope;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.sphinx.emf.compare.scope.IModelComparisonScope;
import org.eclipse.sphinx.emf.model.IModelDescriptor;
import org.eclipse.sphinx.emf.model.ModelDescriptorRegistry;

public abstract class AbstractModelMatchEngineFactory
extends MatchEngineFactoryImpl {
    protected abstract boolean isMatchEngineFactoryFor(IModelDescriptor var1);

    public AbstractModelMatchEngineFactory(IMatchEngine matchEngine) {
        this.matchEngine = matchEngine;
    }

    public boolean isMatchEngineFactoryFor(IComparisonScope scope) {
        if (scope instanceof IModelComparisonScope) {
            return this.isMatchEngineFactoryFor((IModelComparisonScope)scope);
        }
        Notifier left = scope.getLeft();
        Notifier right = scope.getRight();
        Notifier origin = scope.getOrigin();
        if (left instanceof EObject && right instanceof EObject && (origin == null || origin instanceof EObject) || left instanceof Resource && right instanceof Resource && (origin == null || origin instanceof Resource)) {
            IModelDescriptor modelDescriptor = this.getModelDescriptor(left);
            if (modelDescriptor == null) {
                modelDescriptor = this.getModelDescriptor(right);
            }
            return this.isMatchEngineFactoryFor(modelDescriptor);
        }
        return false;
    }

    public boolean isMatchEngineFactoryFor(IModelComparisonScope scope) {
        IFile left = scope.isFileBasedComparison() ? scope.getLeftFile() : scope.getLeft();
        IFile right = scope.isFileBasedComparison() ? scope.getRightFile() : scope.getRight();
        IModelDescriptor modelDescriptor = this.getModelDescriptor(left);
        if (modelDescriptor == null) {
            modelDescriptor = this.getModelDescriptor(right);
        }
        return modelDescriptor != null ? this.isMatchEngineFactoryFor(modelDescriptor) : true;
    }

    protected IModelDescriptor getModelDescriptor(Object object) {
        IModelDescriptor modelDescriptor = null;
        if (object instanceof IFile) {
            modelDescriptor = ModelDescriptorRegistry.INSTANCE.getModel((IFile)object);
        } else if (object instanceof Resource) {
            modelDescriptor = ModelDescriptorRegistry.INSTANCE.getModel((Resource)object);
        } else if (object instanceof EObject) {
            modelDescriptor = ModelDescriptorRegistry.INSTANCE.getModel(((EObject)object).eResource());
        }
        return modelDescriptor;
    }
}

