/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.platform.ui.fields;

import org.eclipse.sphinx.platform.ui.fields.BasicField;
import org.eclipse.sphinx.platform.ui.widgets.IWidgetFactory;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Hyperlink;

public class BasicHyperlinkField
extends BasicField {
    private HyperlinkAdapter fHyperlinkAdapter;

    public BasicHyperlinkField(IWidgetFactory widgetFactory, HyperlinkAdapter hyperlinkAdapter) {
        super(widgetFactory);
        this.fHyperlinkAdapter = hyperlinkAdapter;
    }

    @Override
    protected Control createLabelControl(Composite parent, boolean multiLine, int hspan) {
        this.assertCompositeNotNull(parent);
        Control labelControl = null;
        if (this.fWidgetFactory != null) {
            labelControl = this.fWidgetFactory.createHyperlink(parent, this.fLabelText != null ? this.fLabelText : "");
            if (labelControl != null) {
                labelControl.setFont(parent.getFont());
                if (this.fHyperlinkAdapter != null) {
                    ((Hyperlink)labelControl).addHyperlinkListener((IHyperlinkListener)this.fHyperlinkAdapter);
                }
            }
        } else {
            labelControl = super.createLabelControl(parent, multiLine, hspan);
        }
        return labelControl;
    }

    @Override
    public void setLabelText(String labeltext) {
        super.setLabelText(labeltext);
        if (this.isOkToUse(this.fLabelControl) && this.fLabelControl instanceof Hyperlink) {
            ((Hyperlink)this.fLabelControl).setText(labeltext);
        }
    }
}

