/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.workspace.domain;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.sphinx.emf.metamodel.IMetaModelDescriptor;
import org.eclipse.sphinx.emf.metamodel.MetaModelDescriptorRegistry;
import org.eclipse.sphinx.emf.workspace.Activator;
import org.eclipse.sphinx.emf.workspace.domain.factory.ExtendedWorkspaceEditingDomainFactory;
import org.eclipse.sphinx.emf.workspace.domain.factory.IExtendedTransactionalEditingDomainFactory;
import org.eclipse.sphinx.emf.workspace.domain.mapping.DefaultWorkspaceEditingDomainMapping;
import org.eclipse.sphinx.emf.workspace.domain.mapping.IWorkspaceEditingDomainMapping;
import org.eclipse.sphinx.emf.workspace.internal.messages.Messages;
import org.eclipse.sphinx.platform.util.PlatformLogUtil;

public final class WorkspaceEditingDomainManager {
    private static final String EXTPOINT_EDITINGDOMAINS = "org.eclipse.sphinx.emf.workspace.editingDomains";
    private static final String NODE_MAPPING = "mapping";
    private static final String NODE_FACTORY = "factory";
    private static final String ATTR_CLASS = "class";
    private static final String NODE_REQUIRED_FOR = "requiredFor";
    private static final String ATTR_MMDESC_ID_PATTERN = "metaModelDescriptorIdPattern";
    public static final WorkspaceEditingDomainManager INSTANCE = new WorkspaceEditingDomainManager();
    protected IWorkspaceEditingDomainMapping fEditingDomainMapping;
    protected Map<IMetaModelDescriptor, IExtendedTransactionalEditingDomainFactory> fEditingDomainFactories = new HashMap<IMetaModelDescriptor, IExtendedTransactionalEditingDomainFactory>();

    private WorkspaceEditingDomainManager() {
    }

    public synchronized IWorkspaceEditingDomainMapping getEditingDomainMapping() {
        if (this.fEditingDomainMapping == null) {
            IConfigurationElement[] iConfigurationElementArray = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTPOINT_EDITINGDOMAINS);
            int n = iConfigurationElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement cfgElement = iConfigurationElementArray[n2];
                if (NODE_MAPPING.equals(cfgElement.getName())) {
                    Assert.isTrue((this.fEditingDomainMapping == null ? 1 : 0) != 0, (String)Messages.error_multipleMappingsConfigured);
                    try {
                        this.fEditingDomainMapping = (IWorkspaceEditingDomainMapping)cfgElement.createExecutableExtension(ATTR_CLASS);
                    }
                    catch (CoreException coreException) {
                        String message = MessageFormat.format(Messages.error_createMapping, cfgElement.getAttribute(ATTR_CLASS));
                        PlatformLogUtil.logAsWarning((Plugin)Activator.getPlugin(), (Object)message);
                    }
                }
                ++n2;
            }
            if (this.fEditingDomainMapping == null) {
                this.fEditingDomainMapping = new DefaultWorkspaceEditingDomainMapping();
            }
        }
        return this.fEditingDomainMapping;
    }

    public void setEditingDomainMapping(IWorkspaceEditingDomainMapping editingDomainMapping) {
        if (this.fEditingDomainMapping != null) {
            this.fEditingDomainMapping.dispose();
        }
        this.fEditingDomainMapping = editingDomainMapping;
    }

    public void resetEditingDomainMapping() {
        if (this.fEditingDomainMapping != null) {
            this.fEditingDomainMapping.dispose();
        }
        this.fEditingDomainMapping = null;
    }

    public synchronized IExtendedTransactionalEditingDomainFactory getEditingDomainFactory(IMetaModelDescriptor mmDescriptor) {
        IExtendedTransactionalEditingDomainFactory factory;
        if (this.fEditingDomainFactories.isEmpty()) {
            this.fEditingDomainFactories.put(MetaModelDescriptorRegistry.ANY_MM, new ExtendedWorkspaceEditingDomainFactory());
            this.readContributedEditingDomainFactories();
        }
        if ((factory = this.fEditingDomainFactories.get(mmDescriptor)) == null) {
            factory = this.fEditingDomainFactories.get(MetaModelDescriptorRegistry.ANY_MM);
        }
        return factory;
    }

    private void readContributedEditingDomainFactories() {
        IConfigurationElement[] iConfigurationElementArray = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTPOINT_EDITINGDOMAINS);
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement cfgElement = iConfigurationElementArray[n2];
            if (NODE_FACTORY.equals(cfgElement.getName())) {
                IExtendedTransactionalEditingDomainFactory editingDomainFactory = this.getEditingDomainFactory(cfgElement);
                IConfigurationElement[] iConfigurationElementArray2 = cfgElement.getChildren(NODE_REQUIRED_FOR);
                int n3 = iConfigurationElementArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement requiredFor = iConfigurationElementArray2[n4];
                    String mmDescriptorIdPattern = requiredFor.getAttribute(ATTR_MMDESC_ID_PATTERN);
                    List descriptors = MetaModelDescriptorRegistry.INSTANCE.getDescriptors(mmDescriptorIdPattern);
                    for (IMetaModelDescriptor descriptor : descriptors) {
                        this.fEditingDomainFactories.put(descriptor, editingDomainFactory);
                    }
                    ++n4;
                }
            }
            ++n2;
        }
    }

    private IExtendedTransactionalEditingDomainFactory getEditingDomainFactory(IConfigurationElement configElement) {
        IExtendedTransactionalEditingDomainFactory editingDomainFactory = null;
        try {
            editingDomainFactory = (IExtendedTransactionalEditingDomainFactory)configElement.createExecutableExtension(ATTR_CLASS);
        }
        catch (CoreException ex) {
            String message = MessageFormat.format(Messages.error_createEditingDomainFactory, configElement.getAttribute(ATTR_CLASS));
            PlatformLogUtil.logAsWarning((Plugin)Activator.getPlugin(), (Object)new WrappedException(message, (Exception)((Object)ex)));
        }
        if (editingDomainFactory == null) {
            editingDomainFactory = new ExtendedWorkspaceEditingDomainFactory();
        }
        return editingDomainFactory;
    }
}

