/**
 * <copyright>
 * 
 * Copyright (c) 2015 itemis and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     itemis - Initial API and implementation
 * 
 * </copyright>
 */
package org.eclipse.sphinx.platform.ui.views.documentation.bootstrap;

import com.google.common.base.Objects;
import org.eclipse.sphinx.platform.ui.internal.Activator;
import org.eclipse.sphinx.platform.ui.views.documentation.IDocumentationSection;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

@SuppressWarnings("all")
public class BootstrapFormatterHTML {
  public static String format(final String title, final String content, final Iterable<IDocumentationSection> sections) {
    String _pre = BootstrapFormatterHTML.pre(title, sections);
    String _plus = (_pre + content);
    String _post = BootstrapFormatterHTML.post();
    return (_plus + _post);
  }
  
  public static String pre(final String title, final Iterable<IDocumentationSection> sections) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("\t");
    _builder.append("<html lang=\"en\">");
    _builder.newLine();
    _builder.append(" ");
    _builder.append("<head>");
    _builder.newLine();
    _builder.append("   ");
    _builder.append("<meta charset=\"utf-8\">");
    _builder.newLine();
    _builder.append("   ");
    _builder.append("<meta http-equiv=\"X-UA-Compatible\" content=\"IE=edge\">");
    _builder.newLine();
    _builder.append("   ");
    _builder.append("<meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\">");
    _builder.newLine();
    _builder.append("   ");
    _builder.append("<meta name=\"description\" content=\"\">");
    _builder.newLine();
    _builder.append("   ");
    _builder.append("<meta name=\"author\" content=\"\">");
    _builder.newLine();
    _builder.append(" ");
    _builder.newLine();
    _builder.append("   ");
    _builder.append("<title>Sticky Footer Navbar Template for Bootstrap</title>");
    _builder.newLine();
    _builder.newLine();
    _builder.append("    ");
    _builder.append("<!-- Bootstrap core CSS -->");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("<link href=\"");
    String _bootstrapDir = Activator.getBootstrapDir();
    String _plus = ("" + _bootstrapDir);
    _builder.append(_plus, "    ");
    _builder.append("/css/bootstrap.css\" rel=\"stylesheet\">");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("    ");
    _builder.append("<!-- Custom styles for this template -->");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("<link href=\"sticky-footer-navbar.css\" rel=\"stylesheet\">");
    _builder.newLine();
    _builder.newLine();
    _builder.append("   ");
    _builder.newLine();
    _builder.append("   ");
    _builder.append("</head>");
    _builder.newLine();
    _builder.newLine();
    _builder.append("  ");
    _builder.append("<body>");
    _builder.newLine();
    _builder.newLine();
    _builder.append("    ");
    _builder.append("<!-- Wrap all page content here -->");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("<div id=\"wrap\">");
    _builder.newLine();
    _builder.newLine();
    _builder.append("      ");
    _builder.append("<!-- Fixed navbar -->");
    _builder.newLine();
    _builder.append("      ");
    _builder.append("<div class=\"navbar navbar-default navbar-fixed-top\" role=\"navigation\">");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("<div class=\"container\">");
    _builder.newLine();
    _builder.append("          ");
    _builder.append("<div class=\"navbar-header\">");
    _builder.newLine();
    _builder.append("            ");
    _builder.append("<button type=\"button\" class=\"navbar-toggle\" data-toggle=\"collapse\" data-target=\".navbar-collapse\">");
    _builder.newLine();
    _builder.append("              ");
    _builder.append("<span class=\"sr-only\">Toggle navigation</span>");
    _builder.newLine();
    _builder.append("              ");
    _builder.append("<span class=\"icon-bar\"></span>");
    _builder.newLine();
    _builder.append("              ");
    _builder.append("<span class=\"icon-bar\"></span>");
    _builder.newLine();
    _builder.append("              ");
    _builder.append("<span class=\"icon-bar\"></span>");
    _builder.newLine();
    _builder.append("            ");
    _builder.append("</button>");
    _builder.newLine();
    _builder.append("            ");
    _builder.append("<a class=\"navbar-brand\" href=\"#\">");
    _builder.append(title, "            ");
    _builder.append(" </a>");
    _builder.newLineIfNotEmpty();
    _builder.append("          ");
    _builder.append("</div>");
    _builder.newLine();
    _builder.append("          ");
    _builder.append("<div class=\"collapse navbar-collapse\">");
    _builder.newLine();
    _builder.append("            ");
    _builder.append("<ul class=\"nav navbar-nav\">");
    _builder.newLine();
    _builder.append("              ");
    _builder.newLine();
    {
      final Function1<IDocumentationSection, Boolean> _function = new Function1<IDocumentationSection, Boolean>() {
        public Boolean apply(final IDocumentationSection x) {
          String _sectionTitle = x.getSectionTitle();
          return Boolean.valueOf((!Objects.equal(_sectionTitle, null)));
        }
      };
      Iterable<IDocumentationSection> _filter = IterableExtensions.<IDocumentationSection>filter(sections, _function);
      for(final IDocumentationSection s : _filter) {
        _builder.append("              ");
        _builder.append("<li><a href=\"#");
        String _sectionTitle = s.getSectionTitle();
        _builder.append(_sectionTitle, "              ");
        _builder.append("\">");
        String _sectionTitle_1 = s.getSectionTitle();
        _builder.append(_sectionTitle_1, "              ");
        _builder.append("</a></li>");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.append("            ");
    _builder.append("</ul>");
    _builder.newLine();
    _builder.append("          ");
    _builder.append("</div><!--/.nav-collapse -->");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("</div>");
    _builder.newLine();
    _builder.append("      ");
    _builder.append("</div>");
    _builder.newLine();
    _builder.newLine();
    _builder.append("      ");
    _builder.append("<!-- Begin page content -->");
    _builder.newLine();
    _builder.append("      ");
    _builder.append("<div class=\"container\">");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("<div class=\"page-header\">");
    _builder.newLine();
    _builder.append("          ");
    _builder.append("<h1></h1>");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("</div>");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("<p class=\"lead\">");
    _builder.newLine();
    _builder.append("       ");
    final Function1<IDocumentationSection, Boolean> _function_1 = new Function1<IDocumentationSection, Boolean>() {
      public Boolean apply(final IDocumentationSection x) {
        boolean _or = false;
        String _sectionTitle = x.getSectionTitle();
        boolean _equals = Objects.equal(_sectionTitle, null);
        if (_equals) {
          _or = true;
        } else {
          String _sectionTitle_1 = x.getSectionTitle();
          int _length = _sectionTitle_1.length();
          boolean _equals_1 = (_length == 0);
          _or = _equals_1;
        }
        return Boolean.valueOf(_or);
      }
    };
    Iterable<IDocumentationSection> _filter_1 = IterableExtensions.<IDocumentationSection>filter(sections, _function_1);
    IDocumentationSection _head = IterableExtensions.<IDocumentationSection>head(_filter_1);
    String _sectionBody = null;
    if (_head!=null) {
      _sectionBody=_head.getSectionBody();
    }
    _builder.append(_sectionBody, "       ");
    _builder.append("</p>");
    _builder.newLineIfNotEmpty();
    _builder.append("      ");
    _builder.append("</div>");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("</div>");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    _builder.append("<div class=\"container\">");
    _builder.newLine();
    _builder.append("\t    ");
    _builder.newLine();
    _builder.append("\t");
    _builder.newLine();
    return _builder.toString();
  }
  
  public static String post() {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("\t");
    _builder.append("</div>");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("<div id=\"footer\">");
    _builder.newLine();
    _builder.append("     ");
    _builder.append("<div class=\"container\">");
    _builder.newLine();
    _builder.append("       ");
    _builder.append("<p class=\"text-muted credit\">End of Information.</p>");
    _builder.newLine();
    _builder.append("     ");
    _builder.append("</div>");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("</div>");
    _builder.newLine();
    _builder.newLine();
    _builder.append("    ");
    _builder.append("<script src=\"");
    String _jQueryDir = Activator.getJQueryDir();
    String _plus = ("" + _jQueryDir);
    _builder.append(_plus, "    ");
    _builder.append("/jquery-1.11.1.js\"></script>");
    _builder.newLineIfNotEmpty();
    _builder.append("    ");
    _builder.append("<script src=\"");
    String _bootstrapDir = Activator.getBootstrapDir();
    String _plus_1 = ("" + _bootstrapDir);
    _builder.append(_plus_1, "    ");
    _builder.append("/js/bootstrap.min.js\"></script>");
    _builder.newLineIfNotEmpty();
    _builder.append("  ");
    _builder.append("</body>");
    _builder.newLine();
    _builder.append("</html>");
    _builder.newLine();
    return _builder.toString();
  }
}
