/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.workspace.internal.loading;

import java.util.Collection;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.sphinx.emf.metamodel.IMetaModelDescriptor;
import org.eclipse.sphinx.emf.workspace.Activator;
import org.eclipse.sphinx.emf.workspace.loading.operations.AbstractLoadOperation;
import org.eclipse.sphinx.platform.IExtendedPlatformConstants;
import org.eclipse.sphinx.platform.util.StatusUtil;

public class ModelLoadJob<T extends AbstractLoadOperation>
extends Job {
    protected T operation;

    public ModelLoadJob(T operation) {
        super(operation.getLabel());
        this.operation = operation;
    }

    protected IStatus run(IProgressMonitor monitor) {
        try {
            this.operation.run(monitor);
            return Status.OK_STATUS;
        }
        catch (OperationCanceledException ex) {
            return Status.CANCEL_STATUS;
        }
        catch (CoreException ex) {
            return ex.getStatus();
        }
        catch (Exception ex) {
            return StatusUtil.createErrorStatus((Plugin)Activator.getPlugin(), (Object)ex);
        }
    }

    public T getOperation() {
        return this.operation;
    }

    public boolean belongsTo(Object family) {
        return IExtendedPlatformConstants.FAMILY_MODEL_LOADING.equals(family) || IExtendedPlatformConstants.FAMILY_LONG_RUNNING.equals(family);
    }

    public boolean covers(Collection<IProject> projects, boolean includeReferencedProjects, IMetaModelDescriptor mmDescriptor) {
        return ((AbstractLoadOperation)((Object)this.operation)).covers(projects, includeReferencedProjects, mmDescriptor);
    }

    public boolean covers(Collection<IFile> files, IMetaModelDescriptor mmDescriptor) {
        return ((AbstractLoadOperation)((Object)this.operation)).covers(files, mmDescriptor);
    }
}

