/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.mwe.dynamic;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.emf.mwe2.runtime.workflow.Workflow;
import org.eclipse.jdt.core.IType;
import org.eclipse.sphinx.emf.mwe.dynamic.internal.Activator;
import org.eclipse.sphinx.jdt.util.JavaExtensions;
import org.eclipse.sphinx.platform.util.PlatformLogUtil;
import org.eclipse.sphinx.platform.util.StatusUtil;

public class WorkflowContributorRegistry {
    private static final String EXTP_WORKFLOW_CONTRIBUTORS = String.valueOf(Activator.INSTANCE.getSymbolicName()) + ".workflowContributors";
    private static final String ELEM_CONTRIBUTOR = "contributor";
    private static final String ATTR_PLUGIN_ID = "pluginId";
    public static final WorkflowContributorRegistry INSTANCE = new WorkflowContributorRegistry(Platform.getExtensionRegistry(), PlatformLogUtil.getLog((Plugin)Activator.getPlugin()));
    private Set<String> contributorPluginIds = null;
    private IExtensionRegistry extensionRegistry;
    private ILog log;

    protected WorkflowContributorRegistry(IExtensionRegistry extensionRegistry, ILog log) {
        this.extensionRegistry = extensionRegistry;
        this.log = log;
    }

    public Set<String> getContributorPluginIds() {
        this.initialize();
        return this.contributorPluginIds != null ? this.contributorPluginIds : Collections.emptySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialize() {
        if (this.extensionRegistry == null) {
            return;
        }
        if (this.contributorPluginIds == null) {
            WorkflowContributorRegistry workflowContributorRegistry = this;
            synchronized (workflowContributorRegistry) {
                IConfigurationElement[] elements;
                this.contributorPluginIds = new HashSet<String>();
                IConfigurationElement[] iConfigurationElementArray = elements = this.extensionRegistry.getConfigurationElementsFor(EXTP_WORKFLOW_CONTRIBUTORS);
                int n = elements.length;
                int n2 = 0;
                while (n2 < n) {
                    IConfigurationElement element = iConfigurationElementArray[n2];
                    if (element.getName().equals(ELEM_CONTRIBUTOR)) {
                        String id = element.getAttribute(ATTR_PLUGIN_ID);
                        if (id == null || id.isEmpty()) {
                            String msg = "Missing contributor id in " + EXTP_WORKFLOW_CONTRIBUTORS + " extension from " + element.getContributor().getName();
                            IStatus status = StatusUtil.createErrorStatus((Plugin)Activator.getPlugin(), (Object)new RuntimeException(msg));
                            this.log.log(status);
                        } else {
                            this.contributorPluginIds.add(id);
                        }
                    }
                    ++n2;
                }
            }
        }
    }

    public boolean isContributorClasspathLocation(IPath classpathLocation) {
        return this.getContributorPluginId(classpathLocation) != null;
    }

    private String getContributorPluginId(IPath classpathLocation) {
        if (classpathLocation != null && classpathLocation.segmentCount() > 1) {
            for (String id : this.getContributorPluginIds()) {
                if (!JavaExtensions.isInstalledPluginClasspathRootLocationOf((String)id, (IPath)classpathLocation) && !JavaExtensions.isDevModePluginClasspathLocationOf((String)id, (IPath)classpathLocation)) continue;
                return id;
            }
        }
        return null;
    }

    public boolean matchesContributedWorkflowClass(IType workflowType) {
        try {
            return this.loadContributedWorkflowClass(workflowType) != null;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public Class<Workflow> loadContributedWorkflowClass(IType workflowType) throws CoreException {
        Assert.isNotNull((Object)workflowType);
        try {
            String contributorPluginId = this.getContributorPluginId(workflowType.getPath());
            if (contributorPluginId == null) {
                throw new IllegalStateException("Workflow '" + workflowType.getFullyQualifiedName() + "' is not contained in any registered workflow contributor plug-in");
            }
            Class clazz = CommonPlugin.loadClass((String)contributorPluginId, (String)workflowType.getFullyQualifiedName());
            if (!Workflow.class.isAssignableFrom(clazz)) {
                throw new IllegalStateException("Workflow class '" + clazz.getName() + "' is not a subclass of " + Workflow.class.getName());
            }
            Class workflowClass = clazz;
            return workflowClass;
        }
        catch (Exception ex) {
            IStatus status = StatusUtil.createErrorStatus((Plugin)Activator.getPlugin(), (Object)ex);
            throw new CoreException(status);
        }
    }
}

