/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.platform.cli;

import java.util.Map;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;

public abstract class AbstractCLIApplication
implements IApplication {
    public static final Object ERROR_NO = 0;
    public static final Object ERROR_UNSPECIFIED = 1;
    private static final String OPTION_HELP_NAME = "help";
    private static final String OPTION_HELP_DESCRIPTION = "print help documentation";
    private String[] applicationArgs;
    private Options options = new Options();
    private CommandLineParser parser;
    private CommandLine commandLine = null;

    @Deprecated
    protected String getApplicationName() {
        return null;
    }

    protected String getApplicationDescription() {
        return null;
    }

    protected String getCommandLineSyntax() {
        return this.getApplicationName();
    }

    protected String[] getApplicationArgs() {
        return this.applicationArgs;
    }

    protected Options getOptions() {
        return this.options;
    }

    protected void addOption(Option option) {
        if (option != null) {
            this.options.addOption(option);
        }
    }

    protected CommandLine getCommandLine() {
        return this.commandLine;
    }

    public Object start(IApplicationContext context) {
        this.initApplicationArgs(context);
        return this.doRun();
    }

    public void stop() {
    }

    public Object run(String[] args) {
        this.initApplicationArgs(args);
        return this.doRun();
    }

    private Object doRun() {
        try {
            this.defineOptions();
            this.parse();
            return this.interrogate();
        }
        catch (Throwable t) {
            return this.handleError(t);
        }
    }

    private void initApplicationArgs(IApplicationContext context) {
        Map arguments = context.getArguments();
        Object args = arguments.get("application.args");
        this.applicationArgs = args instanceof String[] ? (String[])args : new String[]{};
    }

    private void initApplicationArgs(String[] args) {
        this.applicationArgs = args != null ? args : new String[]{};
    }

    protected void defineOptions() {
        this.addOption(new Option(OPTION_HELP_NAME, OPTION_HELP_DESCRIPTION));
    }

    protected void parse() throws ParseException {
        this.commandLine = this.getParser().parse(this.getOptions(), this.getApplicationArgs());
    }

    protected CommandLineParser getParser() {
        if (this.parser == null) {
            this.parser = this.createParser();
        }
        return this.parser;
    }

    protected CommandLineParser createParser() {
        return new PosixParser();
    }

    protected Object interrogate() throws Throwable {
        CommandLine commandLine = this.getCommandLine();
        if (commandLine.getOptions().length == 0 || commandLine.hasOption(OPTION_HELP_NAME)) {
            this.printHelp();
            throw new OperationCanceledException();
        }
        return ERROR_NO;
    }

    protected void printHelp() {
        String description = this.getApplicationDescription();
        if (description != null && description.length() > 0) {
            System.out.println(description);
            System.out.println();
        }
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp(this.getCommandLineSyntax(), this.getOptions());
    }

    protected Object handleError(Throwable throwable) {
        if (throwable instanceof OperationCanceledException) {
            return ERROR_NO;
        }
        System.err.println(throwable.getMessage());
        return ERROR_UNSPECIFIED;
    }
}

