/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.workspace.referentialintegrity;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sphinx.emf.workspace.Activator;
import org.eclipse.sphinx.emf.workspace.internal.messages.Messages;
import org.eclipse.sphinx.emf.workspace.referentialintegrity.IURIChangeDetectorDelegate;
import org.eclipse.sphinx.platform.util.PlatformLogUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class URIChangeDetectorDelegateRegistry {
    private static final String EXTP_URI_CHANGE_DETECTOR_DELEGATE = "org.eclipse.sphinx.emf.workspace.uriChangeDetectorDelegates";
    private static final String NODE_APPLICABLEFOR = "applicableFor";
    private static final String NODE_DELEGATE = "delegate";
    private static final String ATTR_ID = "id";
    private static final String ATTR_CLASS = "class";
    private static final String ATTR_OVERRIDE = "override";
    private static final String ATTR_RESOURCE_TYPE = "resourceType";
    public static URIChangeDetectorDelegateRegistry INSTANCE = new URIChangeDetectorDelegateRegistry();
    private Map<Class<? extends Resource>, IURIChangeDetectorDelegate> fContributedURIChangeDetectorDelegates = new HashMap<Class<? extends Resource>, IURIChangeDetectorDelegate>();

    private URIChangeDetectorDelegateRegistry() {
        this.readContributedURIChangeDetectors();
    }

    public IURIChangeDetectorDelegate getDetectorDelegate(Resource resource) {
        if (resource != null) {
            Class<?> resourceClass = resource.getClass();
            return this.getDetectorDelegate(resourceClass);
        }
        return null;
    }

    public void removeDelegate(IURIChangeDetectorDelegate delegate) {
        if (delegate != null) {
            for (Class<? extends Resource> resourceType : this.fContributedURIChangeDetectorDelegates.keySet()) {
                if (!this.fContributedURIChangeDetectorDelegates.get(resourceType).equals(delegate)) continue;
                this.fContributedURIChangeDetectorDelegates.remove(resourceType);
            }
        }
    }

    public IURIChangeDetectorDelegate getDetectorDelegate(Class<? extends Resource> resourceType) {
        IURIChangeDetectorDelegate uriChangeDetectorDelegate = this.fContributedURIChangeDetectorDelegates.get(resourceType);
        if (uriChangeDetectorDelegate == null && (uriChangeDetectorDelegate = this.getDetectorDelegateOfSuperType(resourceType)) != null) {
            this.fContributedURIChangeDetectorDelegates.put(resourceType, uriChangeDetectorDelegate);
        }
        return uriChangeDetectorDelegate;
    }

    private IURIChangeDetectorDelegate getDetectorDelegateOfSuperType(Class<? extends Resource> resourceClass) {
        Class<? extends Resource> superclass = resourceClass.getSuperclass();
        if (Resource.class.equals(superclass) || ResourceImpl.class.equals(superclass)) {
            return this.fContributedURIChangeDetectorDelegates.get(ResourceImpl.class);
        }
        IURIChangeDetectorDelegate uriChangeDetectorDelegate = this.fContributedURIChangeDetectorDelegates.get(superclass);
        if (uriChangeDetectorDelegate == null) {
            return this.getDetectorDelegateOfSuperType(superclass);
        }
        return uriChangeDetectorDelegate;
    }

    private void readContributedURIChangeDetectors() {
        IConfigurationElement[] configElements;
        IExtension extension;
        IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = extensionRegistry.getExtensionPoint(EXTP_URI_CHANGE_DETECTOR_DELEGATE);
        IExtension[] extensions = extensionPoint.getExtensions();
        HashSet<String> overriddenIds = new HashSet<String>();
        IExtension[] iExtensionArray = extensions;
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            extension = iExtensionArray[n2];
            configElements = extension.getConfigurationElements();
            overriddenIds.addAll(this.getOverriddenURIChangeDetectorsIds(configElements));
            ++n2;
        }
        iExtensionArray = extensions;
        n = extensions.length;
        n2 = 0;
        while (n2 < n) {
            extension = iExtensionArray[n2];
            configElements = extension.getConfigurationElements();
            this.readContributedURIChangeDetectors(configElements, overriddenIds);
            ++n2;
        }
    }

    private void readContributedURIChangeDetectors(IConfigurationElement[] configElements, Set<String> overriddenIds) {
        IConfigurationElement[] iConfigurationElementArray = configElements;
        int n = configElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement configElement = iConfigurationElementArray[n2];
            try {
                String id = configElement.getAttribute(ATTR_ID);
                IURIChangeDetectorDelegate uriChangeDetectorDelegate = null;
                if (!overriddenIds.contains(id)) {
                    IConfigurationElement[] childrenConfigElements;
                    uriChangeDetectorDelegate = (IURIChangeDetectorDelegate)configElement.createExecutableExtension(ATTR_CLASS);
                    IConfigurationElement[] iConfigurationElementArray2 = childrenConfigElements = configElement.getChildren();
                    int n3 = childrenConfigElements.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IConfigurationElement childConfigElement = iConfigurationElementArray2[n4];
                        if (NODE_APPLICABLEFOR.equals(childConfigElement.getName())) {
                            String className = childConfigElement.getAttribute(ATTR_RESOURCE_TYPE);
                            Class clazz = Platform.getBundle((String)configElement.getContributor().getName()).loadClass(className);
                            if (Resource.class.isAssignableFrom(clazz)) {
                                Class resourceType = clazz;
                                this.addDelegate(resourceType, uriChangeDetectorDelegate);
                            }
                        }
                        ++n4;
                    }
                }
            }
            catch (Exception ex) {
                PlatformLogUtil.logAsError((Plugin)Activator.getDefault(), (Object)ex);
            }
            ++n2;
        }
    }

    private Set<String> getOverriddenURIChangeDetectorsIds(IConfigurationElement[] configElements) {
        Assert.isNotNull((Object)configElements);
        HashSet<String> overriddenIds = new HashSet<String>();
        IConfigurationElement[] iConfigurationElementArray = configElements;
        int n = configElements.length;
        int n2 = 0;
        while (n2 < n) {
            String overriddenURIChangeDetectorDelegateId;
            IConfigurationElement configElement = iConfigurationElementArray[n2];
            if (NODE_DELEGATE.equals(configElement.getName()) && (overriddenURIChangeDetectorDelegateId = configElement.getAttribute(ATTR_OVERRIDE)) != null) {
                if (!overriddenIds.contains(overriddenURIChangeDetectorDelegateId)) {
                    overriddenIds.add(overriddenURIChangeDetectorDelegateId);
                } else {
                    PlatformLogUtil.logAsWarning((Plugin)Activator.getPlugin(), (Object)new RuntimeException(NLS.bind((String)Messages.warning_multipleOverridesForSameURIChangeDetectorDelegate, (Object)overriddenURIChangeDetectorDelegateId)));
                }
            }
            ++n2;
        }
        return overriddenIds;
    }

    public void addDelegate(Class<? extends Resource> resourceType, IURIChangeDetectorDelegate uriChangeDetectorDelegate) {
        if (this.fContributedURIChangeDetectorDelegates.get(resourceType) == null) {
            this.fContributedURIChangeDetectorDelegates.put(resourceType, uriChangeDetectorDelegate);
        } else {
            PlatformLogUtil.logAsWarning((Plugin)Activator.getPlugin(), (Object)new RuntimeException(NLS.bind((String)Messages.warning_multipleURIChangeDetectorDelegatesContributedForSameResourceType, resourceType)));
        }
    }
}

