/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.workspace.ui.wizards.pages;

import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.Iterator;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sphinx.emf.workspace.ui.internal.Activator;
import org.eclipse.sphinx.emf.workspace.ui.internal.messages.Messages;
import org.eclipse.sphinx.emf.workspace.ui.wizards.pages.CreateLinkedResourceGroup;
import org.eclipse.sphinx.platform.util.PlatformLogUtil;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.undo.CreateFolderOperation;
import org.eclipse.ui.ide.undo.WorkspaceUndoUtil;

public class LinkedFolderCreationMainPage
extends WizardPage
implements Listener {
    private IStructuredSelection currentSelection;
    private IFolder newFolder;
    private String folderName;
    private URI linkTargetPath;
    private IPath initialContainerFullPath;
    private CreateLinkedResourceGroup linkedResourceGroup;
    private Composite linkedResourceParent;
    private Composite linkedResourceComposite;
    private int linkedResourceGroupHeight = -1;
    private boolean firstLinkCheck = true;

    public LinkedFolderCreationMainPage(IStructuredSelection selection) {
        super(Messages.wizardNewLinkedFolderCreationPage_title.replaceAll("[^A-Z]", ""));
        this.setTitle(Messages.wizardNewLinkedFolderCreationPage_title);
        this.setDescription(Messages.wizardNewLinkedFolderCreationPage_description);
        this.setPageComplete(false);
        this.currentSelection = selection;
        this.initializeContainerPath();
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(272));
        this.doCreateControls(composite);
        this.validatePage();
        this.setControl((Control)composite);
    }

    protected void doCreateControls(Composite parent) {
        Preferences preferences = ResourcesPlugin.getPlugin().getPluginPreferences();
        if (!preferences.getBoolean("description.disableLinking")) {
            this.linkedResourceParent = new Composite(parent, 0);
            this.linkedResourceParent.setFont(parent.getFont());
            this.linkedResourceParent.setLayoutData((Object)new GridData(768));
            GridLayout layout = new GridLayout();
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            this.linkedResourceParent.setLayout((Layout)layout);
        }
        this.linkedResourceGroup = new CreateLinkedResourceGroup(2, new Listener(){

            public void handleEvent(Event e) {
                LinkedFolderCreationMainPage.this.firstLinkCheck = false;
                LinkedFolderCreationMainPage.this.setPageComplete(LinkedFolderCreationMainPage.this.validatePage());
            }
        }, new CreateLinkedResourceGroup.IStringValue(){

            public String getValue() {
                return LinkedFolderCreationMainPage.this.getFolderName();
            }

            public void setValue(String string) {
                LinkedFolderCreationMainPage.this.setFolderName(string);
            }
        });
        this.doShellResizing(parent);
    }

    private void setFolderName(String string) {
        this.folderName = string;
    }

    protected String getFolderName() {
        return this.folderName;
    }

    protected IFolder createFolderHandle(IPath folderPath) {
        return ResourcesPlugin.getWorkspace().getRoot().getFolder(folderPath);
    }

    protected void createLinkTarget() {
        this.linkTargetPath = this.linkedResourceGroup.getLinkTargetURI();
    }

    public IFolder createNewLinkedFolder() {
        if (this.newFolder != null) {
            return this.newFolder;
        }
        IPath containerPath = this.getContainerFullPath();
        IPath newFolderPath = containerPath.append(this.getFolderName());
        final IFolder newFolderHandle = this.createFolderHandle(newFolderPath);
        this.createLinkTarget();
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) {
                CreateFolderOperation createFolderOperation = new CreateFolderOperation(newFolderHandle, LinkedFolderCreationMainPage.this.linkTargetPath, Messages.wizardNewLinkedFolderCreationPage_title);
                try {
                    PlatformUI.getWorkbench().getOperationSupport().getOperationHistory().execute((IUndoableOperation)createFolderOperation, monitor, WorkspaceUndoUtil.getUIInfoAdapter((Shell)LinkedFolderCreationMainPage.this.getShell()));
                }
                catch (ExecutionException e) {
                    LinkedFolderCreationMainPage.this.getContainer().getShell().getDisplay().syncExec(new Runnable(){

                        public void run() {
                            if (e.getCause() instanceof CoreException) {
                                ErrorDialog.openError((Shell)LinkedFolderCreationMainPage.this.getContainer().getShell(), (String)Messages.wizardNewLinkedFolderCreationPage_errorTitle, null, (IStatus)((CoreException)e.getCause()).getStatus());
                            } else {
                                PlatformLogUtil.logAsError((Plugin)Activator.getPlugin(), (Object)("createNewLinkedFolder()" + e.getCause()));
                                MessageDialog.openError((Shell)LinkedFolderCreationMainPage.this.getContainer().getShell(), (String)Messages.wizardNewLinkedFolderCreationPage_internalErrorTitle, (String)NLS.bind((String)Messages.wizardNewLinkedFolderCreationPage_internalErrorMessage, (Object)e.getCause().getMessage()));
                            }
                        }
                    });
                }
            }
        };
        try {
            this.getContainer().run(true, true, runnable);
        }
        catch (InterruptedException interruptedException) {
            return null;
        }
        catch (InvocationTargetException e) {
            PlatformLogUtil.logAsError((Plugin)Activator.getPlugin(), (Object)("createNewFolder()" + e.getTargetException()));
            MessageDialog.openError((Shell)this.getContainer().getShell(), (String)Messages.wizardNewLinkedFolderCreationPage_internalErrorTitle, (String)NLS.bind((String)Messages.wizardNewLinkedFolderCreationPage_internalErrorMessage, (Object)e.getTargetException().getMessage()));
            return null;
        }
        this.newFolder = newFolderHandle;
        return this.newFolder;
    }

    protected void doShellResizing(Composite parent) {
        Shell shell = this.getShell();
        Point shellSize = shell.getSize();
        Composite composite = parent;
        if (this.linkedResourceComposite != null) {
            this.linkedResourceComposite.dispose();
            this.linkedResourceComposite = null;
            composite.layout();
            shell.setSize(shellSize.x, shellSize.y - this.linkedResourceGroupHeight);
        } else {
            this.linkedResourceComposite = this.linkedResourceGroup.createContents(this.linkedResourceParent);
            if (this.linkedResourceGroupHeight == -1) {
                Point groupSize = this.linkedResourceComposite.computeSize(-1, -1, true);
                this.linkedResourceGroupHeight = groupSize.y;
            }
            shell.setSize(600, 300 + this.linkedResourceGroupHeight);
            composite.layout();
        }
    }

    public void handleEvent(Event ev) {
        this.setPageComplete(this.validatePage());
    }

    protected void initializeContainerPath() {
        Iterator it = this.currentSelection.iterator();
        if (it.hasNext()) {
            Object next = it.next();
            IResource selectedResource = null;
            if (next instanceof IResource) {
                selectedResource = (IResource)next;
            } else if (next instanceof IAdaptable) {
                selectedResource = (IResource)((IAdaptable)next).getAdapter(IResource.class);
            }
            if (selectedResource != null) {
                if (selectedResource.getType() == 1) {
                    selectedResource = selectedResource.getParent();
                }
                this.setContainerFullPath(selectedResource.getFullPath());
            }
        }
        this.setPageComplete(false);
    }

    protected IStatus validateLinkedResource() {
        IPath containerPath = this.getContainerFullPath();
        IPath newFolderPath = containerPath.append(this.getFolderName());
        IFolder newFolderHandle = this.createFolderHandle(newFolderPath);
        IStatus status = this.linkedResourceGroup.validateLinkLocation((IResource)newFolderHandle);
        if (status.getSeverity() == 4) {
            if (this.firstLinkCheck) {
                this.setMessage(status.getMessage());
            } else {
                this.setErrorMessage(status.getMessage());
            }
        } else if (status.getSeverity() == 2) {
            this.setMessage(status.getMessage(), 2);
            this.setErrorMessage(null);
        }
        return status;
    }

    protected boolean validatePage() {
        boolean valid = true;
        IPath containerFullPath = this.getContainerFullPath();
        if (containerFullPath == null || containerFullPath.segmentCount() == 0) {
            valid = false;
            this.setErrorMessage(Messages.wizardNewLinkedFolderCreationPage_noParentSelected);
        } else {
            String containerProjectName = containerFullPath.segment(0);
            IProject containerProject = ResourcesPlugin.getWorkspace().getRoot().getProject(containerProjectName);
            if (!containerProject.isOpen()) {
                valid = false;
                this.setErrorMessage(Messages.wizardNewLinkedFolderCreationPage_selectedParentProjectNotOpen);
            }
        }
        if (valid) {
            String folderName = this.getFolderName();
            IStatus result = ResourcesPlugin.getWorkspace().validateName(folderName, 2);
            if (!result.isOK()) {
                valid = false;
                if (!this.firstLinkCheck) {
                    this.setErrorMessage(result.getMessage());
                }
            }
        }
        IStatus linkedResourceStatus = null;
        if (valid && (linkedResourceStatus = this.validateLinkedResource()).getSeverity() == 4) {
            valid = false;
        }
        if (valid && (linkedResourceStatus == null || linkedResourceStatus.isOK())) {
            this.setMessage(null);
            this.setErrorMessage(null);
        }
        return valid;
    }

    protected IPath getContainerFullPath() {
        return this.initialContainerFullPath;
    }

    private void setContainerFullPath(IPath path) {
        this.initialContainerFullPath = path;
    }
}

