/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.validation.ui.util;

import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.common.ui.dialogs.DiagnosticDialog;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.edit.ui.EMFEditUIPlugin;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.sphinx.emf.validation.ui.util.ExtendedDiagnosticDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiagnosticUI {
    public static int showDiagnostic(List<Diagnostic> diagnostics) {
        return DiagnosticUI.showDiagnostic(diagnostics, null, null);
    }

    public static int showDiagnostic(List<Diagnostic> diagnostics, String title, String message) {
        Assert.isNotNull(diagnostics);
        return diagnostics.size() == 1 ? DiagnosticUI.showDiagnosticSingle(diagnostics.get(0), title, message) : DiagnosticUI.showDiagnosticMulti(diagnostics, title, message);
    }

    public static int showDiagnosticSingle(Diagnostic diagnostic) {
        return DiagnosticUI.showDiagnosticSingle(diagnostic, null, null);
    }

    public static int showDiagnosticSingle(Diagnostic diagnostic, String title, String message) {
        int severity = diagnostic.getSeverity();
        if (severity == 4 || severity == 2) {
            if (title == null) {
                title = EMFEditUIPlugin.INSTANCE.getString("_UI_ValidationProblems_title");
            }
            if (message == null) {
                message = EMFEditUIPlugin.INSTANCE.getString("_UI_ValidationProblems_message");
            }
        } else {
            if (title == null) {
                title = EMFEditUIPlugin.INSTANCE.getString("_UI_ValidationResults_title");
            }
            if (message == null) {
                message = EMFEditUIPlugin.INSTANCE.getString(severity == 0 ? "_UI_ValidationOK_message" : "_UI_ValidationResults_message");
            }
        }
        int result = 1;
        if (severity == 0) {
            MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)title, (String)message);
        } else {
            result = DiagnosticDialog.open((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)title, (String)message, (Diagnostic)diagnostic);
        }
        return result;
    }

    public static int showDiagnosticMulti(List<Diagnostic> diagnostics) {
        return DiagnosticUI.showDiagnosticMulti(diagnostics, null, null);
    }

    public static int showDiagnosticMulti(List<Diagnostic> diagnostics, String title, String message) {
        Assert.isNotNull(diagnostics);
        boolean isOk = true;
        boolean isInfo = false;
        for (Diagnostic diagnostic : diagnostics) {
            int severity = diagnostic.getSeverity();
            if (severity == 4 || severity == 2) {
                isOk = false;
                break;
            }
            if (severity != 1) continue;
            isInfo = true;
        }
        if (!isOk) {
            if (title == null) {
                title = EMFEditUIPlugin.INSTANCE.getString("_UI_ValidationProblems_title");
            }
            if (message == null) {
                message = EMFEditUIPlugin.INSTANCE.getString("_UI_ValidationProblems_message");
            }
        } else {
            if (title == null) {
                title = EMFEditUIPlugin.INSTANCE.getString("_UI_ValidationResults_title");
            }
            if (message == null) {
                message = EMFEditUIPlugin.INSTANCE.getString(!isInfo ? "_UI_ValidationOK_message" : "_UI_ValidationResults_message");
            }
        }
        int result = 1;
        if (isOk) {
            MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)title, (String)message);
        } else {
            result = ExtendedDiagnosticDialog.open(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), title, message, diagnostics);
        }
        return result;
    }
}

