/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.xtendxpand.ui.decorators;

import java.util.Collection;
import java.util.MissingResourceException;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;
import org.eclipse.sphinx.platform.util.PlatformLogUtil;
import org.eclipse.sphinx.xtendxpand.outlet.ExtendedOutlet;
import org.eclipse.sphinx.xtendxpand.preferences.OutletsPreference;
import org.eclipse.sphinx.xtendxpand.ui.internal.Activator;

public class BasicOutletFolderLabelDecorator
implements ILightweightLabelDecorator {
    private static final String OUTLET_OVERLAY_IMAGE_PATH = "full/ovr16/outlet_ovr.gif";

    protected OutletsPreference getOutletsPreference() {
        return OutletsPreference.INSTANCE;
    }

    public void decorate(Object element, IDecoration decoration) {
        if (element instanceof IFolder) {
            IFolder folder = (IFolder)element;
            IProject project = folder.getProject();
            Collection outlets = (Collection)this.getOutletsPreference().get(project);
            if (outlets != null) {
                for (ExtendedOutlet outlet : outlets) {
                    if (!folder.equals((Object)outlet.getContainer())) continue;
                    try {
                        ImageDescriptor imageDescriptor = Activator.getPlugin().getImageDescriptor(OUTLET_OVERLAY_IMAGE_PATH);
                        decoration.addOverlay(imageDescriptor, 0);
                    }
                    catch (MissingResourceException ex) {
                        PlatformLogUtil.logAsWarning((Plugin)Activator.getPlugin(), (Object)ex);
                    }
                    break;
                }
            }
        }
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }
}

