/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.table.ui.tools.internal.paperclips;

import org.eclipse.sirius.table.ui.tools.internal.paperclips.ColumnIterator;
import org.eclipse.sirius.table.ui.tools.internal.paperclips.PaperClips;
import org.eclipse.sirius.table.ui.tools.internal.paperclips.Print;
import org.eclipse.sirius.table.ui.tools.internal.paperclips.PrintIterator;
import org.eclipse.sirius.table.ui.tools.internal.paperclips.internal.util.Util;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;

public class ColumnPrint
implements Print {
    final Print target;
    final int columns;
    final int spacing;
    boolean compressed;

    public ColumnPrint(Print target, int columns, int spacing) {
        this(target, columns, spacing, true);
    }

    public ColumnPrint(Print target, int columns, int spacing, boolean compressed) {
        Util.notNull(target);
        if (spacing < 0) {
            PaperClips.error(5, "spacing must be >= 0");
        }
        if (columns < 2) {
            PaperClips.error(5, "columns must be >= 2");
        }
        this.target = target;
        this.spacing = spacing;
        this.columns = columns;
        this.compressed = compressed;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.columns;
        result = 31 * result + (this.compressed ? 1231 : 1237);
        result = 31 * result + this.spacing;
        result = 31 * result + (this.target == null ? 0 : this.target.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ColumnPrint other = (ColumnPrint)obj;
        if (this.columns != other.columns) {
            return false;
        }
        if (this.compressed != other.compressed) {
            return false;
        }
        if (this.spacing != other.spacing) {
            return false;
        }
        return !(this.target == null ? other.target != null : !this.target.equals(other.target));
    }

    public Print getTarget() {
        return this.target;
    }

    public int getColumnCount() {
        return this.columns;
    }

    public int getColumnSpacing() {
        return this.spacing;
    }

    public boolean isCompressed() {
        return this.compressed;
    }

    public void setCompressed(boolean compressed) {
        this.compressed = compressed;
    }

    @Override
    public PrintIterator iterator(Device device, GC gc) {
        return new ColumnIterator(this, device, gc);
    }
}

