/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.intermediate;

import com.google.common.collect.Streams;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.elk.alg.layered.graph.LEdge;
import org.eclipse.elk.alg.layered.graph.LGraph;
import org.eclipse.elk.alg.layered.options.LayeredOptions;
import org.eclipse.elk.core.alg.ILayoutProcessor;
import org.eclipse.elk.core.util.IElkProgressMonitor;

public class PartitionPreprocessor
implements ILayoutProcessor<LGraph> {
    private static final int PARTITION_CONSTRAINT_EDGE_PRIORITY = 1000;

    public void process(LGraph lGraph, IElkProgressMonitor monitor) {
        monitor.begin("Partition preprocessing", 1.0f);
        List edgesToBeReversed = lGraph.getLayerlessNodes().stream().filter(lNode -> lNode.hasProperty(LayeredOptions.PARTITIONING_PARTITION)).flatMap(lNode -> Streams.stream(lNode.getOutgoingEdges())).filter(lEdge -> this.mustBeReversed((LEdge)((Object)lEdge))).collect(Collectors.toList());
        edgesToBeReversed.stream().forEach(lEdge -> this.reverse((LEdge)((Object)lEdge), lGraph));
        monitor.done();
    }

    private boolean mustBeReversed(LEdge lEdge) {
        assert (lEdge.getSource().getNode().hasProperty(LayeredOptions.PARTITIONING_PARTITION));
        if (lEdge.getTarget().getNode().hasProperty(LayeredOptions.PARTITIONING_PARTITION)) {
            Integer targetPartition;
            Integer sourcePartition = (Integer)lEdge.getSource().getNode().getProperty(LayeredOptions.PARTITIONING_PARTITION);
            return sourcePartition.compareTo(targetPartition = (Integer)lEdge.getTarget().getNode().getProperty(LayeredOptions.PARTITIONING_PARTITION)) > 0;
        }
        return false;
    }

    private void reverse(LEdge lEdge, LGraph lGraph) {
        lEdge.reverse(lGraph, true);
        int priority = 1000;
        if (lEdge.hasProperty(LayeredOptions.PRIORITY_DIRECTION)) {
            priority += ((Integer)lEdge.getProperty(LayeredOptions.PRIORITY_DIRECTION)).intValue();
        }
        lEdge.setProperty(LayeredOptions.PRIORITY_DIRECTION, priority);
    }
}

