/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.edit.internal.validators;

import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.Request;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.sirius.diagram.DNode;
import org.eclipse.sirius.diagram.business.api.query.DNodeQuery;
import org.eclipse.sirius.diagram.ui.business.internal.query.RequestQuery;

public class ResizeValidator {
    private ChangeBoundsRequest changeBoundsRequest;

    public ResizeValidator(ChangeBoundsRequest changeBoundsRequest) {
        this.changeBoundsRequest = changeBoundsRequest;
    }

    public boolean validate() {
        boolean valid = true;
        Set<DNode> dNodes = this.getDNodes();
        RequestQuery requestQuery = new RequestQuery((Request)this.changeBoundsRequest);
        boolean verticalResize = requestQuery.isResizeFromBottom() || requestQuery.isResizeFromTop();
        boolean horizontalResize = requestQuery.isResizeFromLeft() || requestQuery.isResizeFromRight();
        for (DNode dNode : dNodes) {
            DNodeQuery dNodeQuery = new DNodeQuery(dNode);
            if (verticalResize && !dNodeQuery.allowsVerticalResize()) {
                valid = false;
            }
            if (horizontalResize && !dNodeQuery.allowsHorizontalResize()) {
                valid = false;
            }
            if (!valid) break;
        }
        return valid;
    }

    private Set<DNode> getDNodes() {
        LinkedHashSet<DNode> dNodes = new LinkedHashSet<DNode>();
        for (Object next : this.changeBoundsRequest.getEditParts()) {
            IGraphicalEditPart graphicalEditPart;
            EObject semanticElement;
            if (!(next instanceof IGraphicalEditPart) || !((semanticElement = (graphicalEditPart = (IGraphicalEditPart)next).resolveSemanticElement()) instanceof DNode)) continue;
            DNode dNode = (DNode)semanticElement;
            dNodes.add(dNode);
        }
        return dNodes;
    }
}

