/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.internal.refresh.listeners;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.NotificationFilter;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.ResourceSetChangeEvent;
import org.eclipse.emf.transaction.ResourceSetListener;
import org.eclipse.emf.transaction.ResourceSetListenerImpl;
import org.eclipse.emf.transaction.RollbackException;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.notation.FontStyle;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.business.api.metamodel.helper.FontFormatHelper;
import org.eclipse.sirius.diagram.BeginLabelStyle;
import org.eclipse.sirius.diagram.CenterLabelStyle;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.EdgeStyle;
import org.eclipse.sirius.diagram.EndLabelStyle;
import org.eclipse.sirius.diagram.ui.internal.refresh.SynchronizeDDiagramElementStylePropertiesCommand;
import org.eclipse.sirius.diagram.ui.internal.refresh.diagram.ViewPropertiesSynchronizer;
import org.eclipse.sirius.viewpoint.BasicLabelStyle;
import org.eclipse.sirius.viewpoint.Customizable;
import org.eclipse.sirius.viewpoint.FontFormat;
import org.eclipse.sirius.viewpoint.RGBValues;
import org.eclipse.sirius.viewpoint.Style;
import org.eclipse.sirius.viewpoint.ViewpointPackage;
import org.eclipse.sirius.viewpoint.description.style.BasicLabelStyleDescription;

public class FontFormatUpdater
extends ResourceSetListenerImpl {
    private static final NotificationFilter FEATURES_TO_REFACTOR_FILTER = NotificationFilter.NOT_TOUCH.and(NotificationFilter.createFeatureFilter((EStructuralFeature)NotationPackage.eINSTANCE.getFontStyle_Bold()).or(NotificationFilter.createFeatureFilter((EStructuralFeature)NotationPackage.eINSTANCE.getFontStyle_Italic())).or(NotificationFilter.createFeatureFilter((EStructuralFeature)NotationPackage.eINSTANCE.getFontStyle_Underline())).or(NotificationFilter.createFeatureFilter((EStructuralFeature)NotationPackage.eINSTANCE.getFontStyle_StrikeThrough()))).or(NotificationFilter.createFeatureFilter((EStructuralFeature)NotationPackage.eINSTANCE.getFontStyle_Bold()).and(NotificationFilter.createFeatureFilter((EStructuralFeature)NotationPackage.eINSTANCE.getFontStyle_Italic())).and(NotificationFilter.createFeatureFilter((EStructuralFeature)NotationPackage.eINSTANCE.getFontStyle_Underline())).and(NotificationFilter.createFeatureFilter((EStructuralFeature)NotationPackage.eINSTANCE.getFontStyle_StrikeThrough()))).or(NotificationFilter.createFeatureFilter((EStructuralFeature)NotationPackage.eINSTANCE.getFontStyle_FontHeight())).or(NotificationFilter.createFeatureFilter((EStructuralFeature)NotationPackage.eINSTANCE.getFontStyle_FontColor()));

    public FontFormatUpdater(TransactionalEditingDomain domain) {
        super(FEATURES_TO_REFACTOR_FILTER);
        domain.addResourceSetListener((ResourceSetListener)this);
    }

    public boolean isPrecommitOnly() {
        return true;
    }

    public boolean isAggregatePrecommitListener() {
        return true;
    }

    private Map<FontStyle, Set<EStructuralFeature>> getFontStyleFeatureChanges(ResourceSetChangeEvent event) {
        HashMap<FontStyle, Set<EStructuralFeature>> featureChanges = new HashMap<FontStyle, Set<EStructuralFeature>>();
        for (Notification notification : event.getNotifications()) {
            Object object = notification.getNotifier();
            if (!(object instanceof FontStyle)) continue;
            FontStyle fontStyle = (FontStyle)object;
            Object object2 = notification.getFeature();
            if (!(object2 instanceof EStructuralFeature)) continue;
            EStructuralFeature feature = (EStructuralFeature)object2;
            featureChanges.computeIfAbsent(fontStyle, newFontStyle -> new HashSet()).add(feature);
        }
        return featureChanges;
    }

    private void updateEdgeLabelStyle(CompoundCommand cc, Set<String> featureNames, FontStyle gmfStyle, BasicLabelStyle labelStyle, BasicLabelStyleDescription description) {
        String labelFormat = ViewpointPackage.Literals.BASIC_LABEL_STYLE__LABEL_FORMAT.getName();
        String labelSize = ViewpointPackage.Literals.BASIC_LABEL_STYLE__LABEL_SIZE.getName();
        if (featureNames.contains(labelFormat)) {
            if (!this.isSameLabelFormat(gmfStyle, (EList<FontFormat>)description.getLabelFormat())) {
                cc.append((Command)new AddCustomFeatureCommand(this.getTarget(), labelStyle, labelFormat));
            } else {
                cc.append((Command)new RemoveCustomFeatureCommand(this.getTarget(), labelStyle, labelFormat));
            }
        }
        if (featureNames.contains(labelSize)) {
            if (gmfStyle.getFontHeight() != description.getLabelSize()) {
                cc.append((Command)new AddCustomFeatureCommand(this.getTarget(), labelStyle, labelSize));
            } else {
                cc.append((Command)new RemoveCustomFeatureCommand(this.getTarget(), labelStyle, labelSize));
            }
        }
    }

    private void updateEdgeLabelStyles(CompoundCommand cc, Set<String> featureNames, FontStyle gmfStyle, EdgeStyle siriusStyle) {
        BeginLabelStyle beginLabelStyle = siriusStyle.getBeginLabelStyle();
        CenterLabelStyle centerLabelStyle = siriusStyle.getCenterLabelStyle();
        EndLabelStyle endLabelStyle = siriusStyle.getEndLabelStyle();
        if (beginLabelStyle != null) {
            this.updateEdgeLabelStyle(cc, featureNames, gmfStyle, (BasicLabelStyle)beginLabelStyle, beginLabelStyle.getDescription());
        }
        if (centerLabelStyle != null) {
            this.updateEdgeLabelStyle(cc, featureNames, gmfStyle, (BasicLabelStyle)centerLabelStyle, centerLabelStyle.getDescription());
        }
        if (endLabelStyle != null) {
            this.updateEdgeLabelStyle(cc, featureNames, gmfStyle, (BasicLabelStyle)endLabelStyle, endLabelStyle.getDescription());
        }
    }

    private void updateLabelStyle(CompoundCommand cc, View view, Set<EStructuralFeature> changedFeatures, FontStyle gmfStyle, Style siriusStyle) {
        Set<String> featureNames = this.getFeatureNames(changedFeatures);
        if (siriusStyle instanceof EdgeStyle) {
            EdgeStyle edgeStyle = (EdgeStyle)siriusStyle;
            this.updateEdgeLabelStyles(cc, featureNames, gmfStyle, edgeStyle);
        } else {
            featureNames.addAll((Collection<String>)siriusStyle.getCustomFeatures());
            Command addCustomFeaturesCmd = SetCommand.create((EditingDomain)this.getTarget(), (Object)siriusStyle, (Object)ViewpointPackage.Literals.CUSTOMIZABLE__CUSTOM_FEATURES, featureNames);
            cc.append(addCustomFeaturesCmd);
        }
        cc.append((Command)new SynchronizeDDiagramElementStylePropertiesCommand(this.getTarget(), view));
    }

    public Command transactionAboutToCommit(ResourceSetChangeEvent event) throws RollbackException {
        CompoundCommand cc = new CompoundCommand();
        Map<FontStyle, Set<EStructuralFeature>> fontStyleFeatureChanges = this.getFontStyleFeatureChanges(event);
        for (Map.Entry<FontStyle, Set<EStructuralFeature>> entry : fontStyleFeatureChanges.entrySet()) {
            Style style;
            FontStyle fontStyle = entry.getKey();
            Set<EStructuralFeature> features = entry.getValue();
            View view = (View)fontStyle.eContainer();
            EObject eObject = view.getElement();
            if (!(eObject instanceof DDiagramElement)) continue;
            DDiagramElement dDiagramElement = (DDiagramElement)eObject;
            if (features.isEmpty() || !this.isViewFontStylePropertiesDifferentOfGMFOne((Customizable)(style = dDiagramElement.getStyle()), fontStyle, features)) continue;
            this.updateLabelStyle(cc, view, features, fontStyle, style);
        }
        if (cc.isEmpty()) {
            return null;
        }
        return cc;
    }

    private boolean isSameLabelFormat(FontStyle gmfStyle, EList<FontFormat> siriusStyle) {
        boolean sameStrike;
        boolean sameBold = gmfStyle.isBold() == siriusStyle.contains((Object)FontFormat.BOLD_LITERAL);
        boolean sameItalic = gmfStyle.isItalic() == siriusStyle.contains((Object)FontFormat.ITALIC_LITERAL);
        boolean sameUnderline = gmfStyle.isUnderline() == siriusStyle.contains((Object)FontFormat.UNDERLINE_LITERAL);
        boolean bl = sameStrike = gmfStyle.isStrikeThrough() == siriusStyle.contains((Object)FontFormat.STRIKE_THROUGH_LITERAL);
        return sameBold && sameItalic && sameUnderline && sameStrike;
    }

    private boolean isViewFontStylePropertiesDifferentOfGMFOne(Customizable viewpointStyle, FontStyle gmfFontStyle, Set<EStructuralFeature> gmfStyleFeatures) {
        boolean isViewFontStylePropertiesDifferentOfGMFOne;
        block4: {
            block3: {
                isViewFontStylePropertiesDifferentOfGMFOne = false;
                if (!(viewpointStyle instanceof EdgeStyle)) break block3;
                EdgeStyle edgeStyle = (EdgeStyle)viewpointStyle;
                if (edgeStyle.getBeginLabelStyle() != null) {
                    isViewFontStylePropertiesDifferentOfGMFOne = this.isViewFontStylePropertiesDifferentOfGMFOne((Customizable)edgeStyle.getBeginLabelStyle(), gmfFontStyle, gmfStyleFeatures);
                }
                if (!isViewFontStylePropertiesDifferentOfGMFOne && edgeStyle.getCenterLabelStyle() != null) {
                    isViewFontStylePropertiesDifferentOfGMFOne = this.isViewFontStylePropertiesDifferentOfGMFOne((Customizable)edgeStyle.getCenterLabelStyle(), gmfFontStyle, gmfStyleFeatures);
                }
                if (isViewFontStylePropertiesDifferentOfGMFOne || edgeStyle.getEndLabelStyle() == null) break block4;
                isViewFontStylePropertiesDifferentOfGMFOne = this.isViewFontStylePropertiesDifferentOfGMFOne((Customizable)edgeStyle.getEndLabelStyle(), gmfFontStyle, gmfStyleFeatures);
                break block4;
            }
            for (EStructuralFeature gmfStyleFeature : gmfStyleFeatures) {
                EStructuralFeature viewpointStyleFeature = ViewPropertiesSynchronizer.GMF_TO_DDIAGRAMELEMENT_STYLE_FEATURES_MAPPING.get(gmfStyleFeature);
                if (!(viewpointStyleFeature instanceof EAttribute) || !viewpointStyle.eClass().getEAllStructuralFeatures().contains((Object)viewpointStyleFeature)) continue;
                Object viewpointStyleProperty = viewpointStyle.eGet(viewpointStyleFeature);
                Object gmfStyleProperty = this.convertToSiriusPropertyValue((org.eclipse.gmf.runtime.notation.Style)gmfFontStyle, gmfStyleFeature);
                if (viewpointStyleProperty == null || viewpointStyleProperty.equals(gmfStyleProperty)) continue;
                isViewFontStylePropertiesDifferentOfGMFOne = true;
                break;
            }
        }
        return isViewFontStylePropertiesDifferentOfGMFOne;
    }

    private Object convertToSiriusPropertyValue(org.eclipse.gmf.runtime.notation.Style gmfStyle, EStructuralFeature gmfStyleAttribute) {
        RGBValues gmfStylePropertyValue = gmfStyle.eGet(gmfStyleAttribute);
        if (gmfStyleAttribute == NotationPackage.Literals.FONT_STYLE__BOLD || gmfStyleAttribute == NotationPackage.Literals.FONT_STYLE__ITALIC || gmfStyleAttribute == NotationPackage.Literals.FONT_STYLE__UNDERLINE || gmfStyleAttribute == NotationPackage.Literals.FONT_STYLE__STRIKE_THROUGH) {
            FontStyle gmfFontStyle = (FontStyle)gmfStyle;
            gmfStylePropertyValue = new ArrayList();
            if (gmfFontStyle.isBold()) {
                FontFormatHelper.setFontFormat((List)((List)gmfStylePropertyValue), (FontFormat)FontFormat.BOLD_LITERAL);
            }
            if (gmfFontStyle.isItalic()) {
                FontFormatHelper.setFontFormat((List)((List)gmfStylePropertyValue), (FontFormat)FontFormat.ITALIC_LITERAL);
            }
            if (gmfFontStyle.isUnderline()) {
                FontFormatHelper.setFontFormat((List)((List)gmfStylePropertyValue), (FontFormat)FontFormat.UNDERLINE_LITERAL);
            }
            if (gmfFontStyle.isStrikeThrough()) {
                FontFormatHelper.setFontFormat((List)((List)gmfStylePropertyValue), (FontFormat)FontFormat.STRIKE_THROUGH_LITERAL);
            }
            if (!(gmfFontStyle.isBold() || gmfFontStyle.isItalic() || gmfFontStyle.isUnderline() || gmfFontStyle.isStrikeThrough())) {
                ((List)gmfStylePropertyValue).clear();
            }
        } else if (gmfStyleAttribute == NotationPackage.Literals.FONT_STYLE__FONT_COLOR) {
            FontStyle gmfFontStyle = (FontStyle)gmfStyle;
            gmfStylePropertyValue = RGBValues.integerToRGBValues((int)gmfFontStyle.getFontColor());
        }
        return gmfStylePropertyValue;
    }

    private Set<String> getFeatureNames(Set<EStructuralFeature> features) {
        LinkedHashSet<String> featureNames = new LinkedHashSet<String>();
        for (EStructuralFeature feature : features) {
            EStructuralFeature eStructuralFeature;
            String featureName = feature.getName();
            if (this.isFeatureOfNotationPackage(feature) && (eStructuralFeature = ViewPropertiesSynchronizer.GMF_TO_DDIAGRAMELEMENT_STYLE_FEATURES_MAPPING.get(feature)) != null) {
                featureName = eStructuralFeature.getName();
            }
            featureNames.add(featureName);
        }
        return featureNames;
    }

    private boolean isFeatureOfNotationPackage(EStructuralFeature feature) {
        boolean isFeatureOfNotationPackage = false;
        isFeatureOfNotationPackage = feature.getEContainingClass().getEPackage() == NotationPackage.eINSTANCE;
        return isFeatureOfNotationPackage;
    }

    public void dispose() {
        if (this.getTarget() != null) {
            this.getTarget().removeResourceSetListener((ResourceSetListener)this);
        }
    }

    private static class AddCustomFeatureCommand
    extends RecordingCommand {
        private BasicLabelStyle style;
        private String customFeature;

        public AddCustomFeatureCommand(TransactionalEditingDomain domain, BasicLabelStyle style, String customFeature) {
            super(domain);
            this.style = style;
            this.customFeature = customFeature;
        }

        protected void doExecute() {
            this.style.getCustomFeatures().add((Object)this.customFeature);
        }
    }

    private static class RemoveCustomFeatureCommand
    extends RecordingCommand {
        private BasicLabelStyle style;
        private String customFeature;

        public RemoveCustomFeatureCommand(TransactionalEditingDomain domain, BasicLabelStyle style, String customFeature) {
            super(domain);
            this.style = style;
            this.customFeature = customFeature;
        }

        protected void doExecute() {
            this.style.getCustomFeatures().remove((Object)this.customFeature);
        }
    }
}

