/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.views.providers.outline;

import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.DecorationOverlayIcon;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DDiagramElementContainer;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.diagram.business.api.query.DDiagramElementQuery;
import org.eclipse.sirius.diagram.ui.business.api.provider.AbstractDDiagramElementLabelItemProvider;
import org.eclipse.sirius.diagram.ui.provider.DiagramUIPlugin;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;

public class OutlineLabelProvider
extends LabelProvider
implements IFontProvider {
    private AdapterFactory factory = DiagramUIPlugin.getPlugin().getItemProvidersAdapterFactory();

    public Image getImage(Object element) {
        Image result = null;
        if (element instanceof DSemanticDecorator) {
            result = this.getImage((DSemanticDecorator)element);
        } else if (element instanceof AbstractDDiagramElementLabelItemProvider) {
            result = this.getImage((AbstractDDiagramElementLabelItemProvider)((Object)element));
        }
        return result;
    }

    private Image getImage(AbstractDDiagramElementLabelItemProvider element) {
        ImageDescriptor descriptor = ExtendedImageRegistry.getInstance().getImageDescriptor(element.getImage(element.getTarget()));
        if (descriptor == null) {
            descriptor = ImageDescriptor.getMissingImageDescriptor();
        }
        Image result = DiagramUIPlugin.getPlugin().getImage(descriptor);
        Option<DDiagramElement> optionTarget = element.getDiagramElementTarget();
        if (optionTarget.some() && new DDiagramElementQuery((DDiagramElement)optionTarget.get()).isLabelHidden()) {
            result = this.getDecoratedImage(result, "full/decorator/hidden", 0);
        }
        return result;
    }

    private Image getDecoratedImage(Image baseImage, String decoratorPath, int decoratorPosition) {
        ImageDescriptor decoratorDescriptor = ExtendedImageRegistry.getInstance().getImageDescriptor(DiagramUIPlugin.INSTANCE.getImage(decoratorPath));
        DecorationOverlayIcon finalDescriptor = new DecorationOverlayIcon(baseImage, decoratorDescriptor, decoratorPosition);
        return DiagramUIPlugin.getPlugin().getImage((ImageDescriptor)finalDescriptor);
    }

    private Image getImage(DSemanticDecorator element) {
        IItemLabelProvider labelProvider;
        Image result = null;
        EObject target = element.getTarget();
        if (target != null && (labelProvider = (IItemLabelProvider)this.factory.adapt((Notifier)target, IItemLabelProvider.class)) != null) {
            ImageDescriptor descriptor = ExtendedImageRegistry.getInstance().getImageDescriptor(labelProvider.getImage((Object)target));
            if (descriptor == null) {
                descriptor = ImageDescriptor.getMissingImageDescriptor();
            }
            result = DiagramUIPlugin.getPlugin().getImage(descriptor);
            if (element instanceof DEdge) {
                result = this.getDecoratedImage(result, "full/decorator/DEdge", 2);
                result = this.computeFoldDecorator(result, (DEdge)element);
            }
            if (element instanceof DDiagramElement) {
                DDiagramElementQuery query = new DDiagramElementQuery((DDiagramElement)element);
                if (query.isHidden()) {
                    result = this.getDecoratedImage(result, "full/decorator/hidden", 0);
                }
                if (element instanceof DDiagramElementContainer && query.isLabelHidden()) {
                    result = this.getDecoratedImage(result, "full/decorator/hiddenLabel", 3);
                }
            }
        }
        return result;
    }

    private Image computeFoldDecorator(Image baseImage, DEdge edge) {
        if (new DDiagramElementQuery((DDiagramElement)edge).isFolded()) {
            return this.getDecoratedImage(baseImage, "full/decorator/fold", 1);
        }
        return baseImage;
    }

    public String getText(Object element) {
        String result = null;
        if (element instanceof DSemanticDecorator) {
            IItemLabelProvider labelProvider;
            EObject target = ((DSemanticDecorator)element).getTarget();
            if (target != null && (labelProvider = (IItemLabelProvider)this.factory.adapt((Notifier)target, IItemLabelProvider.class)) != null) {
                result = labelProvider.getText((Object)target);
            }
        } else if (element instanceof AbstractDDiagramElementLabelItemProvider) {
            result = ((AbstractDDiagramElementLabelItemProvider)((Object)element)).getText(((AbstractDDiagramElementLabelItemProvider)((Object)element)).getTarget());
        }
        return result;
    }

    public Font getFont(Object element) {
        Option<DDiagramElement> optionTarget;
        Font result = JFaceResources.getDefaultFont();
        if (element instanceof DDiagramElement) {
            DDiagramElement vpe = (DDiagramElement)element;
            if (!vpe.isVisible() || vpe instanceof DDiagramElementContainer && new DDiagramElementQuery(vpe).isLabelHidden()) {
                result = JFaceResources.getFontRegistry().getItalic("org.eclipse.jface.defaultfont");
            }
        } else if (element instanceof AbstractDDiagramElementLabelItemProvider && (optionTarget = ((AbstractDDiagramElementLabelItemProvider)((Object)element)).getDiagramElementTarget()).some() && new DDiagramElementQuery((DDiagramElement)optionTarget.get()).isLabelHidden()) {
            result = JFaceResources.getFontRegistry().getItalic("org.eclipse.jface.defaultfont");
        }
        return result;
    }
}

