/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.tests.support.api;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import junit.framework.TestCase;
import org.eclipse.core.runtime.ILogListener;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.sirius.tests.support.api.TestsUtil;
import org.junit.Assert;

public class PlatformProblemsListener {
    private final Map<String, List<IStatus>> errors = new LinkedHashMap<String, List<IStatus>>();
    private final Map<String, List<IStatus>> warnings = new LinkedHashMap<String, List<IStatus>>();
    private final Map<String, List<IStatus>> infos = new LinkedHashMap<String, List<IStatus>>();
    private final Collection<Predicate<IStatus>> errorExclusions = new ArrayList<Predicate<IStatus>>();
    private ILogListener logListener;
    private boolean errorCatchActive;
    private boolean warningCatchActive;
    private boolean infoCatchActive;
    private Thread.UncaughtExceptionHandler exceptionHandler;
    private final String testName;

    public PlatformProblemsListener(TestCase testCase) {
        this.testName = testCase.getClass().getName();
    }

    public void initLoggers() {
        this.logListener = (status, plugin) -> {
            switch (status.getSeverity()) {
                case 4: {
                    this.errorOccurs(status, plugin);
                    break;
                }
                case 2: {
                    this.warningOccurs(status, plugin);
                    break;
                }
                case 1: {
                    this.infoOccurs(status, plugin);
                }
            }
        };
        Platform.addLogListener((ILogListener)this.logListener);
        this.exceptionHandler = (t, e) -> {
            Status status = new Status(4, "Uncaught exception", "Uncaught exception", e);
            this.errorOccurs((IStatus)status, "Uncaught exception");
        };
        Thread.setDefaultUncaughtExceptionHandler(this.exceptionHandler);
    }

    public void disposeLoggers() {
        if (this.logListener != null) {
            Platform.removeLogListener((ILogListener)this.logListener);
        }
    }

    public synchronized boolean doesAnErrorOccurs() {
        return this.errorsCount() > 0;
    }

    public int errorsCount() {
        return this.getErrors().values().stream().mapToInt(List::size).sum();
    }

    public synchronized boolean doesAWarningOccurs() {
        return this.warningsCount() > 0;
    }

    public int warningsCount() {
        return this.getWarnings().values().stream().mapToInt(List::size).sum();
    }

    public synchronized boolean doesAnInfoOccurs() {
        return this.infosCount() > 0;
    }

    protected int infosCount() {
        return this.getInfos().values().stream().mapToInt(List::size).sum();
    }

    public synchronized void clearErrors() {
        this.getErrors().clear();
    }

    public synchronized void clearWarnings() {
        this.getWarnings().clear();
    }

    public synchronized void clearInfos() {
        this.getInfos().clear();
    }

    protected synchronized void errorOccurs(IStatus status, String sourcePlugin) {
        if (this.isErrorCatchActive()) {
            boolean ignoreMessage = false;
            if ("org.eclipse.core.runtime".equals(sourcePlugin) && status != null) {
                if ("Could not acquire INavigatorContentService: Project Explorer not found.".equals(status.getMessage())) {
                    ignoreMessage = true;
                } else if (status.getMessage() != null && status.getMessage().startsWith("Resource '/.org.eclipse.jdt.core.external.folders/.link") && status.getMessage().endsWith("' already exists.")) {
                    ignoreMessage = true;
                }
            }
            if ("org.eclipse.ui.views.properties.tabbed".equals(status.getPlugin()) && status.getMessage() != null && status.getMessage().startsWith("Contributor org.eclipse.ui.navigator.ProjectExplorer cannot be created., exception: org.eclipse.core.runtime.CoreException: Plug-in \"org.eclipse.ui.navigator.resources\" was unable to instantiate class \"org.eclipse.ui.internal.navigator.resources.workbench.TabbedPropertySheetTitleProvider\".")) {
                ignoreMessage = true;
            }
            boolean bl = ignoreMessage = ignoreMessage || this.errorExclusions.stream().anyMatch(p -> p.test(status));
            if (!ignoreMessage) {
                this.getErrors().putIfAbsent(sourcePlugin, new ArrayList());
                this.getErrors().get(sourcePlugin).add(status);
            }
        }
    }

    protected synchronized void warningOccurs(IStatus status, String sourcePlugin) {
        if (this.isWarningCatchActive()) {
            this.getWarnings().putIfAbsent(sourcePlugin, new ArrayList());
            this.getWarnings().get(sourcePlugin).add(status);
        }
    }

    protected synchronized void infoOccurs(IStatus status, String sourcePlugin) {
        if (this.isInfoCatchActive()) {
            this.getInfos().putIfAbsent(sourcePlugin, new ArrayList());
            this.getInfos().get(sourcePlugin).add(status);
        }
    }

    public synchronized void setErrorCatchActive(boolean errorCatchActive) {
        this.errorCatchActive = errorCatchActive;
    }

    public synchronized void setWarningCatchActive(boolean warningCatchActive) {
        this.warningCatchActive = warningCatchActive;
    }

    public synchronized void setInfoCatchActive(boolean infoCatchActive) {
        this.infoCatchActive = infoCatchActive;
    }

    public synchronized boolean isErrorCatchActive() {
        return this.errorCatchActive;
    }

    public synchronized boolean isWarningCatchActive() {
        return this.warningCatchActive;
    }

    public synchronized boolean isInfoCatchActive() {
        return this.infoCatchActive;
    }

    public void startToListenErrorLog(boolean activateInfoCatch, boolean activateWarningCatch, boolean activateErrorCatch) {
        this.setInfoCatchActive(activateInfoCatch);
        if (activateInfoCatch) {
            this.getInfos().clear();
        }
        this.setWarningCatchActive(activateWarningCatch);
        if (activateWarningCatch) {
            this.getWarnings().clear();
        }
        this.setErrorCatchActive(activateErrorCatch);
        if (activateErrorCatch) {
            this.getErrors().clear();
        }
    }

    public void checkLogs() {
        if (!TestsUtil.shouldSkipUnreliableTests()) {
            if (this.doesAnErrorOccurs()) {
                Assert.fail((String)this.getErrorLoggersMessage());
            }
            if (this.doesAWarningOccurs()) {
                Assert.fail((String)this.getWarningLoggersMessage());
            }
        }
    }

    private synchronized String getLoggersMessage(String type, Map<String, List<IStatus>> messages) {
        StringBuilder log1 = new StringBuilder();
        String br = "\n";
        log1.append(type + "(s) raised during test : " + this.testName).append(br);
        for (Map.Entry<String, List<IStatus>> entry : messages.entrySet()) {
            String reporter = entry.getKey();
            log1.append(". Log Plugin : " + reporter).append(br);
            for (IStatus status : entry.getValue()) {
                log1.append("  . " + this.getSeverity(status) + " from plugin:" + status.getPlugin() + ", message: " + status.getMessage() + ", info: " + String.valueOf(status.getException())).append(br);
                this.appendStackTrace(log1, br, status);
            }
            log1.append(br);
        }
        return log1.toString();
    }

    public synchronized String getErrorLoggersMessage() {
        return this.getLoggersMessage("Error", this.getErrors());
    }

    public synchronized String getWarningLoggersMessage() {
        return this.getLoggersMessage("Warning", this.getWarnings());
    }

    public synchronized String getInfoLoggersMessage() {
        return this.getLoggersMessage("Info", this.getInfos());
    }

    protected void appendStackTrace(StringBuilder stringBuilder, String endLineDelimiter, IStatus status) {
        PrintWriter pw = null;
        String stacktrace = null;
        if (status.getException() != null) {
            try {
                StringWriter sw = new StringWriter();
                pw = new PrintWriter(sw);
                status.getException().printStackTrace(pw);
                stacktrace = sw.toString();
            }
            catch (Throwable throwable) {
                if (pw != null) {
                    pw.close();
                }
                if (stacktrace == null) {
                    stacktrace = status.getException().toString();
                }
                stringBuilder.append("   . Stack trace: " + stacktrace).append(endLineDelimiter);
                throw throwable;
            }
            if (pw != null) {
                pw.close();
            }
            if (stacktrace == null) {
                stacktrace = status.getException().toString();
            }
            stringBuilder.append("   . Stack trace: " + stacktrace).append(endLineDelimiter);
        }
    }

    protected String getSeverity(IStatus status) {
        return switch (status.getSeverity()) {
            case 0 -> "Ok";
            case 1 -> "Info";
            case 2 -> "Warning";
            case 8 -> "Cancel";
            case 4 -> "Error";
            default -> "Unspecified";
        };
    }

    public Map<String, List<IStatus>> getErrors() {
        return this.errors;
    }

    public Map<String, List<IStatus>> getWarnings() {
        return this.warnings;
    }

    public Map<String, List<IStatus>> getInfos() {
        return this.infos;
    }

    public void addErrorExclusion(Predicate<IStatus> exclusion) {
        this.errorExclusions.add(exclusion);
    }
}

