/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.internal.migration.resource.session.commands;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.command.IdentityCommand;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;

public class MigrationProcessRestoreDescriptionLinksCommand
extends IdentityCommand {
    private Set<Resource> descriptionFiles;
    private URI proxyURI;
    private Map.Entry<EObject, Collection<EStructuralFeature.Setting>> entry;

    public MigrationProcessRestoreDescriptionLinksCommand(URI proxyURI, Map.Entry<EObject, Collection<EStructuralFeature.Setting>> entry, Set<Resource> descriptionFiles) {
        this.proxyURI = proxyURI;
        this.entry = entry;
        this.descriptionFiles = descriptionFiles;
    }

    public void execute() {
        Resource description = this.findDescriptionResource(this.proxyURI);
        if (description != null) {
            for (EStructuralFeature.Setting setting : this.entry.getValue()) {
                EStructuralFeature feature = setting.getEObject().eClass().getEStructuralFeature(setting.getEStructuralFeature().getName());
                EObject target = description.getEObject(this.proxyURI.fragment());
                if (feature.isMany()) {
                    ((Collection)setting.getEObject().eGet(feature)).add(target);
                    continue;
                }
                if (!feature.isChangeable()) continue;
                setting.getEObject().eSet(feature, (Object)target);
            }
        }
        this.descriptionFiles = null;
        this.proxyURI = null;
        this.entry = null;
    }

    private Resource findDescriptionResource(URI uri) {
        String expectedDescription = uri.lastSegment();
        if (expectedDescription.endsWith(".air")) {
            expectedDescription = expectedDescription.replace(".air", ".odesign");
        }
        for (Resource candidate : this.descriptionFiles) {
            URI candidateURI = candidate.getURI();
            if (!candidateURI.lastSegment().equals(expectedDescription) || candidate.getEObject(uri.fragment()) == null) continue;
            return candidate;
        }
        return null;
    }

    public boolean canUndo() {
        return false;
    }
}

