/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.business.api.query;

import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.runtime.diagram.core.util.ViewType;
import org.eclipse.gmf.runtime.draw2d.ui.figures.FigureUtilities;
import org.eclipse.gmf.runtime.notation.Connector;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.JumpLinkStatus;
import org.eclipse.gmf.runtime.notation.JumpLinkType;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.Shape;
import org.eclipse.gmf.runtime.notation.Style;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.LabelPosition;
import org.eclipse.sirius.diagram.NodeStyle;
import org.eclipse.sirius.diagram.business.api.query.ContainerMappingQuery;
import org.eclipse.sirius.diagram.description.ContainerMapping;
import org.eclipse.sirius.diagram.description.DiagramElementMapping;
import org.eclipse.sirius.diagram.ui.part.SiriusVisualIDRegistry;
import org.eclipse.sirius.diagram.ui.provider.DiagramUIPlugin;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.Options;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.sirius.viewpoint.DStylizable;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;

public class ViewQuery {
    public static final String SPECIFIC_STYLES = "specificStyles";
    public static final String VERTICAL_ALIGNMENT = "verticalAlignment";
    public static final String REPRESENTATION_LINK_NOTE = "representationlink";
    public static final Set<EAttribute> CUSTOMIZABLE_GMF_EXCLUSIVE_STYLE_ATTRIBUTES = new LinkedHashSet<EAttribute>();
    public static final Set<EAttribute> CUSTOMIZABLE_GMF_STYLE_ATTRIBUTES = new LinkedHashSet<EAttribute>();
    protected View view;

    static {
        for (EClassifier notationEClassifier : NotationPackage.eINSTANCE.getEClassifiers()) {
            EClass notationEClass;
            if (!(notationEClassifier instanceof EClass) || !NotationPackage.Literals.STYLE.isSuperTypeOf(notationEClass = (EClass)notationEClassifier)) continue;
            for (EAttribute eAttribute : notationEClass.getEAttributes()) {
                if (eAttribute == NotationPackage.Literals.DESCRIPTION_STYLE__DESCRIPTION) continue;
                if (!ViewQuery.isStylePropertyExistingInSiriusStyleModel(eAttribute)) {
                    CUSTOMIZABLE_GMF_EXCLUSIVE_STYLE_ATTRIBUTES.add(eAttribute);
                }
                CUSTOMIZABLE_GMF_STYLE_ATTRIBUTES.add(eAttribute);
            }
        }
    }

    public ViewQuery(View view) {
        this.view = view;
    }

    private static boolean isStylePropertyExistingInSiriusStyleModel(EAttribute eAttribute) {
        boolean isStylePropertyExistingInSiriusStyleModel = eAttribute == NotationPackage.Literals.FONT_STYLE__BOLD || eAttribute == NotationPackage.Literals.FONT_STYLE__ITALIC || eAttribute == NotationPackage.Literals.FONT_STYLE__UNDERLINE || eAttribute == NotationPackage.Literals.FONT_STYLE__STRIKE_THROUGH || eAttribute == NotationPackage.Literals.FONT_STYLE__FONT_COLOR || eAttribute == NotationPackage.Literals.FONT_STYLE__FONT_HEIGHT || eAttribute == NotationPackage.Literals.FILL_STYLE__FILL_COLOR || eAttribute == NotationPackage.Literals.ROUTING_STYLE__ROUTING || eAttribute == NotationPackage.Literals.LINE_STYLE__LINE_COLOR;
        return isStylePropertyExistingInSiriusStyleModel;
    }

    public boolean isCustomized() {
        boolean isCustomized = false;
        for (Object obj : this.view.getStyles()) {
            if (!(obj instanceof Style)) continue;
            Style style = (Style)obj;
            for (EAttribute eAttribute : style.eClass().getEAllAttributes()) {
                if (!CUSTOMIZABLE_GMF_EXCLUSIVE_STYLE_ATTRIBUTES.contains(eAttribute)) continue;
                Object currentValue = style.eGet((EStructuralFeature)eAttribute);
                Object defaultValue = this.getDefaultValue(eAttribute);
                if ((currentValue == null || currentValue.equals(defaultValue)) && (currentValue != null || defaultValue == null)) continue;
                isCustomized = true;
                break;
            }
            if (isCustomized) break;
        }
        if (!isCustomized && (this.view instanceof Shape || this.view instanceof Connector)) {
            for (EAttribute eAttribute : this.view.eClass().getEAllAttributes()) {
                if (!NotationPackage.Literals.STYLE.isSuperTypeOf(eAttribute.getEContainingClass()) || !CUSTOMIZABLE_GMF_STYLE_ATTRIBUTES.contains(eAttribute)) continue;
                Object currentValue = this.view.eGet((EStructuralFeature)eAttribute);
                Object defaultValue = this.getDefaultValue(eAttribute);
                if ((currentValue == null || currentValue.equals(defaultValue)) && (currentValue != null || defaultValue == null)) continue;
                isCustomized = true;
                break;
            }
        }
        return isCustomized;
    }

    public Object getDefaultValue(EAttribute eAttribute) {
        Object defaultValue = null;
        IPreferenceStore preferenceStore = (IPreferenceStore)DiagramUIPlugin.DIAGRAM_PREFERENCES_HINT.getPreferenceStore();
        if (eAttribute == NotationPackage.Literals.FONT_STYLE__BOLD) {
            FontData fontData = PreferenceConverter.getFontData((IPreferenceStore)preferenceStore, (String)"Appearance.defaultFont");
            defaultValue = (fontData.getStyle() & 1) != 0;
        } else if (eAttribute == NotationPackage.Literals.FONT_STYLE__ITALIC) {
            FontData fontData = PreferenceConverter.getFontData((IPreferenceStore)preferenceStore, (String)"Appearance.defaultFont");
            defaultValue = (fontData.getStyle() & 2) != 0;
        } else if (eAttribute == NotationPackage.Literals.FONT_STYLE__FONT_COLOR) {
            RGB fontRGB = PreferenceConverter.getColor((IPreferenceStore)preferenceStore, (String)"Appearance.fontColor");
            defaultValue = (int)FigureUtilities.RGBToInteger((RGB)fontRGB);
        } else if (eAttribute == NotationPackage.Literals.FONT_STYLE__FONT_NAME) {
            FontData fontData = PreferenceConverter.getFontData((IPreferenceStore)preferenceStore, (String)"Appearance.defaultFont");
            defaultValue = fontData.getName();
        } else if (eAttribute == NotationPackage.Literals.FONT_STYLE__FONT_NAME) {
            FontData fontData = PreferenceConverter.getFontData((IPreferenceStore)preferenceStore, (String)"Appearance.defaultFont");
            defaultValue = fontData.getName();
        } else if (eAttribute == NotationPackage.Literals.FONT_STYLE__FONT_HEIGHT) {
            FontData fontData = PreferenceConverter.getFontData((IPreferenceStore)preferenceStore, (String)"Appearance.defaultFont");
            defaultValue = fontData.getHeight();
        } else if (eAttribute == NotationPackage.Literals.LINE_STYLE__LINE_COLOR) {
            RGB lineRGB = PreferenceConverter.getColor((IPreferenceStore)preferenceStore, (String)"Appearance.lineColor");
            if (ViewType.NOTE.equals(this.view.getType())) {
                lineRGB = PreferenceConverter.getColor((IPreferenceStore)preferenceStore, (String)"Appearance.noteLineColor");
            }
            defaultValue = (int)FigureUtilities.RGBToInteger((RGB)lineRGB);
        } else if (eAttribute == NotationPackage.Literals.FILL_STYLE__FILL_COLOR) {
            RGB fillRGB = PreferenceConverter.getColor((IPreferenceStore)preferenceStore, (String)"Appearance.fillColor");
            if (ViewType.NOTE.equals(this.view.getType())) {
                fillRGB = PreferenceConverter.getColor((IPreferenceStore)preferenceStore, (String)"Appearance.noteFillColor");
            }
            defaultValue = (int)FigureUtilities.RGBToInteger((RGB)fillRGB);
        } else if (eAttribute == NotationPackage.Literals.FILL_STYLE__TRANSPARENCY) {
            defaultValue = eAttribute.getDefaultValue();
            if (ViewType.NOTE.equals(this.view.getType())) {
                defaultValue = 0;
            }
        } else if (eAttribute == NotationPackage.Literals.LINE_STYLE__LINE_WIDTH) {
            defaultValue = eAttribute.getDefaultValue();
            if (ViewType.NOTE.equals(this.view.getType())) {
                defaultValue = 1;
            }
        } else if (eAttribute == NotationPackage.Literals.ROUTING_STYLE__JUMP_LINK_STATUS) {
            IPreferencesService service = Platform.getPreferencesService();
            boolean isJumpLinkOverideEnabled = Platform.getPreferencesService().getBoolean("org.eclipse.sirius.diagram", "Sirius.Connectors.JumpLink.enableOverride", false, null);
            if (isJumpLinkOverideEnabled) {
                Option overrideJumpLinkStatus = Options.newNone();
                int jumpLinkStats = service.getInt("org.eclipse.sirius.diagram", "Sirius.Connectors.JumpLink.status", 0, null);
                overrideJumpLinkStatus = Options.newSome((Object)JumpLinkStatus.get((int)jumpLinkStats));
                if (overrideJumpLinkStatus.some()) {
                    defaultValue = overrideJumpLinkStatus.get();
                }
            }
            if (defaultValue == null) {
                defaultValue = eAttribute.getDefaultValue();
            }
        } else if (eAttribute == NotationPackage.Literals.ROUTING_STYLE__JUMP_LINK_TYPE) {
            IPreferencesService service = Platform.getPreferencesService();
            boolean isJumpLinkOverideEnabled = Platform.getPreferencesService().getBoolean("org.eclipse.sirius.diagram", "Sirius.Connectors.JumpLink.enableOverride", false, null);
            if (isJumpLinkOverideEnabled) {
                Option overrideJumpLinkType = Options.newNone();
                int jumpLinkType = service.getInt("org.eclipse.sirius.diagram", "Sirius.Connectors.JumpLink.type", 0, null);
                overrideJumpLinkType = Options.newSome((Object)JumpLinkType.get((int)jumpLinkType));
                if (overrideJumpLinkType.some()) {
                    defaultValue = overrideJumpLinkType.get();
                }
            }
            if (defaultValue == null) {
                defaultValue = eAttribute.getDefaultValue();
            }
        } else if (eAttribute == NotationPackage.Literals.ROUTING_STYLE__JUMP_LINKS_REVERSE) {
            IPreferencesService service = Platform.getPreferencesService();
            boolean isJumpLinkOverideEnabled = Platform.getPreferencesService().getBoolean("org.eclipse.sirius.diagram", "Sirius.Connectors.JumpLink.enableOverride", false, null);
            if (isJumpLinkOverideEnabled) {
                defaultValue = service.getBoolean("org.eclipse.sirius.diagram", "Sirius.Connectors.JumpLink.reverse", false, null);
            }
            if (defaultValue == null) {
                defaultValue = eAttribute.getDefaultValue();
            }
        } else {
            defaultValue = eAttribute.getDefaultValue();
        }
        return defaultValue;
    }

    public boolean isForNameEditPart() {
        int type = SiriusVisualIDRegistry.getVisualID(this.view.getType());
        boolean result = type == 5002 || type == 5001 || type == 5003;
        result = result || type == 5010;
        result = result || type == 5006 || type == 5005;
        result = result || type == 5007 || type == 5004;
        result = result || type == 6001 || type == 6003;
        result = result || type == 6002;
        return result;
    }

    public boolean isForEdgeNameEditPart() {
        int type = SiriusVisualIDRegistry.getVisualID(this.view.getType());
        boolean result = type == 6001;
        result = result || type == 6003;
        result = result || type == 6002;
        return result;
    }

    public boolean isForNameEditPartOnBorder() {
        DStylizable dStylizable;
        boolean result = false;
        if (this.isForNameEditPart() && this.view.getElement() instanceof DStylizable && (dStylizable = (DStylizable)this.view.getElement()).getStyle() instanceof NodeStyle && LabelPosition.BORDER_LITERAL.equals((Object)((NodeStyle)dStylizable.getStyle()).getLabelPosition())) {
            result = true;
        }
        return result;
    }

    public boolean isBorderedNode() {
        int type = SiriusVisualIDRegistry.getVisualID(this.view.getType());
        boolean result = type == 3001 || type == 3012;
        return result;
    }

    public boolean isContainer() {
        int type = SiriusVisualIDRegistry.getVisualID(this.view.getType());
        boolean result = type == 3008 || type == 2002 || type == 3009 || type == 2003;
        return result;
    }

    public boolean isFreeFormContainer() {
        int type = SiriusVisualIDRegistry.getVisualID(this.view.getType());
        return type == 2002 || type == 3008;
    }

    public boolean isFreeFormCompartment() {
        int type = SiriusVisualIDRegistry.getVisualID(this.view.getType());
        return type == 7001 || type == 7002;
    }

    public boolean isRegionContainer() {
        ContainerMapping mapping;
        DDiagramElement element;
        DiagramElementMapping diagramElementMapping;
        EObject eObject = this.view.getElement();
        return eObject instanceof DDiagramElement && (diagramElementMapping = (element = (DDiagramElement)eObject).getDiagramElementMapping()) instanceof ContainerMapping && new ContainerMappingQuery(mapping = (ContainerMapping)diagramElementMapping).isRegionContainer();
    }

    public boolean isNode() {
        int type = SiriusVisualIDRegistry.getVisualID(this.view.getType());
        return type == 2001 || type == 3001 || type == 3007 || type == 3012;
    }

    public boolean isNodeLabel() {
        int type = SiriusVisualIDRegistry.getVisualID(this.view.getType());
        return type == 5002 || type == 5001 || type == 5003 || type == 5010;
    }

    public Optional<View> getFreeFormContainerCompartment() {
        if (this.isFreeFormContainer()) {
            EList children = this.view.getChildren();
            return children.stream().filter(child -> new ViewQuery((View)child).isFreeFormCompartment()).findAny();
        }
        return Optional.empty();
    }

    public Option<View> getAncestor(int ... visualID) {
        Option<View> result = Options.newNone();
        int type = SiriusVisualIDRegistry.getVisualID(this.view.getType());
        int i = 0;
        while (i < visualID.length) {
            if (type == visualID[i]) {
                result = Options.newSome((Object)this.view);
                break;
            }
            ++i;
        }
        if (!result.some() && this.view.eContainer() instanceof View) {
            result = new ViewQuery((View)this.view.eContainer()).getAncestor(visualID);
        }
        return result;
    }

    public Optional<DDiagram> getDDiagram() {
        return this.getDDiagram(this.view);
    }

    public boolean isInShowingMode() {
        Optional<DDiagram> dDiagram = this.getDDiagram(this.view);
        return dDiagram.isPresent() && dDiagram.get().isIsInShowingMode();
    }

    public boolean isRepresentationLink() {
        EAnnotation specificStyles = this.view.getEAnnotation(SPECIFIC_STYLES);
        return specificStyles != null && specificStyles.getDetails().containsKey((Object)REPRESENTATION_LINK_NOTE) && ViewType.NOTE.equals(this.view.getType());
    }

    public boolean isRepresentationLinkBroken() {
        EObject element = this.view.getElement();
        return !(element instanceof DRepresentationDescriptor) || element.eIsProxy() || element.eResource() == null;
    }

    private Optional<DDiagram> getDDiagram(View tempView) {
        Optional<DDiagram> result = Optional.empty();
        if (tempView instanceof Diagram && ((Diagram)tempView).getElement() instanceof DDiagram) {
            result = Optional.of((DDiagram)((Diagram)tempView).getElement());
        } else if (tempView.eContainer() instanceof View) {
            result = this.getDDiagram((View)tempView.eContainer());
        }
        return result;
    }
}

