/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.core.comments;

import java.util.Objects;
import org.eclipse.elk.core.comments.IMatcher;

public abstract class AbstractNormalizedMatcher<C, T>
implements IMatcher<C, T> {
    private double worstRawValue = 0.0;
    private double bestRawValue = 1.0;
    private NormalizationFunction normalizationFunction = NormalizationFunction.LINEAR;

    protected AbstractNormalizedMatcher<C, T> withBounds(double worstRawVal, double bestRawVal) {
        this.worstRawValue = worstRawVal;
        this.bestRawValue = bestRawVal;
        return this;
    }

    protected AbstractNormalizedMatcher<C, T> withNormalizationFunction(NormalizationFunction function) {
        Objects.requireNonNull(function, "Normalization function cannot be null.");
        this.normalizationFunction = function;
        return this;
    }

    public double getWorstRawValue() {
        return this.worstRawValue;
    }

    public double getBestRawValue() {
        return this.bestRawValue;
    }

    @Override
    public double normalized(C comment, T element) {
        double rawValue = this.raw(comment, element);
        switch (this.normalizationFunction) {
            case LINEAR: {
                return this.normalizeLinear(rawValue);
            }
            case BINARY: {
                return this.normalizeBinary(rawValue);
            }
        }
        assert (false);
        return 0.0;
    }

    protected final double normalizeLinear(double raw) {
        if (this.worstRawValue < this.bestRawValue) {
            if (raw <= this.worstRawValue) {
                return 0.0;
            }
            if (raw >= this.bestRawValue) {
                return 1.0;
            }
            return (raw - this.worstRawValue) / (this.bestRawValue - this.worstRawValue);
        }
        if (this.bestRawValue < this.worstRawValue) {
            if (raw <= this.bestRawValue) {
                return 1.0;
            }
            if (raw >= this.worstRawValue) {
                return 0.0;
            }
            return 1.0 - (raw - this.bestRawValue) / (this.worstRawValue - this.bestRawValue);
        }
        return raw == this.bestRawValue ? 1 : 0;
    }

    protected final double normalizeBinary(double raw) {
        if (this.worstRawValue < this.bestRawValue) {
            return !(raw <= this.worstRawValue) ? 1 : 0;
        }
        if (this.bestRawValue < this.worstRawValue) {
            return !(raw >= this.worstRawValue) ? 1 : 0;
        }
        return raw == this.bestRawValue ? 1 : 0;
    }

    public static enum NormalizationFunction {
        LINEAR,
        BINARY;

    }
}

