/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.business.internal.metamodel.helper;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.sirius.business.api.logger.RuntimeLoggerInterpreter;
import org.eclipse.sirius.business.api.logger.RuntimeLoggerManager;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.common.tools.DslCommonPlugin;
import org.eclipse.sirius.common.tools.api.interpreter.EvaluationException;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.common.tools.api.util.EqualityHelper;
import org.eclipse.sirius.common.tools.api.util.StringUtil;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.diagram.DSemanticDiagram;
import org.eclipse.sirius.diagram.DiagramFactory;
import org.eclipse.sirius.diagram.DragAndDropTarget;
import org.eclipse.sirius.diagram.EdgeStyle;
import org.eclipse.sirius.diagram.EdgeTarget;
import org.eclipse.sirius.diagram.business.api.query.EdgeMappingQuery;
import org.eclipse.sirius.diagram.business.api.query.IEdgeMappingQuery;
import org.eclipse.sirius.diagram.business.internal.metamodel.helper.DSemanticDiagramHelper;
import org.eclipse.sirius.diagram.business.internal.metamodel.helper.DiagramElementMappingHelper;
import org.eclipse.sirius.diagram.business.internal.metamodel.helper.MappingWithInterpreterHelper;
import org.eclipse.sirius.diagram.business.internal.metamodel.helper.StyleHelper;
import org.eclipse.sirius.diagram.description.AbstractNodeMapping;
import org.eclipse.sirius.diagram.description.ContainerMapping;
import org.eclipse.sirius.diagram.description.DescriptionPackage;
import org.eclipse.sirius.diagram.description.DiagramElementMapping;
import org.eclipse.sirius.diagram.description.EdgeMapping;
import org.eclipse.sirius.diagram.description.EdgeMappingImport;
import org.eclipse.sirius.diagram.description.IEdgeMapping;
import org.eclipse.sirius.diagram.description.NodeMapping;
import org.eclipse.sirius.diagram.description.style.EdgeStyleDescription;
import org.eclipse.sirius.diagram.model.business.internal.description.spec.EdgeMappingImportWrapper;
import org.eclipse.sirius.diagram.model.business.internal.helper.MappingExtHelper;
import org.eclipse.sirius.diagram.tools.api.Messages;
import org.eclipse.sirius.ecore.extender.business.api.accessor.ModelAccessor;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.Options;
import org.eclipse.sirius.tools.api.SiriusPlugin;
import org.eclipse.sirius.tools.api.interpreter.IInterpreterMessages;
import org.eclipse.sirius.tools.api.profiler.SiriusTasksKey;
import org.eclipse.sirius.tools.api.ui.resource.ISiriusMessages;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.sirius.viewpoint.Style;
import org.eclipse.sirius.viewpoint.description.style.BasicLabelStyleDescription;
import org.eclipse.sirius.viewpoint.description.style.StyleDescription;
import org.eclipse.sirius.viewpoint.description.style.StylePackage;

public final class EdgeMappingHelper {
    private IInterpreter interpreter;

    public EdgeMappingHelper(IInterpreter interpreter) {
        this.interpreter = interpreter;
    }

    public EObject getSemanticTarget(EdgeTarget edgeTarget) {
        if (edgeTarget instanceof DSemanticDecorator) {
            return ((DSemanticDecorator)edgeTarget).getTarget();
        }
        SiriusPlugin.getDefault().warning(MessageFormat.format(Messages.DiagramElementMappingHelper_edgeTargetMsg, String.valueOf(edgeTarget), ISiriusMessages.IS_NOT_A_DECORATE_SEMANTIC_ELEMENT), null);
        return null;
    }

    public EList<EObject> getEdgeTargetCandidates(EdgeMapping self, EObject semanticOrigin, DDiagram diagram) {
        UniqueEList result = new UniqueEList();
        if (self.getTargetFinderExpression() != null && !StringUtil.isEmpty((String)self.getTargetFinderExpression().trim())) {
            this.interpreter.setVariable("viewpoint", (Object)diagram);
            this.interpreter.setVariable("viewPoint", (Object)diagram);
            this.interpreter.setVariable("diagram", (Object)diagram);
            RuntimeLoggerInterpreter safeInterpreter = RuntimeLoggerManager.INSTANCE.decorate(this.interpreter);
            Collection candidates = safeInterpreter.evaluateCollection(semanticOrigin, (EObject)self, (EStructuralFeature)DescriptionPackage.eINSTANCE.getEdgeMapping_TargetFinderExpression());
            result = new UniqueEList(candidates);
            this.interpreter.unSetVariable("diagram");
            this.interpreter.unSetVariable("viewPoint");
            this.interpreter.unSetVariable("viewpoint");
        }
        return result;
    }

    public EList<EObject> getEdgeSourceCandidates(EdgeMapping self, EObject semanticOrigin, DDiagram diagram) {
        UniqueEList result = new UniqueEList();
        if (self.getSourceFinderExpression() != null && !StringUtil.isEmpty((String)self.getSourceFinderExpression().trim())) {
            this.interpreter.setVariable("viewpoint", (Object)diagram);
            this.interpreter.setVariable("viewPoint", (Object)diagram);
            this.interpreter.setVariable("diagram", (Object)diagram);
            Collection resultList = RuntimeLoggerManager.INSTANCE.decorate(this.interpreter).evaluateCollection(semanticOrigin, (EObject)self, (EStructuralFeature)DescriptionPackage.eINSTANCE.getEdgeMapping_SourceFinderExpression());
            result = new UniqueEList(resultList);
            this.interpreter.unSetVariable("diagram");
            this.interpreter.unSetVariable("viewPoint");
            this.interpreter.unSetVariable("viewpoint");
        }
        return result;
    }

    public DEdge createEdge(EdgeMapping edgeMapping, EdgeTarget source, EdgeTarget target, EObject container, EObject semanticTarget) {
        EObject semanticTargetToUseForExpression = semanticTarget;
        if (semanticTargetToUseForExpression == null) {
            semanticTargetToUseForExpression = this.getSemanticTarget(source);
        }
        DEdge newEdge = DiagramFactory.eINSTANCE.createDEdge();
        newEdge.setSourceNode(source);
        newEdge.setTargetNode(target);
        if (edgeMapping instanceof EdgeMappingImportWrapper) {
            newEdge.setActualMapping((IEdgeMapping)((EdgeMappingImportWrapper)edgeMapping).getWrappedEdgeMappingImport());
        } else {
            newEdge.setActualMapping((IEdgeMapping)edgeMapping);
        }
        DDiagram diagram = null;
        if (source instanceof DDiagramElement) {
            diagram = ((DDiagramElement)source).getParentDiagram();
        }
        newEdge.setTarget(semanticTargetToUseForExpression);
        if (semanticTarget == null && !StringUtil.isEmpty((String)edgeMapping.getTargetExpression())) {
            EObject context = newEdge.getTarget();
            this.interpreter.setVariable("viewPoint", (Object)diagram);
            this.interpreter.setVariable("viewpoint", (Object)diagram);
            this.interpreter.setVariable("diagram", (Object)diagram);
            EObject adapterValue = RuntimeLoggerManager.INSTANCE.decorate(this.interpreter).evaluateEObject(context, (EObject)edgeMapping, (EStructuralFeature)DescriptionPackage.eINSTANCE.getEdgeMapping_TargetExpression());
            if (adapterValue != null) {
                newEdge.setTarget(adapterValue);
            }
            this.interpreter.unSetVariable("viewPoint");
            this.interpreter.unSetVariable("viewpoint");
            this.interpreter.unSetVariable("diagram");
        }
        EdgeStyle style = (EdgeStyle)new MappingWithInterpreterHelper(this.interpreter).getBestStyle((DiagramElementMapping)edgeMapping, newEdge.getTarget(), (EObject)diagram, container, diagram);
        EdgeStyleDescription styleDescription = null;
        DiagramElementMappingHelper.refreshSemanticElements((DiagramElementMapping)edgeMapping, (DDiagramElement)newEdge, this.interpreter);
        this.createPath(edgeMapping, newEdge, (EObject)diagram);
        if (style != null) {
            newEdge.setOwnedStyle(style);
            StyleDescription description = style.getDescription();
            if (description instanceof EdgeStyleDescription) {
                styleDescription = (EdgeStyleDescription)description;
            }
        }
        if (newEdge.getOwnedStyle() != null) {
            Option noPreviousStyle = Options.newNone();
            new StyleHelper(this.interpreter).refreshStyle((Style)newEdge.getOwnedStyle(), (Option<? extends Style>)noPreviousStyle);
        }
        if (styleDescription != null) {
            String endName;
            String beginName;
            String name = this.computeLabel((DSemanticDecorator)newEdge, (EObject)styleDescription.getCenterLabelStyleDescription(), diagram);
            if (name != null) {
                newEdge.setName(name);
            }
            if ((beginName = this.computeLabel((DSemanticDecorator)newEdge, (EObject)styleDescription.getBeginLabelStyleDescription(), diagram)) != null) {
                newEdge.setBeginLabel(beginName);
            }
            if ((endName = this.computeLabel((DSemanticDecorator)newEdge, (EObject)styleDescription.getEndLabelStyleDescription(), diagram)) != null) {
                newEdge.setEndLabel(endName);
            }
        }
        return newEdge;
    }

    private String computeLabel(DSemanticDecorator view, EObject descriptionObject, DDiagram diagram) {
        String result = null;
        if (descriptionObject instanceof BasicLabelStyleDescription) {
            result = IInterpreterMessages.DEFAULT_NAME_ON_FACTORY_EXCEPTION;
            String labelExpression = ((BasicLabelStyleDescription)descriptionObject).getLabelExpression();
            this.interpreter.setVariable("view", (Object)view);
            this.interpreter.setVariable("diagram", (Object)diagram);
            try {
                try {
                    result = this.interpreter.evaluateString(view.getTarget(), labelExpression);
                }
                catch (EvaluationException e) {
                    RuntimeLoggerManager.INSTANCE.error(descriptionObject, (EStructuralFeature)StylePackage.eINSTANCE.getBasicLabelStyleDescription_LabelExpression(), (Throwable)e);
                    this.interpreter.unSetVariable("diagram");
                    this.interpreter.unSetVariable("view");
                }
            }
            finally {
                this.interpreter.unSetVariable("diagram");
                this.interpreter.unSetVariable("view");
            }
        }
        return result;
    }

    private void createPath(EdgeMapping edgeMapping, DEdge edge, EObject diagram) {
        if (edgeMapping.getPathExpression() != null && !StringUtil.isEmpty((String)edgeMapping.getPathExpression()) && edgeMapping.getPathNodeMapping() != null) {
            this.interpreter.setVariable("viewpoint", (Object)diagram);
            this.interpreter.setVariable("diagram", (Object)diagram);
            this.interpreter.setVariable("element", (Object)edge.getTarget());
            this.interpreter.setVariable("source", (Object)this.getSemanticTarget(edge.getSourceNode()));
            this.interpreter.setVariable("target", (Object)this.getSemanticTarget(edge.getTargetNode()));
            Collection elements = RuntimeLoggerManager.INSTANCE.decorate(this.interpreter).evaluateCollection(edge.getTarget(), (EObject)edgeMapping, (EStructuralFeature)DescriptionPackage.eINSTANCE.getEdgeMapping_PathExpression());
            this.interpreter.unSetVariable("diagram");
            this.interpreter.unSetVariable("viewpoint");
            this.interpreter.unSetVariable("element");
            this.interpreter.unSetVariable("source");
            this.interpreter.unSetVariable("target");
            BasicEList newPath = new BasicEList();
            for (EObject current : elements) {
                for (AbstractNodeMapping currentNodeMapping : edgeMapping.getPathNodeMapping()) {
                    List<DDiagramElement> listView = this.findDNodeFromEObject(currentNodeMapping, current);
                    if (listView == null) continue;
                    for (DDiagramElement vpElement : listView) {
                        if (!(vpElement instanceof EdgeTarget)) continue;
                        newPath.add((Object)((EdgeTarget)vpElement));
                    }
                }
            }
            EqualityHelper equalityHelper = new EqualityHelper();
            if (!equalityHelper.equals((List)edge.getPath(), (List)newPath)) {
                edge.getPath().clear();
                edge.getPath().addAll((Collection)newPath);
            }
        }
    }

    private List<DDiagramElement> findDNodeFromEObject(AbstractNodeMapping currentNodeMapping, EObject current) {
        BasicEList result = new BasicEList();
        if (currentNodeMapping instanceof ContainerMapping) {
            ContainerMapping containerMapping = (ContainerMapping)currentNodeMapping;
            result = MappingExtHelper.findDNodeFromEObject((ContainerMapping)containerMapping, (EObject)current);
        } else if (currentNodeMapping instanceof NodeMapping) {
            NodeMapping nodeMapping = (NodeMapping)currentNodeMapping;
            result = MappingExtHelper.findDNodeFromEObject((NodeMapping)nodeMapping, (EObject)current);
        }
        return result;
    }

    public void updateEdge(EdgeMapping edgeMapping, DEdge dEdge) {
        if (this.validate(dEdge)) {
            EObject containerVariable = null;
            if (dEdge.eContainer() instanceof DSemanticDecorator) {
                containerVariable = ((DSemanticDecorator)dEdge.eContainer()).getTarget();
            }
            DDiagram dDiagram = dEdge.getParentDiagram();
            EdgeStyleDescription styleDescription = (EdgeStyleDescription)new MappingWithInterpreterHelper(this.interpreter).getBestStyleDescription((DiagramElementMapping)edgeMapping, dEdge.getTarget(), (EObject)dEdge, containerVariable, dDiagram);
            this.createPath(edgeMapping, dEdge, (EObject)dDiagram);
            DiagramElementMappingHelper.refreshSemanticElements((DiagramElementMapping)edgeMapping, (DDiagramElement)dEdge, this.interpreter);
            if (styleDescription != null) {
                String endName;
                String beginName;
                String name = this.computeLabel((DSemanticDecorator)dEdge, (EObject)styleDescription.getCenterLabelStyleDescription(), dDiagram);
                if (name != null) {
                    dEdge.setName(name);
                }
                if ((beginName = this.computeLabel((DSemanticDecorator)dEdge, (EObject)styleDescription.getBeginLabelStyleDescription(), dDiagram)) != null) {
                    dEdge.setBeginLabel(beginName);
                }
                if ((endName = this.computeLabel((DSemanticDecorator)dEdge, (EObject)styleDescription.getEndLabelStyleDescription(), dDiagram)) != null) {
                    dEdge.setEndLabel(endName);
                }
            }
            StyleHelper styleHelper = new StyleHelper(this.interpreter);
            if (styleDescription != null && dEdge.getStyle() != null && styleDescription != dEdge.getStyle().getDescription()) {
                styleHelper.setAndRefreshStyle((DDiagramElement)dEdge, (Style)dEdge.getOwnedStyle(), styleHelper.createStyle((StyleDescription)styleDescription));
            } else if (dEdge.getOwnedStyle() != null) {
                styleHelper.refreshStyle((Style)dEdge.getOwnedStyle());
            }
        }
    }

    private boolean validate(DEdge dEdge) {
        DSemanticDiagram diagram;
        boolean result = true;
        DslCommonPlugin.PROFILER.startWork(SiriusTasksKey.VALIDATE_EDGE_KEY);
        IEdgeMapping actualMapping = dEdge.getActualMapping();
        if (actualMapping != null && this.cantFindSemanticTargetFromSemanticSource(dEdge)) {
            result = false;
        }
        EObject root = null;
        DDiagram parentDiagram = dEdge.getParentDiagram();
        if (parentDiagram instanceof DSemanticDiagram) {
            diagram = (DSemanticDiagram)parentDiagram;
            root = DSemanticDiagramHelper.getRootContent(diagram);
        } else {
            diagram = null;
        }
        if (diagram != null && root != null && actualMapping != null) {
            Collection<EObject> candidates;
            IInterpreter rootInterpreter = SiriusPlugin.getDefault().getInterpreterRegistry().getInterpreter(root);
            Option<EdgeMapping> edgeMappingOption = new IEdgeMappingQuery(actualMapping).getEdgeMapping();
            if (edgeMappingOption.some() && ((EdgeMapping)edgeMappingOption.get()).isUseDomainElement() && !(candidates = this.getSemanticCandidates(dEdge, rootInterpreter, root, (DDiagram)diagram)).contains(dEdge.getTarget())) {
                DslCommonPlugin.PROFILER.stopWork(SiriusTasksKey.VALIDATE_EDGE_KEY);
                return false;
            }
            if (edgeMappingOption.some() && dEdge.getSourceNode() instanceof DSemanticDecorator && dEdge.getTargetNode() instanceof DSemanticDecorator) {
                EdgeMapping edgeMapping = (EdgeMapping)edgeMappingOption.get();
                EdgeMappingQuery edgeMappingQuery = new EdgeMappingQuery(edgeMapping);
                result = result && edgeMappingQuery.evaluatePrecondition(diagram, (DragAndDropTarget)diagram, rootInterpreter, dEdge.getTarget(), (DSemanticDecorator)dEdge.getSourceNode(), (DSemanticDecorator)dEdge.getTargetNode());
            }
        }
        DslCommonPlugin.PROFILER.stopWork(SiriusTasksKey.VALIDATE_EDGE_KEY);
        return result;
    }

    private boolean cantFindSemanticTargetFromSemanticSource(DEdge dEdge) {
        EdgeTarget tgNode;
        Option<EdgeMapping> edgeMapping;
        DDiagram vp = null;
        boolean result = false;
        EdgeTarget srcNode = dEdge.getSourceNode();
        if (srcNode instanceof DDiagramElement) {
            vp = ((DDiagramElement)srcNode).getParentDiagram();
        }
        if ((edgeMapping = new IEdgeMappingQuery(dEdge.getActualMapping()).getEdgeMapping()).some() && srcNode instanceof DSemanticDecorator && (tgNode = dEdge.getTargetNode()) instanceof DSemanticDecorator) {
            EObject semanticSource = ((DSemanticDecorator)srcNode).getTarget();
            EObject semanticTarget = ((DSemanticDecorator)tgNode).getTarget();
            result = !this.findTargetFromSource(dEdge, (EdgeMapping)edgeMapping.get(), vp, semanticSource, semanticTarget);
        }
        return result;
    }

    private boolean findTargetFromSource(DEdge dEdge, EdgeMapping mapping, DDiagram vp, EObject source, EObject target) {
        boolean result = false;
        if (mapping.isUseDomainElement()) {
            EObject edgeTarget = dEdge.getTarget();
            if (this.getEdgeMappingTargetCandidates(mapping, edgeTarget, vp).contains((Object)target) && this.getEdgeMappingSourceCandidates(mapping, edgeTarget, vp).contains((Object)source)) {
                result = true;
            }
        } else if (this.getEdgeMappingTargetCandidates(mapping, source, vp).contains((Object)target)) {
            result = true;
        }
        return result;
    }

    private Collection<EObject> getSemanticCandidates(DEdge dEdge, IInterpreter iInterpreter, EObject model, DDiagram diagram) {
        Collection<Object> semanticCandidates;
        block11: {
            semanticCandidates = null;
            IEdgeMapping actualMapping = dEdge.getActualMapping();
            Option<EdgeMapping> actualEdgeMappingOption = new IEdgeMappingQuery(actualMapping).getEdgeMapping();
            if (actualEdgeMappingOption.some()) {
                EdgeMapping actualEdgeMapping = (EdgeMapping)actualEdgeMappingOption.get();
                if (actualEdgeMapping.isUseDomainElement() && actualEdgeMapping.getSemanticCandidatesExpression() != null && !StringUtil.isEmpty((String)actualEdgeMapping.getSemanticCandidatesExpression().trim())) {
                    iInterpreter.setVariable("viewpoint", (Object)diagram);
                    iInterpreter.setVariable("viewPoint", (Object)diagram);
                    iInterpreter.setVariable("diagram", (Object)diagram);
                    iInterpreter.setVariable("containerView", (Object)diagram);
                    EObject context = model;
                    try {
                        try {
                            semanticCandidates = iInterpreter.evaluateCollection(context, actualEdgeMapping.getSemanticCandidatesExpression());
                        }
                        catch (EvaluationException e) {
                            RuntimeLoggerManager.INSTANCE.error((EObject)actualMapping, (EStructuralFeature)DescriptionPackage.eINSTANCE.getDiagramElementMapping_SemanticCandidatesExpression(), (Throwable)e);
                            iInterpreter.unSetVariable("containerView");
                            iInterpreter.unSetVariable("diagram");
                            iInterpreter.unSetVariable("viewPoint");
                            iInterpreter.unSetVariable("viewpoint");
                            break block11;
                        }
                    }
                    catch (Throwable throwable) {
                        iInterpreter.unSetVariable("containerView");
                        iInterpreter.unSetVariable("diagram");
                        iInterpreter.unSetVariable("viewPoint");
                        iInterpreter.unSetVariable("viewpoint");
                        throw throwable;
                    }
                    iInterpreter.unSetVariable("containerView");
                    iInterpreter.unSetVariable("diagram");
                    iInterpreter.unSetVariable("viewPoint");
                    iInterpreter.unSetVariable("viewpoint");
                } else {
                    ModelAccessor extPackage = SiriusPlugin.getDefault().getModelAccessorRegistry().getModelAccessor(model);
                    semanticCandidates = new ArrayList();
                    Session session = SessionManager.INSTANCE.getSession(model);
                    for (Resource resource : session.getSemanticResources()) {
                        for (EObject root : resource.getContents()) {
                            semanticCandidates.addAll(extPackage.eAllContents(root, "EObject"));
                        }
                    }
                }
            }
        }
        if (semanticCandidates == null) {
            semanticCandidates = Collections.emptySet();
        }
        return semanticCandidates;
    }

    public static boolean isImported(IEdgeMapping mapping, EdgeMappingImport edgeMappingImport) {
        boolean result = false;
        if (mapping.equals(edgeMappingImport.getImportedMapping())) {
            result = true;
        } else if (edgeMappingImport.getImportedMapping() instanceof EdgeMappingImport) {
            result = EdgeMappingHelper.isImported(mapping, (EdgeMappingImport)edgeMappingImport.getImportedMapping());
        }
        return result;
    }

    private EList<EObject> getEdgeMappingTargetCandidates(EdgeMapping edgeMapping, EObject semanticOrigin, DDiagram diagram) {
        IInterpreter newInterpreter = SiriusPlugin.getDefault().getInterpreterRegistry().getInterpreter(semanticOrigin);
        return new EdgeMappingHelper(newInterpreter).getEdgeTargetCandidates(edgeMapping, semanticOrigin, diagram);
    }

    private EList<EObject> getEdgeMappingSourceCandidates(EdgeMapping edgeMapping, EObject semanticOrigin, DDiagram diagram) {
        IInterpreter newInterpreter = SiriusPlugin.getDefault().getInterpreterRegistry().getInterpreter((EObject)edgeMapping.getStyle());
        return new EdgeMappingHelper(newInterpreter).getEdgeSourceCandidates(edgeMapping, semanticOrigin, diagram);
    }
}

