/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.p1cycles;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import org.eclipse.elk.alg.layered.LayeredPhases;
import org.eclipse.elk.alg.layered.graph.LEdge;
import org.eclipse.elk.alg.layered.graph.LGraph;
import org.eclipse.elk.alg.layered.graph.LNode;
import org.eclipse.elk.alg.layered.graph.LPort;
import org.eclipse.elk.alg.layered.intermediate.IntermediateProcessorStrategy;
import org.eclipse.elk.alg.layered.options.InternalProperties;
import org.eclipse.elk.alg.layered.options.LayerConstraint;
import org.eclipse.elk.alg.layered.options.LayeredOptions;
import org.eclipse.elk.alg.layered.options.PortType;
import org.eclipse.elk.core.alg.ILayoutPhase;
import org.eclipse.elk.core.alg.ILayoutProcessorFactory;
import org.eclipse.elk.core.alg.LayoutProcessorConfiguration;
import org.eclipse.elk.core.util.IElkProgressMonitor;

public final class ModelOrderCycleBreaker
implements ILayoutPhase<LayeredPhases, LGraph> {
    private int firstSeparateModelOrder;
    private int lastSeparateModelOrder;
    private static final LayoutProcessorConfiguration<LayeredPhases, LGraph> INTERMEDIATE_PROCESSING_CONFIGURATION = LayoutProcessorConfiguration.create().addAfter((Enum)LayeredPhases.P5_EDGE_ROUTING, (ILayoutProcessorFactory)IntermediateProcessorStrategy.REVERSED_EDGE_RESTORER);

    public LayoutProcessorConfiguration<LayeredPhases, LGraph> getLayoutProcessorConfiguration(LGraph graph) {
        return INTERMEDIATE_PROCESSING_CONFIGURATION;
    }

    public void process(LGraph layeredGraph, IElkProgressMonitor monitor) {
        monitor.begin("Model order cycle breaking", 1.0f);
        this.firstSeparateModelOrder = 0;
        this.lastSeparateModelOrder = 0;
        ArrayList revEdges = Lists.newArrayList();
        int offset = layeredGraph.getLayerlessNodes().size();
        for (LNode node : layeredGraph.getLayerlessNodes()) {
            if (!node.hasProperty(InternalProperties.MODEL_ORDER)) continue;
            offset = Math.max(offset, (Integer)node.getProperty(InternalProperties.MODEL_ORDER) + 1);
        }
        for (LNode source : layeredGraph.getLayerlessNodes()) {
            int modelOrderSource = this.computeConstraintModelOrder(source, offset);
            for (LPort port : source.getPorts(PortType.OUTPUT)) {
                for (LEdge edge : port.getOutgoingEdges()) {
                    LNode target = edge.getTarget().getNode();
                    int modelOrderTarget = this.computeConstraintModelOrder(target, offset);
                    if (modelOrderTarget >= modelOrderSource) continue;
                    revEdges.add(edge);
                }
            }
        }
        for (LEdge edge : revEdges) {
            edge.reverse(layeredGraph, true);
            layeredGraph.setProperty(InternalProperties.CYCLIC, true);
        }
        revEdges.clear();
        monitor.done();
    }

    private int computeConstraintModelOrder(LNode node, int offset) {
        int modelOrder = 0;
        switch ((LayerConstraint)((Object)node.getProperty(LayeredOptions.LAYERING_LAYER_CONSTRAINT))) {
            case FIRST_SEPARATE: {
                modelOrder = 2 * -offset + this.firstSeparateModelOrder;
                ++this.firstSeparateModelOrder;
                break;
            }
            case FIRST: {
                modelOrder = -offset;
                break;
            }
            case LAST: {
                modelOrder = offset;
                break;
            }
            case LAST_SEPARATE: {
                modelOrder = 2 * offset + this.lastSeparateModelOrder;
                ++this.lastSeparateModelOrder;
                break;
            }
        }
        if (node.hasProperty(InternalProperties.MODEL_ORDER)) {
            modelOrder += ((Integer)node.getProperty(InternalProperties.MODEL_ORDER)).intValue();
        }
        return modelOrder;
    }
}

