/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.intermediate.loops.routing;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.elk.alg.layered.graph.LMargin;
import org.eclipse.elk.alg.layered.graph.LNode;
import org.eclipse.elk.alg.layered.graph.LPort;
import org.eclipse.elk.alg.layered.intermediate.loops.SelfHyperLoop;
import org.eclipse.elk.alg.layered.intermediate.loops.SelfHyperLoopLabels;
import org.eclipse.elk.alg.layered.intermediate.loops.SelfLoopHolder;
import org.eclipse.elk.alg.layered.intermediate.loops.SelfLoopPort;
import org.eclipse.elk.alg.layered.options.LayeredOptions;
import org.eclipse.elk.alg.layered.options.SelfLoopOrderingStrategy;
import org.eclipse.elk.core.labels.ILabelManager;
import org.eclipse.elk.core.math.KVector;
import org.eclipse.elk.core.options.PortSide;
import org.eclipse.elk.core.util.IElkProgressMonitor;

public final class LabelPlacer {
    public void placeLabels(SelfLoopHolder slHolder, ILabelManager labelManager, IElkProgressMonitor monitor) {
        this.assignSideAndAlignment(slHolder);
        for (SelfHyperLoop slLoop : slHolder.getSLHyperLoops()) {
            if (slLoop.getSLLabels() == null) continue;
            if (labelManager != null) {
                this.manageLabels(slLoop, labelManager);
            }
            this.computeCoordinates(slLoop);
        }
    }

    private void assignSideAndAlignment(SelfLoopHolder slHolder) {
        ArrayList<SelfHyperLoop> northernOneSidedSLLoops = null;
        ArrayList<SelfHyperLoop> southernOneSidedSLLoops = null;
        SelfLoopOrderingStrategy orderingStrategy = (SelfLoopOrderingStrategy)((Object)slHolder.getLNode().getProperty(LayeredOptions.EDGE_ROUTING_SELF_LOOP_ORDERING));
        if (orderingStrategy == SelfLoopOrderingStrategy.SEQUENCED) {
            northernOneSidedSLLoops = new ArrayList<SelfHyperLoop>();
            southernOneSidedSLLoops = new ArrayList<SelfHyperLoop>();
        }
        block6: for (SelfHyperLoop slLoop : slHolder.getSLHyperLoops()) {
            SelfHyperLoopLabels slLabels = slLoop.getSLLabels();
            if (slLabels == null) continue;
            assert (!slLabels.getLLabels().isEmpty());
            switch (slLoop.getSelfLoopType()) {
                case ONE_SIDE: {
                    PortSide loopSide = slLoop.getOccupiedPortSides().iterator().next();
                    if (orderingStrategy == SelfLoopOrderingStrategy.SEQUENCED && loopSide == PortSide.NORTH) {
                        northernOneSidedSLLoops.add(slLoop);
                        break;
                    }
                    if (orderingStrategy == SelfLoopOrderingStrategy.SEQUENCED && loopSide == PortSide.SOUTH) {
                        southernOneSidedSLLoops.add(slLoop);
                        break;
                    }
                    this.assignOneSidedSimpleSideAndAlignment(slLoop, loopSide);
                    break;
                }
                case TWO_SIDES_CORNER: {
                    this.assignTwoSidesCornerSideAndAlignment(slLoop);
                    break;
                }
                case TWO_SIDES_OPPOSING: 
                case THREE_SIDES: {
                    this.assignTwoSidesOpposingAndThreeSidesSideAndAlignment(slLoop);
                    break;
                }
                case FOUR_SIDES: {
                    this.assignFourSidesSideAndAlignment(slLoop);
                    break;
                }
                default: {
                    assert (false);
                    continue block6;
                }
            }
        }
        if (northernOneSidedSLLoops != null) {
            if (!northernOneSidedSLLoops.isEmpty()) {
                this.assignOneSidedSequencedSideAndAlignment(northernOneSidedSLLoops, PortSide.NORTH);
            }
            if (!southernOneSidedSLLoops.isEmpty()) {
                this.assignOneSidedSequencedSideAndAlignment(southernOneSidedSLLoops, PortSide.SOUTH);
            }
        }
    }

    private void assignOneSidedSimpleSideAndAlignment(SelfHyperLoop slLoop, PortSide loopSide) {
        switch (loopSide) {
            case EAST: 
            case WEST: {
                SelfLoopPort topmostPort = slLoop.getLeftmostPort();
                if (slLoop.getRightmostPort().getLPort().getPosition().y < topmostPort.getLPort().getPosition().y) {
                    topmostPort = slLoop.getRightmostPort();
                }
                this.assignSideAndAlignment(slLoop, loopSide, SelfHyperLoopLabels.Alignment.TOP, topmostPort);
                break;
            }
            case NORTH: 
            case SOUTH: {
                this.assignSideAndAlignment(slLoop, loopSide, SelfHyperLoopLabels.Alignment.CENTER, null);
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
    }

    private void assignOneSidedSequencedSideAndAlignment(List<SelfHyperLoop> slLoops, PortSide portSide) {
        assert (!slLoops.isEmpty());
        int id = 0;
        for (LPort lPort : slLoops.get(0).getSLHolder().getLNode().getPorts()) {
            lPort.id = id++;
        }
        if (portSide == PortSide.NORTH) {
            slLoops.sort((slLoop1, slLoop2) -> Integer.compare(slLoop1.getLeftmostPort().getLPort().id, slLoop2.getLeftmostPort().getLPort().id));
        } else {
            slLoops.sort((slLoop1, slLoop2) -> Integer.compare(slLoop2.getLeftmostPort().getLPort().id, slLoop1.getLeftmostPort().getLPort().id));
        }
        int leftSlLoopIdx = 0;
        int rightSlLoopIdx = slLoops.size() - 1;
        while (leftSlLoopIdx < rightSlLoopIdx) {
            SelfHyperLoop leftSlLoop = slLoops.get(leftSlLoopIdx);
            SelfHyperLoop rightSlLoop = slLoops.get(rightSlLoopIdx);
            SelfLoopPort leftLoopAlignmentReference = portSide == PortSide.NORTH ? leftSlLoop.getRightmostPort() : leftSlLoop.getLeftmostPort();
            SelfLoopPort rightLoopAlignmentReference = portSide == PortSide.NORTH ? rightSlLoop.getLeftmostPort() : rightSlLoop.getRightmostPort();
            this.assignSideAndAlignment(leftSlLoop, portSide, SelfHyperLoopLabels.Alignment.RIGHT, leftLoopAlignmentReference);
            this.assignSideAndAlignment(rightSlLoop, portSide, SelfHyperLoopLabels.Alignment.LEFT, rightLoopAlignmentReference);
            ++leftSlLoopIdx;
            --rightSlLoopIdx;
        }
        if (leftSlLoopIdx == rightSlLoopIdx) {
            this.assignSideAndAlignment(slLoops.get(leftSlLoopIdx), portSide, SelfHyperLoopLabels.Alignment.CENTER, null);
        }
    }

    private void assignTwoSidesCornerSideAndAlignment(SelfHyperLoop slLoop) {
        PortSide leftmostPortSide = slLoop.getLeftmostPort().getLPort().getSide();
        PortSide rightmostPortSide = slLoop.getRightmostPort().getLPort().getSide();
        if (leftmostPortSide == PortSide.NORTH) {
            this.assignSideAndAlignment(slLoop, PortSide.NORTH, SelfHyperLoopLabels.Alignment.LEFT, slLoop.getLeftmostPort());
        } else if (rightmostPortSide == PortSide.NORTH) {
            this.assignSideAndAlignment(slLoop, PortSide.NORTH, SelfHyperLoopLabels.Alignment.RIGHT, slLoop.getRightmostPort());
        } else if (leftmostPortSide == PortSide.SOUTH) {
            this.assignSideAndAlignment(slLoop, PortSide.SOUTH, SelfHyperLoopLabels.Alignment.RIGHT, slLoop.getLeftmostPort());
        } else if (rightmostPortSide == PortSide.SOUTH) {
            this.assignSideAndAlignment(slLoop, PortSide.SOUTH, SelfHyperLoopLabels.Alignment.LEFT, slLoop.getRightmostPort());
        } else assert (false);
    }

    private void assignTwoSidesOpposingAndThreeSidesSideAndAlignment(SelfHyperLoop slLoop) {
        Set<PortSide> occupiedSides = slLoop.getOccupiedPortSides();
        if (!occupiedSides.contains(PortSide.NORTH)) {
            this.assignSideAndAlignment(slLoop, PortSide.SOUTH, SelfHyperLoopLabels.Alignment.CENTER, null);
        } else if (!occupiedSides.contains(PortSide.SOUTH)) {
            this.assignSideAndAlignment(slLoop, PortSide.NORTH, SelfHyperLoopLabels.Alignment.CENTER, null);
        } else if (!occupiedSides.contains(PortSide.WEST)) {
            this.assignSideAndAlignment(slLoop, PortSide.NORTH, SelfHyperLoopLabels.Alignment.LEFT, slLoop.getLeftmostPort());
        } else if (!occupiedSides.contains(PortSide.EAST)) {
            this.assignSideAndAlignment(slLoop, PortSide.NORTH, SelfHyperLoopLabels.Alignment.RIGHT, slLoop.getRightmostPort());
        } else assert (false);
    }

    private void assignFourSidesSideAndAlignment(SelfHyperLoop slLoop) {
        PortSide leftmostPortSide = slLoop.getLeftmostPort().getLPort().getSide();
        PortSide rightmostPortSide = slLoop.getLeftmostPort().getLPort().getSide();
        if (leftmostPortSide == PortSide.NORTH || rightmostPortSide == PortSide.NORTH) {
            this.assignSideAndAlignment(slLoop, PortSide.SOUTH, SelfHyperLoopLabels.Alignment.CENTER, null);
        } else {
            this.assignSideAndAlignment(slLoop, PortSide.NORTH, SelfHyperLoopLabels.Alignment.CENTER, null);
        }
    }

    private void assignSideAndAlignment(SelfHyperLoop slLoop, PortSide side, SelfHyperLoopLabels.Alignment alignment, SelfLoopPort alignmentReference) {
        SelfHyperLoopLabels slLabels = slLoop.getSLLabels();
        slLabels.setSide(side);
        slLabels.setAlignment(alignment);
        slLabels.setAlignmentReferenceSLPort(alignmentReference);
    }

    private void manageLabels(SelfHyperLoop slLoop, ILabelManager labelManager) {
        SelfHyperLoopLabels slLabels = slLoop.getSLLabels();
        SelfLoopPort alignRef = slLabels.getAlignmentReferenceSLPort();
        LNode lNode = slLoop.getSLHolder().getLNode();
        KVector lNodeSize = lNode.getSize();
        LMargin lNodeMargins = slLoop.getSLHolder().getLNode().getMargin();
        double targetWidth = 0.0;
        switch (slLabels.getAlignment()) {
            case CENTER: {
                targetWidth = lNodeMargins.left + lNodeSize.x + lNodeMargins.right;
                break;
            }
            case LEFT: {
                targetWidth = lNodeSize.x - alignRef.getLPort().getPosition().x - alignRef.getLPort().getAnchor().x + lNodeMargins.right;
                break;
            }
            case RIGHT: {
                targetWidth = lNodeMargins.left + alignRef.getLPort().getPosition().x + alignRef.getLPort().getAnchor().x;
                break;
            }
            case TOP: {
                targetWidth = 60.0;
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        slLabels.applyLabelManagement(labelManager, Math.max(targetWidth, 60.0));
    }

    private void computeCoordinates(SelfHyperLoop slLoop) {
        SelfHyperLoopLabels slLabels = slLoop.getSLLabels();
        SelfLoopPort alignRef = slLabels.getAlignmentReferenceSLPort();
        KVector size = slLabels.getSize();
        KVector pos = slLabels.getPosition();
        switch (slLabels.getAlignment()) {
            case CENTER: {
                pos.x = (slLoop.getSLHolder().getLNode().getSize().x - size.x) / 2.0;
                break;
            }
            case LEFT: {
                pos.x = alignRef.getLPort().getPosition().x + alignRef.getLPort().getAnchor().x;
                break;
            }
            case RIGHT: {
                pos.x = alignRef.getLPort().getPosition().x + alignRef.getLPort().getAnchor().x - size.x;
                break;
            }
            case TOP: {
                pos.y = alignRef.getLPort().getPosition().y + alignRef.getLPort().getAnchor().y;
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
    }
}

