/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.tools.internal.resource;

import java.util.Objects;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.sirius.business.api.query.FileQuery;
import org.eclipse.sirius.common.tools.api.util.StringUtil;

public class ModelingProjectFileQuery {
    private final IFile file;

    public ModelingProjectFileQuery(IFile file) {
        this.file = Objects.requireNonNull(file);
    }

    protected boolean isRepresentationsModel(IFile aFile) {
        return new FileQuery(aFile).isSessionResourceFile();
    }

    protected boolean isVsmModel(IFile aFile) {
        return new FileQuery(aFile).isVSMFile();
    }

    public boolean isPotentialSemanticResource() {
        boolean fileToIgnore;
        boolean bl = fileToIgnore = this.isRepresentationsModel(this.file) || this.isVsmModel(this.file) || this.isRepFile(this.file);
        if (!fileToIgnore) {
            fileToIgnore = this.file.isDerived(512) || this.file.getFullPath().toString().contains("/.svn/") || this.isRepairBackupFile();
        }
        return !fileToIgnore;
    }

    private boolean isRepFile(IFile aFile) {
        return new FileQuery(aFile).isSrmFile();
    }

    private boolean isRepairBackupFile() {
        IPath repairedPath;
        if ("old".equals(this.file.getFileExtension()) && !StringUtil.isEmpty((String)(repairedPath = this.file.getFullPath().removeFileExtension()).getFileExtension())) {
            IFile repairedFile = this.file.getWorkspace().getRoot().getFile(repairedPath);
            return this.isVsmModel(repairedFile) || this.isRepresentationsModel(repairedFile);
        }
        return false;
    }
}

