/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.figure.locator;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gmf.runtime.diagram.ui.figures.BorderedNodeFigure;
import org.eclipse.sirius.diagram.ui.tools.api.figure.locator.DBorderItemLocator;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.Options;

public class FeedbackDBorderItemLocator
extends DBorderItemLocator {
    public FeedbackDBorderItemLocator(IFigure parentFigure) {
        super(parentFigure);
    }

    @Override
    protected List<IFigure> getBrotherFigures(IFigure targetBorderItem) {
        IFigure parentFigure = this.getParentFigure();
        if (parentFigure instanceof BorderedNodeFigure) {
            parentFigure = ((BorderedNodeFigure)parentFigure).getBorderItemContainer();
        }
        Iterable brotherFigures = Iterables.filter((Iterable)parentFigure.getChildren(), (Predicate)Predicates.and((Predicate)Predicates.instanceOf(IFigure.class), (Predicate)Predicates.not((Predicate)Predicates.equalTo((Object)targetBorderItem))));
        return Lists.newArrayList((Iterable)brotherFigures);
    }

    @Override
    protected Option<Rectangle> conflicts(Rectangle recommendedRect, List<IFigure> figuresToCheck, Collection<IFigure> portsFiguresToIgnore) {
        ListIterator<IFigure> iterator = figuresToCheck.listIterator();
        while (iterator.hasNext()) {
            IFigure borderItem = iterator.next();
            if (portsFiguresToIgnore.contains(borderItem) || !borderItem.isVisible()) continue;
            Rectangle rect = new Rectangle(borderItem.getBounds());
            if (portsFiguresToIgnore.contains(borderItem) || !rect.intersects(recommendedRect)) continue;
            return Options.newSome((Object)rect);
        }
        return Options.newNone();
    }
}

