/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.tree.ui.tools.internal.editor.actions;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.sirius.tree.ui.business.internal.refresh.TreeRefresherHelper;
import org.eclipse.sirius.tree.ui.provider.Messages;
import org.eclipse.sirius.tree.ui.tools.internal.editor.DTreeEditor;
import org.eclipse.sirius.tree.ui.tools.internal.editor.DTreeViewerManager;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;

public class RefreshAction
extends Action
implements IObjectActionDelegate {
    private DTreeEditor treeEditor;
    private ISelection selection;

    public RefreshAction(DTreeEditor treeEditor) {
        super(Messages.RefreshAction_refreshTreeElement, DTreeViewerManager.getImageRegistry().getDescriptor("tree/refresh"));
        this.treeEditor = treeEditor;
    }

    public void run() {
        IEditorPart activeEditor;
        IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        if (activePage != null && (activeEditor = activePage.getActiveEditor()) instanceof DTreeEditor) {
            this.treeEditor = (DTreeEditor)activeEditor;
            this.selection = activePage.getSelection();
            if (this.selection instanceof IStructuredSelection) {
                IStructuredSelection structuredSelection = (IStructuredSelection)this.selection;
                TreeRefresherHelper.refreshEditor(this.treeEditor, structuredSelection, (IProgressMonitor)new NullProgressMonitor());
            }
        }
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public void run(IAction action) {
        this.run();
    }

    public void selectionChanged(IAction action, ISelection sel) {
        this.selection = sel;
    }
}

