/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.table.ui.tools.internal.editor.provider;

import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.sirius.ecore.extender.business.api.accessor.ModelAccessor;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.table.business.api.helper.TableHelper;
import org.eclipse.sirius.table.business.api.helper.TableToolHelper;
import org.eclipse.sirius.table.metamodel.table.DCell;
import org.eclipse.sirius.table.metamodel.table.DColumn;
import org.eclipse.sirius.table.metamodel.table.DLine;
import org.eclipse.sirius.table.metamodel.table.DTargetColumn;
import org.eclipse.sirius.table.tools.api.command.ITableCommandFactory;
import org.eclipse.sirius.table.ui.tools.internal.editor.AbstractDTableEditor;
import org.eclipse.sirius.table.ui.tools.internal.editor.DTableTreeViewer;
import org.eclipse.sirius.table.ui.tools.internal.editor.provider.DTableCellEditorFocusListener;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Tree;

public class DTargetColumnEditingSupport
extends EditingSupport {
    private DTargetColumn targetColumn;
    private TransactionalEditingDomain editingDomain;
    private ModelAccessor accessor;
    private ITableCommandFactory tableCommandFactory;
    private AbstractDTableEditor tableEditor;

    public DTargetColumnEditingSupport(DTableTreeViewer viewer, DTargetColumn targetColumn, TransactionalEditingDomain editingDomain, ModelAccessor accessor, ITableCommandFactory tableCommandFactory, AbstractDTableEditor tableEditor) {
        super((ColumnViewer)viewer);
        this.targetColumn = targetColumn;
        this.editingDomain = editingDomain;
        this.accessor = accessor;
        this.tableCommandFactory = tableCommandFactory;
        this.tableEditor = tableEditor;
    }

    public DTableTreeViewer getViewer() {
        return (DTableTreeViewer)super.getViewer();
    }

    protected boolean canEdit(Object element) {
        return element instanceof DLine && new TableToolHelper(this.accessor).canEdit((DLine)element, this.getTargetColumn());
    }

    protected CellEditor getCellEditor(Object element) {
        if (element instanceof DLine) {
            return this.getBestCellEditor(((DLine)element).getTarget());
        }
        return null;
    }

    protected Object getValue(Object element) {
        String result = null;
        if (element instanceof DLine) {
            DLine line = (DLine)element;
            Option optionalEditedCell = TableHelper.getCell((DLine)line, (DColumn)this.targetColumn);
            if (optionalEditedCell.some()) {
                result = ((DCell)optionalEditedCell.get()).getLabel();
            }
            if (result == null) {
                result = "";
            }
        }
        return result;
    }

    protected void setValue(Object element, Object value) {
        if (element instanceof DLine && value instanceof String) {
            DLine line = (DLine)element;
            Option optionalEditedCell = TableHelper.getCell((DLine)line, (DColumn)this.targetColumn);
            Command command = null;
            if (!optionalEditedCell.some()) {
                command = this.tableCommandFactory.buildCreateCellFromTool(line, this.targetColumn, value);
            } else if (!value.equals(((DCell)optionalEditedCell.get()).getLabel())) {
                command = this.tableCommandFactory.buildSetCellValueFromTool((DCell)optionalEditedCell.get(), value);
            }
            if (command != null) {
                this.tableEditor.enablePropertiesUpdate(false);
                if (command.canExecute()) {
                    this.getEditingDomain().getCommandStack().execute(command);
                }
                this.tableEditor.enablePropertiesUpdate(true);
                this.tableEditor.forceRefreshProperties();
            }
        }
    }

    private CellEditor getBestCellEditor(EObject element) {
        Tree tree = this.getViewer().getTree();
        TextCellEditor textEditor = new TextCellEditor((Composite)tree){

            protected void doSetFocus() {
                super.doSetFocus();
                if (this.text != null) {
                    this.text.clearSelection();
                }
            }
        };
        textEditor.getControl().addFocusListener((FocusListener)new DTableCellEditorFocusListener(this.tableEditor, textEditor));
        return textEditor;
    }

    protected DTargetColumn getTargetColumn() {
        return this.targetColumn;
    }

    public TransactionalEditingDomain getEditingDomain() {
        return this.editingDomain;
    }

    protected void initializeCellEditorValue(CellEditor cellEditor, ViewerCell cell) {
        if (this.getViewer().getFirstEditionCharacter() != null) {
            cellEditor.setValue((Object)this.getViewer().getFirstEditionCharacter().toString());
        } else {
            super.initializeCellEditorValue(cellEditor, cell);
        }
    }
}

