/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.tools.internal.actions.creation;

import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.ui.tools.internal.wizards.CreateRepresentationWizard;
import org.eclipse.sirius.viewpoint.provider.Messages;
import org.eclipse.ui.PlatformUI;

public class CreateRepresentationFromSessionAction
extends Action {
    private URI sessionURI;

    public CreateRepresentationFromSessionAction(Session session, ImageDescriptor descriptor) {
        this(session.getSessionResource().getURI(), descriptor);
    }

    public CreateRepresentationFromSessionAction(URI sessionURI, ImageDescriptor descriptor) {
        super(Messages.CreateRepresentationFromSessionAction_name, descriptor);
        this.sessionURI = sessionURI;
    }

    public void run() {
        super.run();
        Session session = SessionManager.INSTANCE.getExistingSession(this.sessionURI);
        if (session != null) {
            CreateRepresentationWizard wizard = new CreateRepresentationWizard(session);
            wizard.init();
            WizardDialog dialog = new WizardDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell(), (IWizard)wizard);
            dialog.setMinimumPageSize(1000, 600);
            dialog.create();
            dialog.getShell().setText(Messages.CreateRepresentationFromSessionAction_wizardTitle);
            dialog.open();
        }
    }
}

