/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.tests.support.api;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.function.Function;
import java.util.function.Predicate;
import junit.framework.TestCase;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IItemLabelProvider;

public abstract class AbstractItemProviderAdapterFactoryRegistryTestCase
extends TestCase {
    private static final String THE_ITEM_PROVIDER_ADAPTER_FACTORY_OF_THE_PACKAGE = "The item provider adapter factory of the package ";
    private final ComposedAdapterFactory.Descriptor.Registry registry = ComposedAdapterFactory.Descriptor.Registry.INSTANCE;
    private final Collection<EPackage> exposedItemProvidersAdapterFactories = new LinkedHashSet<EPackage>();
    private final Collection<EPackage> nonExposedItemProvidersAdapterFactories = new LinkedHashSet<EPackage>();
    private EPackage basePackage;
    private final Predicate<EPackage> shouldBeExposed = input -> this.exposedItemProvidersAdapterFactories.contains(input);
    private final Predicate<EPackage> shouldNotBeExposed = input -> this.nonExposedItemProvidersAdapterFactories.contains(input);
    private final Function<EPackage, Collection<?>> getKey = new Function<EPackage, Collection<?>>(){

        @Override
        public Collection<?> apply(EPackage from) {
            ArrayList<Object> key = new ArrayList<Object>();
            key.add(from);
            key.add(IItemLabelProvider.class);
            return key;
        }
    };

    public EPackage getBasePackage() {
        return this.basePackage;
    }

    public void setBasePackage(EPackage basePackage) {
        this.basePackage = basePackage;
    }

    public void setPackagesWithExposedAdapterFactory(Collection<EPackage> packages) {
        this.exposedItemProvidersAdapterFactories.addAll(packages);
    }

    public void setPackagesWithNonExposedAdapterFactory(Collection<EPackage> packages) {
        this.nonExposedItemProvidersAdapterFactories.addAll(packages);
    }

    public abstract void initPackages();

    protected void setUp() throws Exception {
        this.initPackages();
        super.setUp();
        TestCase.assertNotNull((String)"Base package should not be null.", (Object)this.basePackage);
    }

    public void testExposedAdapterFactories() {
        this.testEPackageExposed(this.basePackage);
    }

    private void testEPackageExposed(EPackage pkg) {
        boolean notExposedExpected;
        ComposedAdapterFactory.Descriptor descriptor = this.registry.getDescriptor(this.getKey.apply(pkg));
        String label = pkg.getName() + " (" + pkg.getNsURI() + ") ";
        boolean exposedExpected = this.shouldBeExposed.test(pkg);
        if (exposedExpected) {
            TestCase.assertNotNull((String)(THE_ITEM_PROVIDER_ADAPTER_FACTORY_OF_THE_PACKAGE + label + "should be exposed."), (Object)descriptor);
            AdapterFactory adapterFactory = descriptor.createAdapterFactory();
            TestCase.assertNotNull((String)("Error creating while creating the item provider adapter factory of the package " + label), (Object)adapterFactory);
        }
        if (notExposedExpected = this.shouldNotBeExposed.test(pkg)) {
            TestCase.assertNull((String)(THE_ITEM_PROVIDER_ADAPTER_FACTORY_OF_THE_PACKAGE + label + "should not be exposed."), (Object)descriptor);
        }
        if (exposedExpected && notExposedExpected || !exposedExpected && !notExposedExpected) {
            TestCase.fail((String)(THE_ITEM_PROVIDER_ADAPTER_FACTORY_OF_THE_PACKAGE + label + "is not known or invalid for the current test. Please check with the team if it should be exposed or not and then complete the test."));
        }
        for (EPackage subPkg : pkg.getESubpackages()) {
            this.testEPackageExposed(subPkg);
        }
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.exposedItemProvidersAdapterFactories.clear();
        this.basePackage = null;
    }
}

