/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.table.model.business.internal.operations;

import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.sirius.table.metamodel.table.DCell;
import org.eclipse.sirius.table.metamodel.table.DColumn;
import org.eclipse.sirius.table.metamodel.table.DLine;
import org.eclipse.sirius.table.metamodel.table.DTable;
import org.eclipse.sirius.table.metamodel.table.LineContainer;
import org.eclipse.sirius.table.model.internal.Messages;

public final class DColumnOperations {
    private DColumnOperations() {
    }

    public static Collection<DCell> getOrderedCells(DColumn column) {
        HashMap<DLine, Integer> lineIndices = new HashMap<DLine, Integer>();
        DTable table = column.getTable();
        if (table != null) {
            DColumnOperations.fillIndices(table, lineIndices, 0);
        }
        Comparator comparator = (a, b) -> {
            int result = 0;
            DLine lineA = a.getLine();
            DLine lineB = b.getLine();
            if (lineA == null) {
                result = -1;
            } else if (lineB == null) {
                result = 1;
            } else {
                Integer aIndex = (Integer)lineIndices.get(lineA);
                Integer bIndex = (Integer)lineIndices.get(lineB);
                if (aIndex == null || bIndex == null) {
                    throw new RuntimeException(Messages.Table_UnexpectedExceptionMessage);
                }
                return aIndex - bIndex;
            }
            return result;
        };
        return column.getCells().stream().sorted(comparator).toList();
    }

    private static int fillIndices(LineContainer container, Map<DLine, Integer> lineIndices, int i) {
        int j = i;
        for (DLine line : container.getLines()) {
            if (line.getContainer() != null) {
                lineIndices.put(line, j);
            } else {
                lineIndices.put(line, -1);
            }
            ++j;
            j = DColumnOperations.fillIndices(line, lineIndices, j);
        }
        return j;
    }
}

