/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.common.tools.api.profiler;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.Date;
import java.util.EmptyStackException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.sirius.common.tools.DslCommonPlugin;
import org.eclipse.sirius.common.tools.api.profiler.ProfilerTask;
import org.eclipse.sirius.common.tools.api.profiler.TimeProfiler;
import org.eclipse.sirius.ext.base.collect.StackEx;

public class TimeProfiler2
extends TimeProfiler {
    public static final ProfilerTask OTHER_TASK = new ProfilerTask("Other", "Other");
    private List<CompositeTask> roots;
    private StackEx<CompositeTask> runningTasks;
    private Map<CompositeTask, Date> runningTasksTime;

    @Override
    public void init() {
        super.init();
        if (this.runningTasks != null) {
            this.runningTasks.clear();
        } else {
            this.runningTasks = new StackEx();
        }
        if (this.runningTasksTime != null) {
            this.runningTasksTime.clear();
        } else {
            this.runningTasksTime = new HashMap<CompositeTask, Date>();
        }
        if (this.roots != null) {
            this.roots.clear();
        } else {
            this.roots = new LinkedList<CompositeTask>();
        }
    }

    @Override
    public int getCountTask(ProfilerTask task) {
        return super.getCountTask(task);
    }

    @Override
    public String getStatus() {
        Set timeSet = this.times.entrySet();
        StringBuffer result = new StringBuffer(timeSet.size() * 100);
        if (this.isActive) {
            for (Map.Entry entry : timeSet) {
                StringBuffer line = new StringBuffer("\n  " + String.valueOf(entry.getKey()) + "  :");
                CompositeTask compositeTask = this.getCompositeTask((ProfilerTask)entry.getKey());
                if (compositeTask != null) {
                    line.append(compositeTask.getOccurences());
                    line.append(" occurences for ");
                }
                line.append(this.getMissingSpacesForAlignment(line.toString(), 150));
                line.append(((Long)entry.getValue()).toString());
                line.append(this.getMissingSpacesForAlignment(line.toString(), 160));
                line.append(" ms");
                result.append(line);
            }
        }
        return result.toString();
    }

    public List<CompositeTask> getRoots() {
        return this.roots;
    }

    @Override
    public long getTimeEllapsed(ProfilerTask task) {
        return super.getTimeEllapsed(task);
    }

    @Override
    public void startWork(ProfilerTask task) {
        super.startWork(task);
        if (this.isActive()) {
            Date start = new Date();
            if (this.runningTasks.isEmpty()) {
                CompositeTask compositeTask = this.getCompositeTask(task);
                for (CompositeTask current : this.getRoots()) {
                    if (current.getProfilerTask() != task) continue;
                    compositeTask = current;
                }
                if (compositeTask == null) {
                    compositeTask = new CompositeTask(task);
                    this.roots.add(compositeTask);
                }
                this.runningTasks.push((Object)compositeTask);
                this.runningTasksTime.put(compositeTask, start);
                compositeTask.addOccurence();
            } else {
                CompositeTask runningTask = (CompositeTask)this.runningTasks.peek();
                CompositeTask newTask = runningTask.findOrCreateChild(task);
                this.runningTasks.push((Object)newTask);
                this.runningTasksTime.put(newTask, start);
                newTask.addOccurence();
            }
        }
    }

    private CompositeTask getCompositeTask(ProfilerTask task) {
        CompositeTask result = null;
        Iterator<CompositeTask> iterRoots = this.getRoots().iterator();
        while (iterRoots.hasNext() && result == null) {
            CompositeTask current = iterRoots.next();
            if (current.getProfilerTask() == task) {
                result = current;
                continue;
            }
            if (current.getChildren().size() <= 0) continue;
            result = this.internalGetCompositeTask(current, task);
        }
        return result;
    }

    private CompositeTask internalGetCompositeTask(CompositeTask parent, ProfilerTask task) {
        CompositeTask result = null;
        for (CompositeTask next : parent.getChildren()) {
            if (!(next instanceof CompositeTask)) continue;
            if (next.getProfilerTask() == task) {
                result = next;
                continue;
            }
            if (next.getChildren().size() <= 0) continue;
            result = this.internalGetCompositeTask(next, task);
        }
        return result;
    }

    @Override
    public void stopWork(ProfilerTask task) {
        try {
            super.stopWork(task);
            if (this.isActive() && !this.runningTasks.isEmpty()) {
                Date stop = new Date();
                CompositeTask runningTask = (CompositeTask)this.runningTasks.pop();
                if (runningTask.getProfilerTask() != task) {
                    this.runningTasks.push((Object)runningTask);
                    this.stopWork(runningTask.getProfilerTask());
                    if (!this.runningTasks.isEmpty()) {
                        this.stopWork(task);
                    }
                    return;
                }
                Date start = this.runningTasksTime.get(runningTask);
                long time = stop.getTime() - start.getTime();
                runningTask.addTime(time);
                runningTask.stopTask();
            }
        }
        catch (EmptyStackException e) {
            DslCommonPlugin.getDefault().error(MessageFormat.format("Empty stack in stopWork. Stopped task: {0}", task.toString()), e);
        }
    }

    public static class CompositeTask {
        private ProfilerTask profilerTask;
        private long ellapsedTime;
        private int occurences;
        private long min;
        private long max;
        private Map<ProfilerTask, CompositeTask> children;
        private CompositeTask parent;

        public CompositeTask(ProfilerTask task) {
            this.profilerTask = task;
            this.children = new HashMap<ProfilerTask, CompositeTask>();
        }

        public void addTime(long time) {
            if (time < this.min || this.min == 0L) {
                this.min = time;
            }
            if (time > this.max || this.max == 0L) {
                this.max = time;
            }
            this.ellapsedTime += time;
        }

        public void addOccurence() {
            ++this.occurences;
        }

        public CompositeTask findOrCreateChild(ProfilerTask task) {
            CompositeTask child = this.children.get(task);
            if (child == null) {
                child = new CompositeTask(task);
                child.parent = this;
                this.children.put(task, child);
            }
            return child;
        }

        public long getEllapsedTime() {
            return this.ellapsedTime;
        }

        public int getOccurences() {
            return this.occurences;
        }

        public ProfilerTask getProfilerTask() {
            return this.profilerTask;
        }

        public Collection<CompositeTask> getChildren() {
            return this.children.values();
        }

        public void stopTask() {
            int childTime = 0;
            if (!this.getChildren().isEmpty()) {
                for (CompositeTask currentChild : this.getChildren()) {
                    childTime = (int)((long)childTime + currentChild.getEllapsedTime());
                }
                if ((long)childTime < this.ellapsedTime) {
                    CompositeTask compositeTask = this.findOrCreateChild(OTHER_TASK);
                    compositeTask.addTime(this.ellapsedTime - (long)childTime);
                }
            }
        }

        public CompositeTask getParent() {
            return this.parent;
        }

        public long getMin() {
            return this.min;
        }

        public long getMax() {
            return this.max;
        }
    }
}

