/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.eef.properties.ui.legacy.internal.extension.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.eef.properties.ui.api.IEEFTabDescriptor;

public class LegacyPropertyTabSorter {
    public List<IEEFTabDescriptor> sortTabsByAfterTab(Collection<IEEFTabDescriptor> tabs) {
        ArrayList<IEEFTabDescriptor> sorted = new ArrayList<IEEFTabDescriptor>(tabs);
        ArrayList<IEEFTabDescriptor> processed = new ArrayList<IEEFTabDescriptor>();
        int lastIndex = sorted.size() - 1;
        int i = 0;
        while (i <= lastIndex) {
            IEEFTabDescriptor lastUnprocessedTab = this.getLastUnprocessedTab(sorted, processed);
            if (lastUnprocessedTab != null) {
                String lastUnprocessedTabId = lastUnprocessedTab.getId();
                if (!this.isNullEmpty(lastUnprocessedTabId)) {
                    for (IEEFTabDescriptor tab : tabs) {
                        if (!lastUnprocessedTabId.equals(tab.getAfterTab())) continue;
                        sorted.remove(tab);
                        sorted.add(sorted.indexOf(lastUnprocessedTab) + 1, tab);
                    }
                }
                processed.add(lastUnprocessedTab);
            }
            ++i;
        }
        int index = 0;
        for (IEEFTabDescriptor tab : tabs) {
            String afterTab = tab.getAfterTab();
            if (!this.isNullEmpty(afterTab) && !this.isTop(afterTab)) continue;
            sorted.remove(tab);
            sorted.add(index, tab);
            ++index;
        }
        return sorted;
    }

    private IEEFTabDescriptor getLastUnprocessedTab(List<IEEFTabDescriptor> tabs, List<IEEFTabDescriptor> processed) {
        int i = tabs.size() - 1;
        while (i >= 0) {
            IEEFTabDescriptor lastUnprocessedTab = tabs.get(i);
            if (!processed.contains(lastUnprocessedTab)) {
                return lastUnprocessedTab;
            }
            --i;
        }
        return null;
    }

    private boolean isNullEmpty(String id) {
        return id == null || id.isEmpty();
    }

    private boolean isTop(String afterTab) {
        return "top".equals(afterTab);
    }
}

