/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.internal.session.danalysis;

import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.sirius.business.api.dialect.DialectManager;
import org.eclipse.sirius.business.api.dialect.command.DeleteRepresentationCommand;
import org.eclipse.sirius.business.api.query.ResourceQuery;
import org.eclipse.sirius.business.api.session.ReloadingPolicy;
import org.eclipse.sirius.business.internal.session.danalysis.AnalysisResourceReloadedCommand;
import org.eclipse.sirius.business.internal.session.danalysis.DAnalysisSessionImpl;
import org.eclipse.sirius.common.tools.api.resource.ResourceSetSync;
import org.eclipse.sirius.common.tools.api.resource.ResourceSyncClient;
import org.eclipse.sirius.tools.api.Messages;
import org.eclipse.sirius.tools.api.SiriusPlugin;
import org.eclipse.sirius.tools.api.command.semantic.RemoveSemanticResourceCommand;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.sirius.viewpoint.SyncStatus;

public class SessionResourcesSynchronizer
implements ResourceSyncClient {
    private final DAnalysisSessionImpl session;

    public SessionResourcesSynchronizer(DAnalysisSessionImpl session) {
        this.session = Objects.requireNonNull(session);
    }

    public void statusChanged(Resource resource, ResourceSetSync.ResourceStatus oldStatus, ResourceSetSync.ResourceStatus newStatus) {
    }

    public void statusesChanged(Collection<ResourceSyncClient.ResourceStatusChange> changes) {
        if (this.session.isOpen()) {
            Multimap<ResourceSetSync.ResourceStatus, Resource> newStatuses = this.getImpactingNewStatuses(changes);
            boolean allResourcesSync = this.allResourcesAreInSync();
            for (ResourceSetSync.ResourceStatus newStatus : newStatuses.keySet()) {
                switch (newStatus) {
                    case SYNC: {
                        if (!allResourcesSync) break;
                        this.session.notifyListeners(3);
                        break;
                    }
                    case CHANGED: {
                        this.session.notifyListeners(2);
                        break;
                    }
                    case EXTERNAL_CHANGED: 
                    case CONFLICTING_CHANGED: 
                    case CONFLICTING_DELETED: 
                    case DELETED: 
                    case CHANGES_CANCELED: {
                        NullProgressMonitor pm = new NullProgressMonitor();
                        for (Resource resource : newStatuses.get((Object)newStatus)) {
                            try {
                                if (this.isInProjectDeletedRenamedOrClosed(resource)) {
                                    this.processAction(ReloadingPolicy.Action.CLOSE_SESSION, resource, (IProgressMonitor)pm);
                                    return;
                                }
                                this.processActions(this.session.getReloadingPolicy().getActions(this.session, resource, newStatus), resource, (IProgressMonitor)pm);
                            }
                            catch (Exception e) {
                                SiriusPlugin.getDefault().error(MessageFormat.format(Messages.SessionResourcesSynchronizer_cantHandleResourceChangeMsg, resource.getURI()), e);
                            }
                        }
                        allResourcesSync = this.allResourcesAreInSync();
                        if (allResourcesSync) {
                            this.session.notifyListeners(3);
                            break;
                        }
                        this.session.notifyListeners(2);
                        break;
                    }
                }
            }
            if (allResourcesSync) {
                this.session.setSynchronizationStatus(SyncStatus.SYNC);
            } else {
                this.session.setSynchronizationStatus(SyncStatus.DIRTY);
            }
        }
    }

    private boolean isInProjectDeletedRenamedOrClosed(Resource resource) {
        IProject project;
        IFile file = WorkspaceSynchronizer.getFile((Resource)resource);
        if (file != null && (project = file.getProject()) != null) {
            return !project.exists() || !project.isOpen();
        }
        return false;
    }

    private void processActions(List<ReloadingPolicy.Action> actions, Resource resource, IProgressMonitor pm) throws Exception {
        for (ReloadingPolicy.Action action : actions) {
            this.processAction(action, resource, pm);
        }
    }

    private void processAction(ReloadingPolicy.Action action, Resource resource, IProgressMonitor pm) throws Exception {
        switch (action) {
            case CLOSE_SESSION: {
                this.session.close(pm);
                break;
            }
            case RELOAD: {
                if (!this.session.isOpen()) break;
                this.reloadResource(resource);
                break;
            }
            case REMOVE: {
                this.removeResourceFromSession(resource, pm);
                break;
            }
        }
    }

    private void reloadResource(final Resource resource) throws IOException {
        this.session.notifyListeners(4);
        TransactionalEditingDomain ted = this.session.getTransactionalEditingDomain();
        AnalysisResourceReloadedCommand reloadingAnalysisCmd = null;
        ResourceQuery resourceQuery = new ResourceQuery(resource);
        boolean representationsResource = resourceQuery.isRepresentationsResource();
        if (representationsResource) {
            reloadingAnalysisCmd = new AnalysisResourceReloadedCommand(this.session, ted, resource);
        }
        ArrayList<Resource> resourcesBeforeReload = new ArrayList<Resource>((Collection<Resource>)ted.getResourceSet().getResources());
        RecordingCommand reload = new RecordingCommand(ted){
            IStatus result;

            protected void doExecute() {
                SessionResourcesSynchronizer.this.session.disableCrossReferencerResolve(resource);
                resource.unload();
                SessionResourcesSynchronizer.this.session.enableCrossReferencerResolve(resource);
                try {
                    resource.load(Collections.EMPTY_MAP);
                    EcoreUtil.resolveAll((Resource)resource);
                    SessionResourcesSynchronizer.this.session.getSemanticCrossReferencer().resolveProxyCrossReferences(resource);
                    this.result = Status.OK_STATUS;
                }
                catch (IOException e) {
                    this.result = new Status(4, "org.eclipse.sirius", e.getMessage(), (Throwable)e);
                }
            }

            public Collection<?> getResult() {
                return Collections.singleton(this.result);
            }
        };
        ted.getCommandStack().execute((Command)reload);
        IStatus result = (IStatus)reload.getResult().iterator().next();
        if (!result.isOK()) {
            if (result.getException() instanceof IOException) {
                throw (IOException)result.getException();
            }
            SiriusPlugin.getDefault().error(Messages.SessionResourcesSynchronizer_reloadOperationFailErrorMsg, null);
        } else {
            if (representationsResource) {
                ted.getCommandStack().execute((Command)reloadingAnalysisCmd);
                if (resource.getURI().equals(this.session.getSessionResource().getURI())) {
                    this.session.sessionResourceReloaded(resource);
                }
            }
            this.session.discoverAutomaticallyLoadedResources(resourcesBeforeReload);
            this.session.notifyListeners(5);
        }
    }

    private void removeResourceFromSession(Resource resource, IProgressMonitor pm) {
        if (this.session.getSrmResources().contains(resource)) {
            Set<DRepresentationDescriptor> descriptors2Delete = DialectManager.INSTANCE.getAllRepresentationDescriptors(this.session).stream().filter(descriptor -> resource.equals(descriptor.getRepresentation().eResource())).collect(Collectors.toSet());
            DeleteRepresentationCommand command = new DeleteRepresentationCommand(this.session, descriptors2Delete);
            this.session.getTransactionalEditingDomain().getCommandStack().execute((Command)command);
        } else if (this.session.getAllSemanticResources().contains(resource)) {
            this.session.getTransactionalEditingDomain().getCommandStack().execute((Command)new RemoveSemanticResourceCommand(this.session, resource, (IProgressMonitor)new NullProgressMonitor(), false));
        } else if (this.session.getAllSessionResources().contains(resource)) {
            this.session.removeAnalysis(resource);
        }
        if (this.session.getResources().contains((Object)resource)) {
            resource.getContents().stream().forEach(EcoreUtil::remove);
            this.session.getResources().remove((Object)resource);
        }
        if (this.session.getAllSessionResources().isEmpty()) {
            this.session.close(pm);
        }
    }

    protected boolean allResourcesAreInSync() {
        return this.checkResourcesAreInSync(this.getAllSessionResources());
    }

    protected boolean checkResourcesAreInSync(Iterable<? extends Resource> resourcesToConsider) {
        boolean allResourceAreInSync = true;
        for (Resource resource : resourcesToConsider) {
            ResourceSetSync.ResourceStatus status = ResourceSetSync.getStatus((Resource)resource);
            boolean bl = allResourceAreInSync = status == ResourceSetSync.ResourceStatus.SYNC || !resource.isModified();
            if (!allResourceAreInSync) break;
        }
        return allResourceAreInSync;
    }

    private Multimap<ResourceSetSync.ResourceStatus, Resource> getImpactingNewStatuses(Collection<ResourceSyncClient.ResourceStatusChange> changes) {
        LinkedHashMultimap impactingNewStatuses = LinkedHashMultimap.create();
        LinkedHashMultimap representationResourcesNewStatuses = LinkedHashMultimap.create();
        Iterable<Resource> semanticOrControlledresources = this.getAllSemanticResources();
        Set<Resource> representationResources = this.session.getAllSessionResources();
        Collection<Resource> repFiles = this.session.getSrmResources();
        for (ResourceSyncClient.ResourceStatusChange change : changes) {
            if (this.session.isResourceOfSession(change.getResource(), semanticOrControlledresources)) {
                impactingNewStatuses.put((Object)change.getNewStatus(), (Object)change.getResource());
                continue;
            }
            if (this.session.isResourceOfSession(change.getResource(), representationResources)) {
                representationResourcesNewStatuses.put((Object)change.getNewStatus(), (Object)change.getResource());
                continue;
            }
            if (!this.session.isResourceOfSession(change.getResource(), repFiles)) continue;
            representationResourcesNewStatuses.put((Object)change.getNewStatus(), (Object)change.getResource());
        }
        impactingNewStatuses.putAll((Multimap)representationResourcesNewStatuses);
        return impactingNewStatuses;
    }

    private Iterable<Resource> getAllSessionResources() {
        return Iterables.concat(this.session.getSemanticResources(), this.session.getAllSessionResources(), (Iterable)this.session.getControlledResources(), this.session.getSrmResources());
    }

    private Iterable<Resource> getAllSemanticResources() {
        return Iterables.concat(this.session.getSemanticResources(), (Iterable)this.session.getControlledResources());
    }
}

