/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.internal.image;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.sirius.business.api.dialect.DialectManager;
import org.eclipse.sirius.business.api.image.RichTextAttributeRegistry;
import org.eclipse.sirius.business.internal.query.SiriusSessionQuery;
import org.eclipse.sirius.business.internal.session.danalysis.DAnalysisSessionImpl;
import org.eclipse.sirius.common.tools.api.resource.FileProvider;
import org.eclipse.sirius.viewpoint.DAnalysis;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.sirius.viewpoint.DRepresentationElement;
import org.eclipse.sirius.viewpoint.description.DAnnotationEntry;
import org.eclipse.sirius.viewpoint.description.DescriptionFactory;

public final class ImageDependenciesAnnotationHelper {
    public static final String IMAGES_DEPENDENCIES_ANNOTATION_SOURCE_NAME = "ImagesDependencies";
    public static final String SEPARATOR = ":";
    public static final String WORKSPACE_IMAGE_CLASS_NAME = "WorkspaceImage";
    public static final String WORKSPACE_PATH_FEATURE_NAME = "workspacePath";
    private static final String RICH_TEXT_KEY = "RichText";
    private DAnalysisSessionImpl session;
    private String currentProjectName;

    public ImageDependenciesAnnotationHelper(DAnalysisSessionImpl session) {
        this.session = session;
    }

    public static Set<String> getAllImageProjectsDirectDependencies(DAnalysis dAnalysis) {
        Set projectDependencies = ImageDependenciesAnnotationHelper.getImagesDependenciesAnnotationEntry(dAnalysis).map(DAnnotationEntry::getDetails).stream().flatMap(Collection::stream).map(dep -> dep.split(SEPARATOR)[1]).collect(Collectors.toCollection(TreeSet::new));
        return projectDependencies;
    }

    private DAnnotationEntry getOrCreateImagesDependenciesAnnotationEntry() {
        DAnnotationEntry dAnnotationEntry = null;
        Optional<DAnalysis> sharedMainDAnalysis = this.session.getSharedMainDAnalysis();
        if (sharedMainDAnalysis.isPresent()) {
            dAnnotationEntry = ImageDependenciesAnnotationHelper.getImagesDependenciesAnnotationEntry(sharedMainDAnalysis.get()).orElseGet(() -> {
                DAnnotationEntry annotationEntry = this.createImagesDependenciesDAnnotationEntry();
                return annotationEntry;
            });
        }
        return dAnnotationEntry;
    }

    private boolean hasImageDependenciesAnnotationEntry() {
        return this.session.getSharedMainDAnalysis().flatMap(dAnalysis -> ImageDependenciesAnnotationHelper.getImagesDependenciesAnnotationEntry(dAnalysis)).isPresent();
    }

    public static Optional<DAnnotationEntry> getImagesDependenciesAnnotationEntry(DAnalysis dAnalysis) {
        EList sessionAnnotations = dAnalysis.getEAnnotations();
        for (DAnnotationEntry annotationEntry : sessionAnnotations) {
            if (!annotationEntry.getSource().equals(IMAGES_DEPENDENCIES_ANNOTATION_SOURCE_NAME)) continue;
            return Optional.of(annotationEntry);
        }
        return Optional.empty();
    }

    private void removeMainDAnalysisDAnnotationEntry() {
        Optional<DAnalysis> sharedMainDAnalysis;
        if (this.hasImageDependenciesAnnotationEntry() && (sharedMainDAnalysis = this.session.getSharedMainDAnalysis()).isPresent()) {
            EList sessionAnnotations = sharedMainDAnalysis.get().getEAnnotations();
            sessionAnnotations.remove((Object)this.getOrCreateImagesDependenciesAnnotationEntry());
        }
    }

    private String getDetailsForDiagramToImageDependencyEntry(DAnnotationEntry annotationEntry, String expectedKey, String expectedProjectName) {
        if (IMAGES_DEPENDENCIES_ANNOTATION_SOURCE_NAME.equals(annotationEntry.getSource())) {
            for (String details : annotationEntry.getDetails()) {
                String[] detailsSplit = details.split(SEPARATOR);
                if (detailsSplit.length != 2) continue;
                String key = detailsSplit[0].trim();
                String imageProject = detailsSplit[1];
                if (!key.equals(expectedKey) || !imageProject.equals(expectedProjectName)) continue;
                return details;
            }
        }
        return "";
    }

    private DAnnotationEntry createImagesDependenciesDAnnotationEntry() {
        DAnnotationEntry annotationEntry = DescriptionFactory.eINSTANCE.createDAnnotationEntry();
        annotationEntry.setSource(IMAGES_DEPENDENCIES_ANNOTATION_SOURCE_NAME);
        return annotationEntry;
    }

    private String createDetailsForDAnnotationEntry(DAnnotationEntry annotationEntry, String key, String projectName) {
        String detailsItem = String.valueOf(key) + SEPARATOR + projectName;
        annotationEntry.getDetails().add((Object)detailsItem);
        return detailsItem;
    }

    public void updateAllImageProjectsDependencies() {
        if (this.hasImageDependenciesAnnotationEntry()) {
            this.getOrCreateImagesDependenciesAnnotationEntry().getDetails().clear();
        }
        HashMap<DRepresentation, List<String>> diagramToImageProjectDependencies = new HashMap<DRepresentation, List<String>>();
        this.findImagePathInRichTextDescription(diagramToImageProjectDependencies);
        this.findImagePathInWorkspaceImage(diagramToImageProjectDependencies);
        this.addImageDependencyAnnotationDetails(diagramToImageProjectDependencies);
    }

    private void findImagePathInRichTextDescription(Map<DRepresentation, List<String>> diagramToNewImageDependency) {
        for (Resource resource : this.session.getSemanticResources()) {
            EcoreUtil.getAllProperContents((Resource)resource, (boolean)true).forEachRemaining(object -> {
                if (object instanceof EObject) {
                    this.findImagePathInRichText((EObject)object, diagramToNewImageDependency);
                }
            });
        }
        for (DRepresentationDescriptor repDescriptor : DialectManager.INSTANCE.getAllRepresentationDescriptors(this.session)) {
            this.findImagePathInRichText((EObject)repDescriptor, diagramToNewImageDependency);
        }
    }

    private void findImagePathInRichText(EObject eObject, Map<DRepresentation, List<String>> diagramToNewImageDependency) {
        Set<EAttribute> richTextAttributes = RichTextAttributeRegistry.INSTANCE.getEAttributes();
        Pattern pattern = Pattern.compile("<img.*?src=\"(.*?)\".*?/>");
        List attributesToCheck = eObject.eClass().getEAllAttributes().stream().filter(richTextAttributes::contains).collect(Collectors.toList());
        for (EAttribute eAttribute : attributesToCheck) {
            Object stringObj = eObject.eGet((EStructuralFeature)eAttribute);
            if (!(stringObj instanceof String)) continue;
            String htmlText = (String)stringObj;
            Matcher matcher = pattern.matcher(htmlText);
            while (matcher.find()) {
                String imagePath = matcher.group(1);
                this.getProjectFromImagePath(imagePath).ifPresent(projectName -> this.addProjectDependency(diagramToNewImageDependency, null, (String)projectName));
            }
        }
    }

    private void addProjectDependency(Map<DRepresentation, List<String>> diagramToNewImageDependency, DRepresentation key, String projectName) {
        List projectNames = Optional.ofNullable(diagramToNewImageDependency.get(key)).orElseGet(ArrayList::new);
        if (!projectNames.contains(projectName)) {
            projectNames.add(projectName);
        }
        if (!projectNames.isEmpty()) {
            diagramToNewImageDependency.put(key, projectNames);
        }
    }

    private void findImagePathInWorkspaceImage(Map<DRepresentation, List<String>> diagramToNewImageDependency) {
        for (DRepresentation representation : DialectManager.INSTANCE.getAllRepresentations(this.session)) {
            Iterable it = () -> representation.eAllContents();
            StreamSupport.stream(it.spliterator(), false).filter(object -> object.eClass().getName().equals(WORKSPACE_IMAGE_CLASS_NAME)).forEach(object -> {
                EStructuralFeature feature = object.eClass().getEStructuralFeature(WORKSPACE_PATH_FEATURE_NAME);
                Object imagePath = object.eGet(feature);
                if (imagePath instanceof String) {
                    this.getProjectFromImagePath((String)imagePath).ifPresent(projectName -> this.addProjectDependency(diagramToNewImageDependency, representation, (String)projectName));
                }
            });
        }
    }

    public void addImageDependencyAnnotationDetails(Map<DRepresentation, List<String>> diagramToNewImageDependency) {
        Optional<DAnalysis> sharedMainDAnalysis;
        DAnnotationEntry imageDependenciesEntry = this.getOrCreateImagesDependenciesAnnotationEntry();
        diagramToNewImageDependency.entrySet().stream().forEach(entry -> {
            DRepresentation dRepresentation = (DRepresentation)entry.getKey();
            List projectNames = (List)entry.getValue();
            for (String projectName : projectNames) {
                String dRepresentationString;
                String optDetailsEntry;
                if (this.getCurrentProjectName().equals(projectName) || !(optDetailsEntry = this.getDetailsForDiagramToImageDependencyEntry(imageDependenciesEntry, dRepresentationString = dRepresentation != null ? dRepresentation.getUid() : RICH_TEXT_KEY, projectName)).isEmpty()) continue;
                this.createDetailsForDAnnotationEntry(imageDependenciesEntry, dRepresentationString, projectName);
            }
        });
        if (imageDependenciesEntry.getDetails().size() == 0) {
            this.removeMainDAnalysisDAnnotationEntry();
        } else if (!this.hasImageDependenciesAnnotationEntry() && (sharedMainDAnalysis = this.session.getSharedMainDAnalysis()).isPresent()) {
            sharedMainDAnalysis.get().getEAnnotations().add((Object)imageDependenciesEntry);
        }
    }

    public void removeImageDependencyAnnotationDetails(Map<DRepresentation, List<String>> diagramToOldImageDependency) {
        if (!this.hasImageDependenciesAnnotationEntry()) {
            return;
        }
        diagramToOldImageDependency.entrySet().stream().forEach(entry -> {
            DRepresentation dRepresentation = (DRepresentation)entry.getKey();
            List projectNames = (List)entry.getValue();
            ArrayList notAlreadyExistingImageDependencyProjects = new ArrayList(projectNames);
            for (DRepresentationElement element : dRepresentation.getRepresentationElements()) {
                EStructuralFeature eStructuralFeature;
                if (!this.isWorkspaceImageInstance(element.getStyle()) || (eStructuralFeature = element.getStyle().eClass().getEStructuralFeature(WORKSPACE_PATH_FEATURE_NAME)) == null) continue;
                String imagePath = (String)element.getStyle().eGet(eStructuralFeature);
                projectNames.stream().filter(projectName -> imagePath.startsWith((String)projectName)).findAny().ifPresent(projectName -> notAlreadyExistingImageDependencyProjects.remove(projectName));
                if (notAlreadyExistingImageDependencyProjects.isEmpty()) break;
            }
            DAnnotationEntry imageDependenciesEntry = this.getOrCreateImagesDependenciesAnnotationEntry();
            for (String projectName2 : notAlreadyExistingImageDependencyProjects) {
                String detailsEntry = this.getDetailsForDiagramToImageDependencyEntry(imageDependenciesEntry, dRepresentation.getUid(), projectName2);
                if (detailsEntry.isEmpty()) continue;
                imageDependenciesEntry.getDetails().remove((Object)detailsEntry);
                if (!imageDependenciesEntry.getDetails().isEmpty()) continue;
                this.removeMainDAnalysisDAnnotationEntry();
            }
        });
    }

    public boolean isWorkspaceImageInstance(Object object) {
        return object instanceof EObject && ((EObject)object).eClass().getName().equals(WORKSPACE_IMAGE_CLASS_NAME);
    }

    public Optional<String> getProjectFromImagePath(String imagePath) {
        if (imagePath == null || imagePath.isBlank()) {
            return Optional.empty();
        }
        boolean exists = FileProvider.getDefault().exists((IPath)new Path(imagePath), (Object)this.session);
        String projectName = null;
        if (exists) {
            String path;
            String[] split;
            URI uri = URI.createURI((String)imagePath);
            String cdoPrefix = "cdo:/";
            if ((uri.scheme() == null || imagePath.startsWith(cdoPrefix)) && !imagePath.startsWith("/") && (split = (path = imagePath.startsWith(cdoPrefix) ? imagePath.substring(cdoPrefix.length()) : imagePath).split("/")).length > 0) {
                projectName = split[0];
            }
        }
        return Optional.ofNullable(URI.decode(projectName));
    }

    public String getCurrentProjectName() {
        if (this.currentProjectName == null) {
            this.currentProjectName = new SiriusSessionQuery(this.session).getSharedProjectName();
        }
        return this.currentProjectName;
    }
}

